/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownCodeFenceImpl
extends CompositePsiElement
implements PsiLanguageInjectionHost,
MarkdownPsiElement {
    public MarkdownCodeFenceImpl(IElementType type) {
        super(type);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            MarkdownCodeFenceImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor).visitCodeFence(this);
            return;
        }
        super.accept(visitor);
    }

    @Nullable
    public String getFenceLanguage() {
        PsiElement element2 = this.findPsiChildByType(MarkdownTokenTypes.FENCE_LANG);
        if (element2 == null) {
            return null;
        }
        return element2.getText();
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                if (!MarkdownCodeFenceImpl.this.isValid()) {
                    return null;
                }
                return "Code Fence";
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownCodeFenceImpl.this.isValid()) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                List<PsiElement> elements = MarkdownCodeFenceUtils.getContent(MarkdownCodeFenceImpl.this, false);
                if (elements == null) {
                    return "";
                }
                for (PsiElement element2 : elements) {
                    if (sb.length() > 0) {
                        sb.append("\\n");
                    }
                    sb.append(element2.getText());
                    if (sb.length() < 50) continue;
                    break;
                }
                return sb.toString();
            }
        };
    }

    public boolean isValidHost() {
        return MarkdownCodeFenceUtils.isAbleToAcceptInjections(this);
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            MarkdownCodeFenceImpl.$$$reportNull$$$0(1);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new LiteralTextEscaper<PsiLanguageInjectionHost>((PsiLanguageInjectionHost)this){

            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                List<PsiElement> elements;
                if (rangeInsideHost == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outChars == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((elements = MarkdownCodeFenceUtils.getContent((MarkdownCodeFenceImpl)this.myHost, false)) == null) {
                    return true;
                }
                for (PsiElement element2 : elements) {
                    TextRange intersected = rangeInsideHost.intersection(element2.getTextRangeInParent());
                    if (intersected == null) continue;
                    outChars.append(intersected.substring(this.myHost.getText()));
                }
                return true;
            }

            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                List<PsiElement> elements;
                if (rangeInsideHost == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((elements = MarkdownCodeFenceUtils.getContent((MarkdownCodeFenceImpl)this.myHost, false)) == null) {
                    return -1;
                }
                int cur = 0;
                for (PsiElement element2 : elements) {
                    TextRange intersected = rangeInsideHost.intersection(element2.getTextRangeInParent());
                    if (intersected == null || intersected.isEmpty()) continue;
                    if (cur + intersected.getLength() == offsetInDecoded) {
                        return intersected.getStartOffset() + intersected.getLength();
                    }
                    if (cur == offsetInDecoded) {
                        return intersected.getStartOffset();
                    }
                    if (cur < offsetInDecoded && cur + intersected.getLength() > offsetInDecoded) {
                        return intersected.getStartOffset() + (offsetInDecoded - cur);
                    }
                    cur += intersected.getLength();
                }
                PsiElement last = elements.get(elements.size() - 1);
                TextRange intersected = rangeInsideHost.intersection(last.getTextRangeInParent());
                if (intersected == null || intersected.isEmpty()) {
                    return -1;
                }
                int result = intersected.getStartOffset() + (offsetInDecoded - (cur - intersected.getLength()));
                if (rangeInsideHost.getStartOffset() <= result && result <= rangeInsideHost.getEndOffset()) {
                    return result;
                }
                return -1;
            }

            @NotNull
            public TextRange getRelevantTextRange() {
                List<PsiElement> elements = MarkdownCodeFenceUtils.getContent((MarkdownCodeFenceImpl)this.myHost, true);
                if (elements == null) {
                    TextRange textRange = MarkdownCodeFenceUtils.getEmptyRange((MarkdownCodeFenceImpl)this.myHost);
                    if (textRange == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return textRange;
                }
                PsiElement first = elements.get(0);
                PsiElement last = elements.get(elements.size() - 1);
                TextRange textRange = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
                if (textRange == null) {
                    2.$$$reportNull$$$0(4);
                }
                return textRange;
            }

            public boolean isOneLine() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeInsideHost";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outChars";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$2";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRelevantTextRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "decode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getOffsetInHost";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Manipulator
    extends AbstractElementManipulator<MarkdownCodeFenceImpl> {
        public MarkdownCodeFenceImpl handleContentChange(@NotNull MarkdownCodeFenceImpl element2, @NotNull TextRange range, String content2) throws IncorrectOperationException {
            if (element2 == null) {
                Manipulator.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Manipulator.$$$reportNull$$$0(1);
            }
            if (content2 == null) {
                return null;
            }
            if (((String)content2).contains("```") || ((String)content2).contains("~~~")) {
                MarkdownPsiElement textElement = MarkdownPsiElementFactory.createTextElement(element2.getProject(), (String)content2);
                return textElement instanceof MarkdownCodeFenceImpl ? (MarkdownCodeFenceImpl)element2.replace((PsiElement)textElement) : null;
            }
            String indent = MarkdownCodeFenceUtils.getIndent(element2);
            if (indent != null && indent.length() > 0 && StringUtil.endsWithLineBreak((CharSequence)(content2 = Arrays.stream(StringUtil.splitByLinesKeepSeparators((String)content2)).map(line -> indent + line).collect(Collectors.joining(""))))) {
                content2 = (String)content2 + indent;
            }
            return (MarkdownCodeFenceImpl)element2.replace((PsiElement)MarkdownPsiElementFactory.createCodeFence(element2.getProject(), element2.getFenceLanguage(), Objects.requireNonNull(content2), indent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$Manipulator";
            objectArray[2] = "handleContentChange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

