/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\nH$J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/lang/references/MissingExtensionFileReferenceBase;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "myFileReference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "soft", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;Z)V", "containingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "getPath", "()Ljava/lang/String;", "findReferencedFile", "handleElementRename", "newElementName", "resolve", "intellij.markdown"})
public abstract class MissingExtensionFileReferenceBase
extends PsiReferenceBase<PsiElement> {
    private final FileReference myFileReference;

    @NotNull
    protected final String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        FileReferenceSet fileReferenceSet = this.myFileReference.getFileReferenceSet();
        Intrinsics.checkNotNullExpressionValue((Object)fileReferenceSet, (String)"myFileReference.fileReferenceSet");
        StringBuilder stringBuilder2 = stringBuilder.append(fileReferenceSet.getPathString()).append('.');
        MarkdownFileType markdownFileType = MarkdownFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownFileType), (String)"MarkdownFileType.INSTANCE");
        return stringBuilder2.append(markdownFileType.getDefaultExtension()).toString();
    }

    @Nullable
    protected final VirtualFile getContainingFile() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        PsiFile psiFile = psiElement.getContainingFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement;
        VirtualFile virtualFile = this.findReferencedFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile;
        if (referencedFile.getParent().findChild(referencedFile.getNameWithoutExtension()) == null) {
            PsiElement psiElement2 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
            psiElement = (PsiElement)PsiUtilCore.getPsiFile((Project)psiElement2.getProject(), (VirtualFile)referencedFile);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected abstract VirtualFile findReferencedFile();

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        MarkdownFileType markdownFileType = MarkdownFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownFileType), (String)"MarkdownFileType.INSTANCE");
        String string = FileUtilRt.extensionEquals((String)newElementName, (String)markdownFileType.getDefaultExtension()) ? FileUtilRt.getNameWithoutExtension((String)newElementName) : newElementName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (FileUtilRt.extension\u2026     newElementName\n    }");
        String newText = string;
        PsiElement psiElement = super.handleElementRename(newText);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"super.handleElementRename(newText)");
        return psiElement;
    }

    public MissingExtensionFileReferenceBase(@NotNull PsiElement element2, @NotNull FileReference myFileReference, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)myFileReference, (String)"myFileReference");
        super(element2, myFileReference.getRangeInElement(), soft);
        this.myFileReference = myFileReference;
    }
}

