/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.messages.Topic;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsMigration;
import org.intellij.plugins.markdown.settings.MarkdownSettingsState;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.jcef.JCEFHtmlPanelProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="MarkdownSettings", storages={@Storage(value="markdown.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 I2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002HIB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0002H\u0016J\b\u0010B\u001a\u00020@H\u0016J\u0010\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0002H\u0002J\u001a\u0010E\u001a\u00020@2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020@0GR$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R(\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\fR$\u0010\"\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\fR$\u0010$\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\n\"\u0004\b%\u0010\fR$\u0010&\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fRL\u0010,\u001a\u00160(\u00a2\u0006\u0002\b)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(\u00062\u001a\u0010\u0006\u001a\u00160(\u00a2\u0006\u0002\b)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R$\u00104\u001a\u0002032\u0006\u0010\u0006\u001a\u0002038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u00106\"\u0004\b7\u00108R$\u00109\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010\n\"\u0004\b;\u0010\fR$\u0010<\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\n\"\u0004\b>\u0010\f\u00a8\u0006J"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "areInjectionsEnabled", "getAreInjectionsEnabled", "()Z", "setAreInjectionsEnabled", "(Z)V", "", "customStylesheetPath", "getCustomStylesheetPath", "()Ljava/lang/String;", "setCustomStylesheetPath", "(Ljava/lang/String;)V", "customStylesheetText", "getCustomStylesheetText", "setCustomStylesheetText", "fontFamily", "getFontFamily", "setFontFamily", "", "fontSize", "getFontSize", "()I", "setFontSize", "(I)V", "hideErrorsInCodeBlocks", "getHideErrorsInCodeBlocks", "setHideErrorsInCodeBlocks", "isAutoScrollEnabled", "setAutoScrollEnabled", "isEnhancedEditingEnabled", "setEnhancedEditingEnabled", "isVerticalSplit", "setVerticalSplit", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/ParameterName;", "name", "previewPanelProviderInfo", "getPreviewPanelProviderInfo", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "setPreviewPanelProviderInfo", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "splitLayout", "getSplitLayout", "()Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "setSplitLayout", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;)V", "useCustomStylesheetPath", "getUseCustomStylesheetPath", "setUseCustomStylesheetPath", "useCustomStylesheetText", "getUseCustomStylesheetText", "setUseCustomStylesheetText", "loadState", "", "state", "noStateLoaded", "possiblyMigrateSettings", "from", "update", "block", "Lkotlin/Function1;", "ChangeListener", "Companion", "intellij.markdown"})
public final class MarkdownSettings
extends SimplePersistentStateComponent<MarkdownSettingsState> {
    @NotNull
    private final Project project;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final boolean getAreInjectionsEnabled() {
        return ((MarkdownSettingsState)this.getState()).getAreInjectionsEnabled();
    }

    public final void setAreInjectionsEnabled(boolean value) {
        ((MarkdownSettingsState)this.getState()).setAreInjectionsEnabled(value);
    }

    public final boolean getHideErrorsInCodeBlocks() {
        return ((MarkdownSettingsState)this.getState()).getHideErrorsInCodeBlocks();
    }

    public final void setHideErrorsInCodeBlocks(boolean value) {
        ((MarkdownSettingsState)this.getState()).setHideErrorsInCodeBlocks(value);
    }

    public final boolean isEnhancedEditingEnabled() {
        return ((MarkdownSettingsState)this.getState()).isEnhancedEditingEnabled();
    }

    public final void setEnhancedEditingEnabled(boolean value) {
        ((MarkdownSettingsState)this.getState()).setEnhancedEditingEnabled(value);
    }

    @NotNull
    public final TextEditorWithPreview.Layout getSplitLayout() {
        return ((MarkdownSettingsState)this.getState()).getSplitLayout();
    }

    public final void setSplitLayout(@NotNull TextEditorWithPreview.Layout value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((MarkdownSettingsState)this.getState()).setSplitLayout(value);
    }

    @NotNull
    public final MarkdownHtmlPanelProvider.ProviderInfo getPreviewPanelProviderInfo() {
        return ((MarkdownSettingsState)this.getState()).getPreviewPanelProviderInfo();
    }

    public final void setPreviewPanelProviderInfo(@NotNull MarkdownHtmlPanelProvider.ProviderInfo value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((MarkdownSettingsState)this.getState()).setPreviewPanelProviderInfo(value);
    }

    public final boolean isVerticalSplit() {
        return ((MarkdownSettingsState)this.getState()).isVerticalSplit();
    }

    public final void setVerticalSplit(boolean value) {
        ((MarkdownSettingsState)this.getState()).setVerticalSplit(value);
    }

    public final boolean isAutoScrollEnabled() {
        return ((MarkdownSettingsState)this.getState()).isAutoScrollEnabled();
    }

    public final void setAutoScrollEnabled(boolean value) {
        ((MarkdownSettingsState)this.getState()).setAutoScrollEnabled(value);
    }

    public final boolean getUseCustomStylesheetPath() {
        return ((MarkdownSettingsState)this.getState()).getUseCustomStylesheetPath();
    }

    public final void setUseCustomStylesheetPath(boolean value) {
        ((MarkdownSettingsState)this.getState()).setUseCustomStylesheetPath(value);
    }

    @Nullable
    public final String getCustomStylesheetPath() {
        return ((MarkdownSettingsState)this.getState()).getCustomStylesheetPath();
    }

    public final void setCustomStylesheetPath(@Nullable String value) {
        ((MarkdownSettingsState)this.getState()).setCustomStylesheetPath(value);
    }

    public final boolean getUseCustomStylesheetText() {
        return ((MarkdownSettingsState)this.getState()).getUseCustomStylesheetText();
    }

    public final void setUseCustomStylesheetText(boolean value) {
        ((MarkdownSettingsState)this.getState()).setUseCustomStylesheetText(value);
    }

    @Nullable
    public final String getCustomStylesheetText() {
        return ((MarkdownSettingsState)this.getState()).getCustomStylesheetText();
    }

    public final void setCustomStylesheetText(@Nullable String value) {
        ((MarkdownSettingsState)this.getState()).setCustomStylesheetText(value);
    }

    public final int getFontSize() {
        return ((MarkdownSettingsState)this.getState()).getFontSize();
    }

    public final void setFontSize(int value) {
        ((MarkdownSettingsState)this.getState()).setFontSize(value);
    }

    @Nullable
    public final String getFontFamily() {
        return ((MarkdownSettingsState)this.getState()).getFontFamily();
    }

    public final void setFontFamily(@Nullable String value) {
        ((MarkdownSettingsState)this.getState()).setFontFamily(value);
    }

    public void loadState(@NotNull MarkdownSettingsState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        MarkdownSettingsState migrated = this.possiblyMigrateSettings(state);
        super.loadState((BaseState)migrated);
    }

    public void noStateLoaded() {
        super.noStateLoaded();
        this.loadState(new MarkdownSettingsState());
    }

    public final synchronized void update(@NotNull Function1<? super MarkdownSettings, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Object object = this.project.getMessageBus().syncPublisher(ChangeListener.TOPIC);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.messageBus.syncP\u2026her(ChangeListener.TOPIC)");
        ChangeListener publisher = (ChangeListener)object;
        publisher.beforeSettingsChanged(this);
        block.invoke((Object)this);
        publisher.settingsChanged(this);
    }

    private final MarkdownSettingsState possiblyMigrateSettings(MarkdownSettingsState from) {
        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        MarkdownApplicationSettings it = markdownApplicationSettings;
        boolean bl3 = false;
        MarkdownApplicationSettings markdownApplicationSettings2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)markdownApplicationSettings2, (String)"it");
        MarkdownApplicationSettings old = markdownApplicationSettings2.getState() != null ? markdownApplicationSettings : null;
        MarkdownSettingsMigration migration = MarkdownSettingsMigration.Companion.getInstance(this.project);
        if (old == null || ((MarkdownSettingsMigration.State)migration.getState()).getStateVersion() == 1) {
            return from;
        }
        logger.info("Migrating Markdown settings");
        MarkdownSettingsState migrated = new MarkdownSettingsState();
        bl2 = false;
        boolean bl4 = false;
        MarkdownSettingsState $this$with = migrated;
        boolean bl5 = false;
        Object object = old.getMarkdownPreviewSettings();
        boolean bl6 = false;
        boolean bl7 = false;
        Object it2 = object;
        boolean bl8 = false;
        MarkdownPreviewSettings markdownPreviewSettings = it2;
        Intrinsics.checkNotNullExpressionValue((Object)markdownPreviewSettings, (String)"it");
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo = markdownPreviewSettings.getHtmlPanelProviderInfo();
        Intrinsics.checkNotNullExpressionValue((Object)providerInfo, (String)"it.htmlPanelProviderInfo");
        $this$with.setPreviewPanelProviderInfo(providerInfo);
        TextEditorWithPreview.Layout layout = ((MarkdownPreviewSettings)it2).getSplitEditorLayout();
        Intrinsics.checkNotNullExpressionValue((Object)layout, (String)"it.splitEditorLayout");
        $this$with.setSplitLayout(layout);
        $this$with.setAutoScrollEnabled(((MarkdownPreviewSettings)it2).isAutoScrollPreview());
        $this$with.setVerticalSplit(((MarkdownPreviewSettings)it2).isVerticalSplit());
        object = old.getMarkdownCssSettings();
        bl6 = false;
        bl7 = false;
        it2 = object;
        boolean bl9 = false;
        Object object2 = it2;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
        String string = ((MarkdownCssSettings)object2).getCustomStylesheetPath();
        boolean bl10 = false;
        boolean bl11 = false;
        String string2 = string;
        MarkdownSettingsState markdownSettingsState = $this$with;
        boolean bl12 = false;
        boolean bl13 = ((MarkdownCssSettings)it2).isCustomStylesheetEnabled();
        markdownSettingsState.setCustomStylesheetPath(bl13 ? string : null);
        string = ((MarkdownCssSettings)it2).getCustomStylesheetText();
        bl10 = false;
        bl11 = false;
        String $noName_0 = string;
        markdownSettingsState = $this$with;
        boolean bl14 = false;
        bl13 = ((MarkdownCssSettings)it2).isTextEnabled();
        markdownSettingsState.setCustomStylesheetText(bl13 ? string : null);
        $this$with.setFontFamily(((MarkdownCssSettings)it2).getFontFamily());
        Integer n = ((MarkdownCssSettings)it2).getFontSize();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it.fontSize");
        $this$with.setFontSize(n);
        Map<String, Boolean> map = old.getExtensionsEnabledState();
        Intrinsics.checkNotNullExpressionValue(map, (String)"old.extensionsEnabledState");
        $this$with.setEnabledExtensions(map);
        $this$with.setAreInjectionsEnabled(!old.isDisableInjections());
        $this$with.setHideErrorsInCodeBlocks(old.isHideErrors());
        $this$with.setEnhancedEditingEnabled(old.isEnhancedEditingEnabled());
        $this$with.resetModificationCount();
        ((MarkdownSettingsMigration.State)migration.getState()).setStateVersion(1);
        return migrated;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public MarkdownSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BaseState)new MarkdownSettingsState());
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        MarkdownSettings.logger = logger;
    }

    public static final int getDefaultFontSize() {
        return Companion.getDefaultFontSize();
    }

    @NotNull
    public static final String getDefaultFontFamily() {
        return Companion.getDefaultFontFamily();
    }

    @NotNull
    public static final MarkdownHtmlPanelProvider.ProviderInfo getDefaultProviderInfo() {
        return Companion.getDefaultProviderInfo();
    }

    @JvmStatic
    @NotNull
    public static final MarkdownSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final MarkdownSettings getInstanceForDefaultProject() {
        return Companion.getInstanceForDefaultProject();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "", "beforeSettingsChanged", "", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "settingsChanged", "Companion", "intellij.markdown"})
    public static interface ChangeListener {
        @JvmField
        @NotNull
        public static final Topic<ChangeListener> TOPIC;
        @NotNull
        public static final Companion Companion;

        public void beforeSettingsChanged(@NotNull MarkdownSettings var1);

        public void settingsChanged(@NotNull MarkdownSettings var1);

        static {
            Companion = new Companion(null);
            Topic topic = Topic.create((String)"MarkdownSettingsChanged", ChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"Topic.create(\"MarkdownSe\u2026angeListener::class.java)");
            TOPIC = topic;
        }

        @Metadata(mv={1, 5, 1}, k=3)
        public static final class DefaultImpls {
            public static void beforeSettingsChanged(@NotNull ChangeListener $this, @NotNull MarkdownSettings settings) {
                Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            }

            public static void settingsChanged(@NotNull ChangeListener $this, @NotNull MarkdownSettings settings) {
                Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0017H\u0007R$\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettings$Companion;", "", "()V", "defaultFontFamily", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultFontFamily$annotations", "getDefaultFontFamily", "()Ljava/lang/String;", "defaultFontSize", "", "getDefaultFontSize$annotations", "getDefaultFontSize", "()I", "defaultProviderInfo", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "getDefaultProviderInfo$annotations", "getDefaultProviderInfo", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelProvider$ProviderInfo;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceForDefaultProject", "intellij.markdown"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getDefaultFontSize$annotations() {
        }

        public final int getDefaultFontSize() {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            AppEditorFontOptions.PersistentFontPreferences persistentFontPreferences = appEditorFontOptions.getState();
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (persistentFontPreferences == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return JBCefApp.normalizeScaledSize((int)persistentFontPreferences.FONT_SIZE);
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultFontFamily$annotations() {
        }

        @NotNull
        public final String getDefaultFontFamily() {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            AppEditorFontOptions.PersistentFontPreferences persistentFontPreferences = appEditorFontOptions.getState();
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (persistentFontPreferences == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String string = persistentFontPreferences.FONT_FAMILY;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkNotNull(AppEditorFo\u2026ance().state).FONT_FAMILY");
            return string;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultProviderInfo$annotations() {
        }

        @NotNull
        public final MarkdownHtmlPanelProvider.ProviderInfo getDefaultProviderInfo() {
            MarkdownHtmlPanelProvider.ProviderInfo providerInfo = JBCefApp.isSupported() ? new JCEFHtmlPanelProvider().getProviderInfo() : new MarkdownHtmlPanelProvider.ProviderInfo("Unavailable", "Unavailable");
            Intrinsics.checkNotNullExpressionValue((Object)providerInfo, (String)"when {\n        JBCefApp.\u2026\", \"Unavailable\")\n      }");
            return providerInfo;
        }

        @JvmStatic
        @NotNull
        public final MarkdownSettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(MarkdownSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (MarkdownSettings)((Object)object);
        }

        @JvmStatic
        @NotNull
        public final MarkdownSettings getInstanceForDefaultProject() {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project project = projectManager.getDefaultProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ProjectManager.getInstance().defaultProject");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(MarkdownSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (MarkdownSettings)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

