/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.html.links.IntelliJImageGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/IncrementalDOMBuilder;", "", "html", "", "basePath", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "document", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "closeTag", "", "node", "Lorg/jsoup/nodes/Node;", "encodeArgument", "argument", "ensureCorrectTag", "name", "generateDomBuildCalls", "generateRenderClosure", "openTag", "preprocessNode", "textElement", "Lorg/jsoup/nodes/TextNode;", "traverse", "intellij.markdown"})
public final class IncrementalDOMBuilder {
    private final Document document;
    private final StringBuilder builder;
    private final Path basePath;

    @NotNull
    public final String generateRenderClosure() {
        return "\n      () => {\n        const o = (tag, ...attrs) => IncrementalDOM.elementOpen(tag, null, null, ...attrs.map(decodeURIComponent));\n        const t = content => IncrementalDOM.text(decodeURIComponent(content));\n        const c = IncrementalDOM.elementClose;\n        " + this.generateDomBuildCalls() + "\n      }\n    ";
    }

    @NotNull
    public final String generateDomBuildCalls() {
        Element element2 = this.document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"document.body()");
        this.traverse((Node)element2);
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final String ensureCorrectTag(String name) {
        String string;
        String string2 = name;
        switch (string2.hashCode()) {
            case 3029410: {
                if (string2.equals("body")) {
                    string = "div";
                    break;
                }
            }
            default: {
                string = name;
            }
        }
        return string;
    }

    private final String encodeArgument(String argument) {
        String string = URLEncoder.encode(argument, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(argument, Charsets.UTF_8)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    private final void openTag(Node node) {
        StringBuilder stringBuilder = this.builder;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = stringBuilder;
        boolean bl3 = false;
        $this$with.append("o('");
        String string = node.nodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeName()");
        $this$with.append(this.ensureCorrectTag(string));
        $this$with.append("'");
        for (Attribute attribute : node.attributes()) {
            $this$with.append(",'");
            $this$with.append(attribute.getKey());
            $this$with.append('\'');
            String value = attribute.getValue();
            if (value == null) continue;
            $this$with.append(",'");
            $this$with.append(this.encodeArgument(value));
            $this$with.append("'");
        }
        $this$with.append(");");
    }

    private final void closeTag(Node node) {
        StringBuilder stringBuilder = this.builder;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = stringBuilder;
        boolean bl3 = false;
        $this$with.append("c('");
        String string = node.nodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeName()");
        $this$with.append(this.ensureCorrectTag(string));
        $this$with.append("');");
    }

    private final void textElement(TextNode node) {
        StringBuilder stringBuilder = this.builder;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = stringBuilder;
        boolean bl3 = false;
        $this$with.append("t(`");
        String string = node.getWholeText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.wholeText");
        $this$with.append(this.encodeArgument(string));
        $this$with.append("`);");
    }

    private final Node preprocessNode(Node node) {
        if (Intrinsics.areEqual((Object)node.nodeName(), (Object)"img") ^ true || node.hasAttr(IntelliJImageGeneratingProvider.Companion.getGeneratedAttributeName()) || node.hasAttr(IntelliJImageGeneratingProvider.Companion.getIgnorePathProcessingAttributeName())) {
            return node;
        }
        String string = node.attr("src");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.attr(\"src\")");
        Url url = Urls.parse((String)string, (boolean)true);
        if (url == null) {
            return node;
        }
        Url url2 = url;
        if ((url2.getScheme() == null || Intrinsics.areEqual((Object)url2.getScheme(), (Object)"file")) && !FileUtil.isAbsolute((String)url2.getPath())) {
            String string2 = FileUtil.toSystemIndependentName((String)((Object)Paths.get(String.valueOf(this.basePath), url2.getPath())).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.toSystemIndepen\u2026(), url.path).toString())");
            String fixedPath = string2;
            String string3 = Urls.newUrl((String)"file", (String)url2.getAuthority(), (String)fixedPath, (String)url2.getParameters()).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Urls.newUrl(\"file\", url.\u2026ameters).toExternalForm()");
            String newUrl = string3;
            node.attr("src", newUrl);
        }
        return node;
    }

    private final void traverse(Node node) {
        Node node2 = node;
        if (node2 instanceof TextNode) {
            this.textElement((TextNode)node);
        } else if (!(node2 instanceof Comment)) {
            Node preprocessed = this.preprocessNode(node);
            this.openTag(preprocessed);
            Iterator iterator = preprocessed.childNodes().iterator();
            while (iterator.hasNext()) {
                Node child;
                Node node3 = child = (Node)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"child");
                this.traverse(node3);
            }
            this.closeTag(preprocessed);
        }
    }

    public IncrementalDOMBuilder(@NotNull String html2, @Nullable Path basePath) {
        Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
        this.basePath = basePath;
        this.document = Jsoup.parse((String)html2);
        this.builder = new StringBuilder();
    }

    public /* synthetic */ IncrementalDOMBuilder(String string, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        this(string, path);
    }
}

