/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff.load;

import circlet.client.api.GitCommitChange;
import circlet.client.api.GitFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.space.vcs.diff.load.SpaceDiffLoaderBase;
import com.intellij.util.Consumer;
import git4idea.GitCommit;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J.\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/space/vcs/diff/load/SpaceGitDiffLoader;", "Lcom/intellij/space/vcs/diff/load/SpaceDiffLoaderBase;", "parentLifetime", "Llibraries/coroutines/extra/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Llibraries/coroutines/extra/Lifetime;Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcirclet/client/api/GitCommitChange;", "Lcom/intellij/space/vcs/diff/load/SpaceDiffLoaderBase$DiffSides;", "loadChangeForHashes", "Lcom/intellij/openapi/vcs/changes/Change;", "repo", "Lgit4idea/repo/GitRepository;", "hashes", "", "", "filePaths", "", "Lcom/intellij/openapi/vcs/FilePath;", "loadChangeForRange", "startRevision", "latestRevision", "loadDiffSides", "spaceChange", "Lcom/intellij/space/vcs/changes/SpaceChange;", "commitHashes", "GitDiffLoadingException", "intellij.space"})
public final class SpaceGitDiffLoader
extends SpaceDiffLoaderBase {
    private final ConcurrentMap<GitCommitChange, SpaceDiffLoaderBase.DiffSides> cache;

    @Override
    @NotNull
    protected SpaceDiffLoaderBase.DiffSides loadDiffSides(@NotNull SpaceChange spaceChange, @NotNull List<String> commitHashes2) {
        Change change;
        FilePath it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)spaceChange, (String)"spaceChange");
        Intrinsics.checkNotNullParameter(commitHashes2, (String)"commitHashes");
        GitCommitChange gitCommitChange = spaceChange.getGitCommitChange();
        SpaceDiffLoaderBase.DiffSides cachedValue = (SpaceDiffLoaderBase.DiffSides)this.cache.get(gitCommitChange);
        if (cachedValue != null) {
            SpaceStatsCounterCollector.DIFF_LOADED.log((Object)SpaceStatsCounterCollector.LoaderType.GIT);
            return cachedValue;
        }
        SpaceRepoInfo spaceRepoInfo = spaceChange.getRepository().getMapping();
        if (spaceRepoInfo == null) {
            throw (Throwable)new GitDiffLoadingException("Repository is not mapped");
        }
        SpaceRepoInfo spaceRepoInfo2 = spaceRepoInfo;
        GitRepository repo = spaceRepoInfo2.getRepository();
        GitFile gitFile = gitCommitChange.getOld();
        String oldRevision = gitFile != null ? gitFile.getCommit() : null;
        GitFile gitFile2 = gitCommitChange.getNew();
        String newRevision = gitFile2 != null ? gitFile2.getCommit() : null;
        boolean bl3 = false;
        Set filePaths = new LinkedHashSet();
        FilePath filePath = spaceChange.getOldFilePath();
        if (filePath != null) {
            FilePath filePath2 = filePath;
            bl2 = false;
            bl = false;
            it = filePath2;
            boolean bl4 = false;
            filePaths.add(it);
        }
        FilePath filePath3 = spaceChange.getNewFilePath();
        if (filePath3 != null) {
            FilePath filePath4 = filePath3;
            bl2 = false;
            bl = false;
            it = filePath4;
            boolean bl5 = false;
            filePaths.add(it);
        }
        if (oldRevision != null && newRevision != null) {
            change = this.loadChangeForRange(repo, oldRevision, newRevision, filePaths);
        } else if (oldRevision == null && newRevision != null) {
            change = this.loadChangeForHashes(repo, commitHashes2, filePaths);
        } else if (oldRevision != null && newRevision == null) {
            change = this.loadChangeForRange(repo, oldRevision, gitCommitChange.getRevision(), filePaths);
        } else {
            throw (Throwable)new GitDiffLoadingException("Old and new revisions are null");
        }
        Change change2 = change;
        ContentRevision contentRevision = change2.getBeforeRevision();
        ContentRevision contentRevision2 = change2.getAfterRevision();
        SpaceDiffLoaderBase.DiffSides diffSides = new SpaceDiffLoaderBase.DiffSides(contentRevision != null ? contentRevision.getContent() : null, contentRevision2 != null ? contentRevision2.getContent() : null);
        bl = false;
        boolean bl6 = false;
        SpaceDiffLoaderBase.DiffSides it2 = diffSides;
        boolean bl7 = false;
        SpaceStatsCounterCollector.DIFF_LOADED.log((Object)SpaceStatsCounterCollector.LoaderType.GIT);
        this.cache.putIfAbsent(gitCommitChange, it2);
        return diffSides;
    }

    private final Change loadChangeForHashes(GitRepository repo, List<String> hashes, Set<? extends FilePath> filePaths) {
        boolean bl = false;
        List changes2 = new ArrayList();
        GitLogUtil.readFullDetailsForHashes((Project)repo.getProject(), (VirtualFile)repo.getRoot(), (List)CollectionsKt.asReversed(hashes), (GitCommitRequirements)GitCommitRequirements.DEFAULT, (Consumer)new Consumer(filePaths, changes2){
            final /* synthetic */ Set $filePaths;
            final /* synthetic */ List $changes;

            /*
             * Unable to fully structure code
             */
            public final void consume(GitCommit commit) {
                v0 = commit;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"commit");
                v1 = v0.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"commit.changes");
                $this$filter$iv = v1;
                $i$f$filter = false;
                var5_4 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Change)element$iv$iv;
                    $i$a$-filter-SpaceGitDiffLoader$loadChangeForHashes$1$filteredChanges$1 = false;
                    v2 = this.$filePaths;
                    v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    v4 = v3.getBeforeRevision();
                    if (CollectionsKt.contains((Iterable)v2, (Object)(v4 != null ? v4.getFile() : null))) ** GOTO lbl-1000
                    v5 = it.getAfterRevision();
                    if (CollectionsKt.contains((Iterable)this.$filePaths, (Object)(v5 != null ? v5.getFile() : null))) lbl-1000:
                    // 2 sources

                    {
                        v6 = true;
                    } else {
                        v6 = false;
                    }
                    if (!v6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                filteredChanges = (List)destination$iv$iv;
                this.$changes.addAll(filteredChanges);
            }
            {
                this.$filePaths = set;
                this.$changes = list2;
            }
        });
        List list2 = CommittedChangesTreeBrowser.zipChanges((List)changes2);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"CommittedChangesTreeBrowser.zipChanges(changes)");
        Object object = CollectionsKt.single((List)list2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CommittedChangesTreeBrow\u2026Changes(changes).single()");
        return (Change)object;
    }

    private final Change loadChangeForRange(GitRepository repo, String startRevision, String latestRevision, Set<? extends FilePath> filePaths) {
        Collection collection = GitChangeUtils.getDiff((Project)repo.getProject(), (VirtualFile)repo.getRoot(), (String)startRevision, (String)latestRevision, (Collection)filePaths);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"GitChangeUtils.getDiff(r\u2026atestRevision, filePaths)");
        Object object = CollectionsKt.single((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GitChangeUtils.getDiff(r\u2026sion, filePaths).single()");
        return (Change)object;
    }

    public SpaceGitDiffLoader(@NotNull Lifetime parentLifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.cache = new ConcurrentHashMap();
        parentLifetime.add((Function0)new Function0<Unit>(){

            public final void invoke() {
                cache.clear();
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/space/vcs/diff/load/SpaceGitDiffLoader$GitDiffLoadingException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "intellij.space"})
    public static final class GitDiffLoadingException
    extends Exception {
        public GitDiffLoadingException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

