/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.actions.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnsetValueDescriptor;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.editorconfig.language.util.EditorConfigTextMatchingUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0012\u0010\u0015\u001a\f0\b\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "constantMatches", "", "descriptor", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "value", "", "findUnionDescriptor", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigUnionDescriptor;", "getDescribableElement", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getInvertedValue", "union", "element", "getText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "startInWriteAction", "intellij.editorconfig"})
public final class EditorConfigInvertValueIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return EditorConfigBundle.INSTANCE.get("intention.invert-option-value");
    }

    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("intention.invert-option-value");
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorConfigDescribableElement editorConfigDescribableElement = this.getDescribableElement(editor, file);
        if (editorConfigDescribableElement == null) {
            return false;
        }
        EditorConfigDescribableElement value = editorConfigDescribableElement;
        return this.getInvertedValue(value) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorConfigDescribableElement editorConfigDescribableElement = this.getDescribableElement(editor, file);
        if (editorConfigDescribableElement == null) {
            return;
        }
        EditorConfigDescribableElement optionValue = editorConfigDescribableElement;
        String string = this.getInvertedValue(optionValue);
        if (string == null) {
            return;
        }
        String notValue = string;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        TextRange textRange2 = textRange = optionValue.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange");
        document2.replaceString(textRange2.getStartOffset(), textRange.getEndOffset(), (CharSequence)notValue);
    }

    private final String getInvertedValue(EditorConfigDescribableElement element) {
        EditorConfigUnionDescriptor descriptor = this.findUnionDescriptor(element.getDescriptor(true));
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return this.getInvertedValue(string, descriptor);
    }

    private final String getInvertedValue(String value, EditorConfigUnionDescriptor union) {
        Object object = union;
        if (object == null || (object = ((EditorConfigUnionDescriptor)object).getChildren()) == null || object.size() != 2) {
            return null;
        }
        EditorConfigDescriptor first = union.getChildren().get(0);
        EditorConfigDescriptor second = union.getChildren().get(1);
        return this.constantMatches(first, value) ? this.getText(second) : (this.constantMatches(second, value) ? this.getText(first) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final EditorConfigDescribableElement getDescribableElement(Editor editor, PsiFile file) {
        EditorConfigDescribableElement editorConfigDescribableElement;
        PsiElement psiElement = EditorConfigPsiTreeUtil.INSTANCE.findIdentifierUnderCaret(editor, file);
        if (psiElement != null) {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = psiElement;
            EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            editorConfigDescribableElement = (EditorConfigDescribableElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, EditorConfigDescribableElement.class, (boolean)strict$iv);
        } else {
            editorConfigDescribableElement = null;
        }
        return editorConfigDescribableElement;
    }

    private final String getText(EditorConfigDescriptor descriptor) {
        EditorConfigDescriptor editorConfigDescriptor = descriptor;
        if (!(editorConfigDescriptor instanceof EditorConfigConstantDescriptor)) {
            editorConfigDescriptor = null;
        }
        if ((EditorConfigConstantDescriptor)editorConfigDescriptor == null) {
            return null;
        }
        return ((EditorConfigConstantDescriptor)descriptor).getText();
    }

    private final boolean constantMatches(EditorConfigDescriptor descriptor, String value) {
        EditorConfigDescriptor editorConfigDescriptor = descriptor;
        if (!(editorConfigDescriptor instanceof EditorConfigConstantDescriptor)) {
            editorConfigDescriptor = null;
        }
        if ((EditorConfigConstantDescriptor)editorConfigDescriptor == null) {
            return false;
        }
        return EditorConfigTextMatchingUtil.INSTANCE.textMatchesToIgnoreCase(((EditorConfigConstantDescriptor)descriptor).getText(), (CharSequence)value);
    }

    private final EditorConfigUnionDescriptor findUnionDescriptor(EditorConfigDescriptor descriptor) {
        if (descriptor instanceof EditorConfigUnsetValueDescriptor) {
            return null;
        }
        EditorConfigDescriptor editorConfigDescriptor = descriptor;
        EditorConfigDescriptor editorConfigDescriptor2 = editorConfigDescriptor != null ? editorConfigDescriptor.getParent() : null;
        if (!(editorConfigDescriptor2 instanceof EditorConfigUnionDescriptor)) {
            editorConfigDescriptor2 = null;
        }
        return (EditorConfigUnionDescriptor)editorConfigDescriptor2;
    }
}

