/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.EditorConfigLanguage;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.reference.EditorConfigVirtualFileDescriptor;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceLoading;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigVfsUtil;
import org.editorconfig.language.util.core.EditorConfigPsiTreeUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0082\u0010J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u001c\u001a\u00020\u001bJ&\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\r2\b\u0010\n\u001a\u0004\u0018\u0001H\u001fH\u0086\b\u00a2\u0006\u0002\u0010 J\"\u0010!\u001a\u0002H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\"J9\u0010#\u001a\u00020$\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010\u0005\u001a\u0002H\u001f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020$0&H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J9\u0010(\u001a\u00020$\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010\u0005\u001a\u0002H\u001f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020$0&H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J(\u0010)\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0&H\u0086\b\u00f8\u0001\u0000J\u0013\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0010J/\u0010,\u001a\t\u0018\u0001H\u001f\u00a2\u0006\u0002\b-\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0006*\u00020\u00062\b\b\u0002\u0010.\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u00020\u0004\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0006*\u00020\u0006H\u0086\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lorg/editorconfig/language/util/EditorConfigPsiTreeUtil;", "", "()V", "containsErrors", "", "element", "Lcom/intellij/psi/PsiElement;", "findAllChildrenFiles", "", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "file", "honorRoot", "findAllParentsFiles", "Lcom/intellij/psi/PsiFile;", "findIdentifierUnderCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "findNextEditorConfigFile", "directory", "Lcom/intellij/psi/PsiDirectory;", "findOneParentFile", "findParentFilesUsingIndex", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findRemovableRange", "Lkotlin/ranges/IntRange;", "findShadowedSections", "Lorg/editorconfig/language/psi/EditorConfigSection;", "section", "findShadowingSections", "getOriginalFile", "T", "(Lcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiFile;", "getRequiredParent", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "iterateTypedSiblingsBackward", "", "action", "Lkotlin/Function1;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "iterateTypedSiblingsForward", "iterateVisibleChildren", "acceptor", "nextVisibleSibling", "getParentOfType", "Lorg/jetbrains/annotations/Nullable;", "strict", "(Lcom/intellij/psi/PsiElement;Z)Lcom/intellij/psi/PsiElement;", "hasParentOfType", "intellij.editorconfig"})
public final class EditorConfigPsiTreeUtil {
    @NotNull
    public static final EditorConfigPsiTreeUtil INSTANCE;

    public final /* synthetic */ <T extends PsiElement> T getParentOfType(PsiElement $this$getParentOfType, boolean strict) {
        int $i$f$getParentOfType = 0;
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfType, (String)"$this$getParentOfType");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType, PsiElement.class, (boolean)strict);
    }

    public static /* synthetic */ PsiElement getParentOfType$default(EditorConfigPsiTreeUtil this_, PsiElement $this$getParentOfType, boolean strict, int n, Object object) {
        if ((n & 1) != 0) {
            strict = false;
        }
        boolean $i$f$getParentOfType = false;
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfType, (String)"$this$getParentOfType");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType, PsiElement.class, (boolean)strict);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends PsiElement> boolean hasParentOfType(PsiElement $this$hasParentOfType) {
        void $this$getParentOfType$iv;
        int $i$f$hasParentOfType = 0;
        Intrinsics.checkNotNullParameter((Object)$this$hasParentOfType, (String)"$this$hasParentOfType");
        PsiElement psiElement = $this$hasParentOfType;
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiElement.class, (boolean)strict$iv) != null;
    }

    public final /* synthetic */ <T extends PsiElement> T getRequiredParent(PsiElement element) {
        int $i$f$getRequiredParent = 0;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, PsiElement.class, (boolean)false);
        if (psiElement == null) {
            throw (Throwable)new IllegalStateException();
        }
        return (T)psiElement;
    }

    public final boolean containsErrors(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(PsiErrorElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026ErrorElement::class.java)");
        return jBIterable.isNotEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigSection> findShadowingSections(@NotNull EditorConfigSection section) {
        void $this$dropWhile$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        List result2 = CollectionsKt.mutableListOf((Object[])new EditorConfigSection[]{section});
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$iterateTypedSiblingsForward = false;
        PsiElement psiElement = ((PsiElement)section).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.parent.children");
        Object $this$mapNotNull$iv$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        PsiElement[] psiElementArray2 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        void var12_16 = $this$forEach$iv$iv$iv$iv;
        int n = ((void)var12_16).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv$iv;
            void element$iv$iv$iv = element$iv$iv$iv$iv = var12_16[i];
            boolean bl = false;
            void it$iv = element$iv$iv$iv;
            boolean bl2 = false;
            Object v2 = it$iv;
            if (!(v2 instanceof EditorConfigSection)) {
                v2 = null;
            }
            if ((PsiElement)((EditorConfigSection)v2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiElement it$iv$iv$iv = psiElement2;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv$iv = false;
        ArrayList list$iv$iv = new ArrayList();
        for (Object item$iv$iv : $this$dropWhile$iv$iv) {
            if (yielding$iv$iv) {
                list$iv$iv.add(item$iv$iv);
                continue;
            }
            PsiElement it$iv = (PsiElement)item$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)((PsiElement)section), (Object)it$iv) ^ true) continue;
            list$iv$iv.add(item$iv$iv);
            yielding$iv$iv = true;
        }
        Iterable $this$forEach$iv$iv = CollectionsKt.drop((Iterable)list$iv$iv, (int)1);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"section.header");
            EditorConfigHeader editorConfigHeader2 = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"it.header");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            result2.add(it);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigSection> findShadowedSections(@NotNull EditorConfigSection section) {
        void $this$takeWhile$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        List result2 = CollectionsKt.mutableListOf((Object[])new EditorConfigSection[]{section});
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$iterateTypedSiblingsBackward = false;
        PsiElement psiElement = ((PsiElement)section).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.parent.children");
        Object $this$mapNotNull$iv$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        PsiElement[] psiElementArray2 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        void var12_13 = $this$forEach$iv$iv$iv$iv;
        int n = ((void)var12_13).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv$iv;
            void element$iv$iv$iv = element$iv$iv$iv$iv = var12_13[i];
            boolean bl = false;
            void it$iv = element$iv$iv$iv;
            boolean bl2 = false;
            Object v2 = it$iv;
            if (!(v2 instanceof EditorConfigSection)) {
                v2 = null;
            }
            if ((PsiElement)((EditorConfigSection)v2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiElement it$iv$iv$iv = psiElement2;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv$iv = new ArrayList();
        for (Object item$iv$iv : $this$takeWhile$iv$iv) {
            PsiElement it$iv = (PsiElement)item$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)((PsiElement)section), (Object)it$iv) ^ true)) break;
            list$iv$iv.add(item$iv$iv);
        }
        Iterable $this$forEach$iv$iv = CollectionsKt.reversed((Iterable)list$iv$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"it.header");
            EditorConfigHeader editorConfigHeader2 = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"section.header");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            result2.add(it);
        }
        CollectionsKt.reverse((List)result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends PsiElement> void iterateTypedSiblingsForward(T element, Function1<? super T, Unit> action) {
        void $this$dropWhile$iv;
        void $this$mapNotNullTo$iv$iv;
        int $i$f$iterateTypedSiblingsForward = 0;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.parent.children");
        Object $this$mapNotNull$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        PsiElement[] psiElementArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var11_15 = $this$forEach$iv$iv$iv;
        int n = ((void)var11_15).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var11_15[i];
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            if (it == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiElement it$iv$iv = psiElement2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PsiElement it = (PsiElement)item$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(element, (Object)it) ^ true) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)list$iv, (int)1);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends PsiElement> void iterateTypedSiblingsBackward(T element, Function1<? super T, Unit> action) {
        void $this$takeWhile$iv;
        void $this$mapNotNullTo$iv$iv;
        int $i$f$iterateTypedSiblingsBackward = 0;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.parent.children");
        Object $this$mapNotNull$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        PsiElement[] psiElementArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var11_12 = $this$forEach$iv$iv$iv;
        int n = ((void)var11_12).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var11_12[i];
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            if (it == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiElement it$iv$iv = psiElement2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            PsiElement it = (PsiElement)item$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(element, (Object)it) ^ true)) break;
            list$iv.add(item$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)list$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    @NotNull
    public final IntRange findRemovableRange(@NotNull PsiElement element) {
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IntRange intRange2 = EditorConfigPsiTreeUtilCore.INSTANCE.findRemovableRangeBackward(element);
        if (intRange2 == null) {
            intRange2 = intRange = EditorConfigPsiTreeUtilCore.INSTANCE.findRemovableRangeForward(element);
        }
        if (intRange2 == null) {
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            int n = textRange.getStartOffset();
            TextRange textRange2 = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"element.textRange");
            intRange = RangesKt.until((int)n, (int)textRange2.getEndOffset());
        }
        return intRange;
    }

    @NotNull
    public final List<EditorConfigPsiFile> findAllParentsFiles(@NotNull PsiFile file) {
        List<EditorConfigPsiFile> list;
        EditorConfigServiceResult serviceResult;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$getOriginalFile = false;
        PsiFile psiFile = EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file, Reflection.getOrCreateKotlinClass(PsiFile.class));
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile virtualFile = psiFile;
        if (EditorConfigRegistry.shouldStopAtProjectRoot()) {
            return this.findParentFilesUsingIndex(file, (VirtualFile)virtualFile);
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        EditorConfigFileHierarchyService service = EditorConfigFileHierarchyService.Companion.getInstance(project);
        EditorConfigServiceResult editorConfigServiceResult = serviceResult = service.getParentEditorConfigFiles((VirtualFile)virtualFile);
        if (editorConfigServiceResult instanceof EditorConfigServiceLoaded) {
            list = ((EditorConfigServiceLoaded)serviceResult).getList();
        } else if (editorConfigServiceResult instanceof EditorConfigServiceLoading) {
            list = this.findParentFilesUsingIndex(file, (VirtualFile)virtualFile);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Nullable
    public final PsiElement findIdentifierUnderCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        Object object;
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int caretOffset = caretModel.getOffset();
        FileViewProvider fileViewProvider = file.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file.viewProvider");
        FileViewProvider viewProvider = fileViewProvider;
        PsiElement psiUnderCaret = viewProvider.findElementAt(caretOffset, (Language)EditorConfigLanguage.INSTANCE);
        PsiElement psiElement = psiUnderCaret;
        IElementType iElementType2 = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (iElementType = null);
        if (Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.IDENTIFIER)) {
            object = psiUnderCaret;
        } else if (iElementType == null || Intrinsics.areEqual((Object)iElementType, (Object)TokenType.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.DOT)) {
            int n = 0;
            int n2 = caretOffset - 1;
            boolean bl = false;
            int previousIndex = Math.max(n, n2);
            PsiElement previousElement = viewProvider.findElementAt(previousIndex);
            PsiElement psiElement2 = previousElement;
            object = Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)EditorConfigElementTypes.IDENTIFIER) ^ true ? null : previousElement;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigPsiFile> findParentFilesUsingIndex(PsiFile file, VirtualFile virtualFile) {
        int n;
        PsiManager manager;
        Sequence sortedParentFiles2;
        block4: {
            void $this$sortedBy$iv;
            EditorConfigVirtualFileDescriptor currentFileDescriptor = new EditorConfigVirtualFileDescriptor(virtualFile);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            Project project2 = project;
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigVfsUtil.INSTANCE.getEditorConfigFiles(project2)), (Function1)((Function1)new Function1<VirtualFile, Boolean>(currentFileDescriptor){

                public final boolean invoke(@NotNull VirtualFile p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((EditorConfigVirtualFileDescriptor)this.receiver).isChildOf(p1);
                }
            }));
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            sortedParentFiles2 = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(currentFileDescriptor){
                final /* synthetic */ EditorConfigVirtualFileDescriptor receiver$0$inlined;
                {
                    this.receiver$0$inlined = editorConfigVirtualFileDescriptor;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    VirtualFile p1 = (VirtualFile)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(this.receiver$0$inlined.distanceToParent(p1));
                    p1 = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = this.receiver$0$inlined.distanceToParent(p1);
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
            manager = psiManager;
            Sequence $this$indexOfFirst$iv = sortedParentFiles2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                EditorConfigPsiFile psiFile;
                boolean bl2 = false;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VirtualFile it = (VirtualFile)item$iv;
                boolean bl3 = false;
                PsiFile psiFile2 = manager.findFile(it);
                if (!(psiFile2 instanceof EditorConfigPsiFile)) {
                    psiFile2 = null;
                }
                EditorConfigPsiFile editorConfigPsiFile = psiFile = (EditorConfigPsiFile)psiFile2;
                if (editorConfigPsiFile != null ? editorConfigPsiFile.getHasValidRootDeclaration() : false) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstRoot = n;
        Sequence actualParentFiles = firstRoot < 0 ? sortedParentFiles2 : SequencesKt.take((Sequence)sortedParentFiles2, (int)(firstRoot + 1));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)actualParentFiles, (Function1)((Function1)new Function1<VirtualFile, EditorConfigPsiFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final EditorConfigPsiFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof EditorConfigPsiFile)) {
                    psiFile = null;
                }
                return (EditorConfigPsiFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigPsiFile> findAllChildrenFiles(@NotNull EditorConfigPsiFile file, boolean honorRoot) {
        void $this$filterTo$iv$iv;
        void $this$filterKeys$iv;
        EditorConfigPsiFile it;
        Object object;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$getOriginalFile = false;
        EditorConfigPsiFile editorConfigPsiFile = (EditorConfigPsiFile)EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile((PsiFile)file, Reflection.getOrCreateKotlinClass(EditorConfigPsiFile.class));
        if (editorConfigPsiFile == null || (editorConfigPsiFile = editorConfigPsiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile virtualFile = editorConfigPsiFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager manager = psiManager;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigVfsUtil.INSTANCE.getEditorConfigFiles(project2)), (Function1)((Function1)new Function1<VirtualFile, Boolean>(new EditorConfigVirtualFileDescriptor((VirtualFile)virtualFile)){

            public final boolean invoke(@NotNull VirtualFile p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((EditorConfigVirtualFileDescriptor)this.receiver).isStrictParentOf(p1);
            }
        }));
        boolean $i$f$associateBy = false;
        void var9_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            object = (VirtualFile)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile = manager.findFile((VirtualFile)it);
            if (!(psiFile instanceof EditorConfigPsiFile)) {
                psiFile = null;
            }
            EditorConfigPsiFile editorConfigPsiFile2 = (EditorConfigPsiFile)psiFile;
            map.put(editorConfigPsiFile2, element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv;
        boolean $i$f$filterKeys = false;
        Map result$iv = new LinkedHashMap();
        destination$iv$iv = $this$filterKeys$iv;
        $i$f$associateByTo = false;
        for (Map.Entry entry$iv : destination$iv$iv.entrySet()) {
            it = (EditorConfigPsiFile)((Object)entry$iv.getKey());
            boolean bl = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map childFiles2 = result$iv;
        if (honorRoot) {
            return CollectionsKt.filterNotNull((Iterable)childFiles2.keySet());
        }
        Map $this$filter$iv = childFiles2;
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        boolean bl = false;
        object = iterator.entrySet().iterator();
        while (object.hasNext()) {
            boolean bl2;
            Map.Entry element$iv$iv;
            block11: {
                Map.Entry $dstr$_u24__u24$virtualChildFile = element$iv$iv = (Map.Entry)object.next();
                boolean bl3 = false;
                Map.Entry entry = $dstr$_u24__u24$virtualChildFile;
                boolean bl4 = false;
                VirtualFile virtualChildFile = (VirtualFile)entry.getValue();
                Map $this$all$iv = childFiles2;
                boolean $i$f$all = false;
                if ($this$all$iv.isEmpty()) {
                    bl2 = true;
                } else {
                    Map map = $this$all$iv;
                    boolean bl5 = false;
                    Iterator iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        boolean bl6;
                        Map.Entry element$iv;
                        Map.Entry $dstr$otherChildFile$virtualOtherChildFile = element$iv = iterator2.next();
                        boolean bl7 = false;
                        Map.Entry entry2 = $dstr$otherChildFile$virtualOtherChildFile;
                        boolean bl8 = false;
                        EditorConfigPsiFile editorConfigPsiFile3 = (EditorConfigPsiFile)((Object)entry2.getKey());
                        entry2 = $dstr$otherChildFile$virtualOtherChildFile;
                        bl8 = false;
                        VirtualFile virtualOtherChildFile = (VirtualFile)entry2.getValue();
                        if (!VfsUtil.isAncestor((VirtualFile)virtualOtherChildFile, (VirtualFile)virtualChildFile, (boolean)false)) {
                            bl6 = true;
                        } else {
                            void otherChildFile;
                            void v6 = otherChildFile;
                            Intrinsics.checkNotNull((Object)v6);
                            bl6 = !v6.getHasValidRootDeclaration();
                        }
                        if (bl6) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.filterNotNull((Iterable)destination$iv$iv.keySet());
    }

    public static /* synthetic */ List findAllChildrenFiles$default(EditorConfigPsiTreeUtil editorConfigPsiTreeUtil, EditorConfigPsiFile editorConfigPsiFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return editorConfigPsiTreeUtil.findAllChildrenFiles(editorConfigPsiFile, bl);
    }

    @Nullable
    public final EditorConfigPsiFile findOneParentFile(@NotNull EditorConfigPsiFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        if (file.getHasValidRootDeclaration()) {
            return null;
        }
        PsiDirectory psiDirectory = file.getParent();
        return this.findNextEditorConfigFile((PsiDirectory)(psiDirectory != null ? psiDirectory.getParentDirectory() : null));
    }

    private final EditorConfigPsiFile findNextEditorConfigFile(PsiDirectory directory) {
        EditorConfigPsiFile editorConfigPsiFile;
        while (true) {
            EditorConfigPsiFile result2;
            PsiFile psiFile;
            PsiFile psiFile2;
            block4: {
                PsiFile[] $this$firstOrNull$iv;
                if (directory == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)directory.getFiles(), (String)"directory.files");
                boolean $i$f$firstOrNull = false;
                PsiFile[] psiFileArray = $this$firstOrNull$iv;
                int n = psiFileArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiFile element$iv;
                    PsiFile it = element$iv = psiFileArray[i];
                    boolean bl = false;
                    if (!(it instanceof EditorConfigPsiFile)) continue;
                    psiFile2 = element$iv;
                    break block4;
                }
                psiFile2 = psiFile = null;
            }
            if (!(psiFile2 instanceof EditorConfigPsiFile)) {
                psiFile = null;
            }
            editorConfigPsiFile = result2 = (EditorConfigPsiFile)psiFile;
            if (editorConfigPsiFile != null) break;
            directory = directory.getParentDirectory();
        }
        return editorConfigPsiFile;
    }

    @Nullable
    public final PsiElement findIdentifierUnderCaret(@Nullable PsiElement element) {
        FileEditorManagerImpl fileEditorManagerImpl;
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        if (!(fileEditorManager instanceof FileEditorManagerImpl)) {
            fileEditorManager = null;
        }
        if ((fileEditorManagerImpl = (FileEditorManagerImpl)fileEditorManager) == null || (fileEditorManagerImpl = fileEditorManagerImpl.getSelectedTextEditor(true)) == null) {
            return null;
        }
        FileEditorManagerImpl editor = fileEditorManagerImpl;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        return this.findIdentifierUnderCaret((Editor)editor, file);
    }

    @Nullable
    public final PsiElement nextVisibleSibling(@NotNull PsiElement element) {
        while (true) {
            PsiElement next;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getNextSibling() == null) {
                return null;
            }
            if (!(next instanceof PsiWhiteSpace)) {
                return next;
            }
            element = next;
        }
    }

    public final void iterateVisibleChildren(@NotNull PsiElement element, @NotNull Function1<? super PsiElement, Unit> acceptor) {
        int $i$f$iterateVisibleChildren = 0;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(acceptor, (String)"acceptor");
        PsiElement child = element.getFirstChild();
        while (child != null) {
            acceptor.invoke((Object)child);
            child = this.nextVisibleSibling(child);
        }
    }

    public final /* synthetic */ <T extends PsiFile> T getOriginalFile(T file) {
        int $i$f$getOriginalFile = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file, Reflection.getOrCreateKotlinClass(PsiFile.class));
    }

    private EditorConfigPsiTreeUtil() {
    }

    static {
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil;
        INSTANCE = editorConfigPsiTreeUtil = new EditorConfigPsiTreeUtil();
    }
}

