/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.convert.toAwt;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toServer.ClientMouseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWheelEvent;
import org.jetbrains.projector.common.protocol.toServer.MouseModifier;
import org.jetbrains.projector.server.core.ReadyClientSettings;
import org.jetbrains.projector.server.core.convert.toClient.ConvertKt;
import org.jetbrains.projector.server.core.util.PropertyKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\f\u001a.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0012\u0010\u001d\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\n0\u001eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"DEFAULT_PIXEL_PER_UNIT", "", "DEFAULT_SCROLL_AMOUNT", "", "PIXEL_DELTA_ENOUGH_FOR_SCROLLING", "PIXEL_PER_UNIT", "PIXEL_PER_UNIT_ENV_NAME", "TOUCH_PIXEL_PER_UNIT", "mouseModifierMask", "", "Lorg/jetbrains/projector/common/protocol/toServer/MouseModifier;", "calculateNewTouchState", "Lorg/jetbrains/projector/server/core/ReadyClientSettings$TouchState;", "shiftedMessage", "Lorg/jetbrains/projector/common/protocol/toServer/ClientMouseEvent;", "message", "currentTouchState", "createMouseEvent", "Ljava/awt/event/MouseEvent;", "source", "Ljava/awt/Component;", "event", "previousTouchState", "newTouchState", "connectionMillis", "", "createMouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientWheelEvent;", "toMouseInt", "", "projector-server-core"})
public final class MouseKt {
    private static final int DEFAULT_SCROLL_AMOUNT = 1;
    @NotNull
    private static final String DEFAULT_PIXEL_PER_UNIT = "100";
    @NotNull
    public static final String PIXEL_PER_UNIT_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_PIXEL_PER_UNIT";
    private static final int PIXEL_PER_UNIT;
    private static final int TOUCH_PIXEL_PER_UNIT;
    private static final int PIXEL_DELTA_ENOUGH_FOR_SCROLLING = 10;
    @NotNull
    private static final Map<MouseModifier, Integer> mouseModifierMask;

    @Nullable
    public static final ReadyClientSettings.TouchState calculateNewTouchState(@NotNull ClientMouseEvent shiftedMessage, @NotNull ClientMouseEvent message2, @NotNull ReadyClientSettings.TouchState currentTouchState) {
        ReadyClientSettings.TouchState touchState;
        Intrinsics.checkNotNullParameter((Object)shiftedMessage, (String)"shiftedMessage");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)currentTouchState, (String)"currentTouchState");
        ClientMouseEvent.MouseEventType mouseEventType = shiftedMessage.getMouseEventType();
        int n = WhenMappings.$EnumSwitchMapping$0[mouseEventType.ordinal()];
        switch (n) {
            case 1: {
                touchState = ReadyClientSettings.TouchState.Released.INSTANCE;
                break;
            }
            case 2: {
                touchState = new ReadyClientSettings.TouchState.OnlyPressed(message2.getTimeStamp(), shiftedMessage.getX(), shiftedMessage.getY());
                break;
            }
            case 3: {
                ReadyClientSettings.TouchState touchState2 = currentTouchState;
                if (touchState2 instanceof ReadyClientSettings.TouchState.Scrolling) {
                    ReadyClientSettings.TouchState.Scrolling scrolling;
                    boolean bl = MouseKt.calculateNewTouchState$isEnoughDeltaForScrolling((ReadyClientSettings.TouchState.Scrolling)currentTouchState, shiftedMessage.getX(), shiftedMessage.getY());
                    if (bl) {
                        scrolling = new ReadyClientSettings.TouchState.Scrolling(((ReadyClientSettings.TouchState.Scrolling)currentTouchState).getInitialX(), ((ReadyClientSettings.TouchState.Scrolling)currentTouchState).getInitialY(), shiftedMessage.getX(), shiftedMessage.getY());
                    } else if (!bl) {
                        scrolling = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    touchState = scrolling;
                    break;
                }
                if (touchState2 instanceof ReadyClientSettings.TouchState.Dragging) {
                    touchState = ReadyClientSettings.TouchState.Dragging.INSTANCE;
                    break;
                }
                if (touchState2 instanceof ReadyClientSettings.TouchState.OnlyPressed) {
                    boolean bl;
                    boolean bl2 = bl = ((ReadyClientSettings.TouchState.OnlyPressed)currentTouchState).getConnectionMillis() + 500 < shiftedMessage.getTimeStamp();
                    if (bl) {
                        touchState = ReadyClientSettings.TouchState.Dragging.INSTANCE;
                        break;
                    }
                    if (!bl) {
                        touchState = new ReadyClientSettings.TouchState.Scrolling(((ReadyClientSettings.TouchState.OnlyPressed)currentTouchState).getLastX(), ((ReadyClientSettings.TouchState.OnlyPressed)currentTouchState).getLastY(), shiftedMessage.getX(), shiftedMessage.getY());
                        break;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (touchState2 instanceof ReadyClientSettings.TouchState.Released) {
                    touchState = ReadyClientSettings.TouchState.Released.INSTANCE;
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                touchState = currentTouchState;
            }
        }
        return touchState;
    }

    @NotNull
    public static final MouseEvent createMouseEvent(@NotNull Component source, @NotNull ClientMouseEvent event, @NotNull ReadyClientSettings.TouchState previousTouchState, @NotNull ReadyClientSettings.TouchState newTouchState, long connectionMillis) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)previousTouchState, (String)"previousTouchState");
        Intrinsics.checkNotNullParameter((Object)newTouchState, (String)"newTouchState");
        Point locationOnScreen = source.getLocationOnScreen();
        ClientMouseEvent.MouseEventType mouseEventType = event.getMouseEventType();
        int n3 = WhenMappings.$EnumSwitchMapping$0[mouseEventType.ordinal()];
        switch (n3) {
            case 4: {
                n2 = 503;
                break;
            }
            case 2: {
                n2 = 501;
                break;
            }
            case 1: {
                n2 = 502;
                break;
            }
            case 5: {
                n2 = 500;
                break;
            }
            case 6: {
                n2 = 505;
                break;
            }
            case 7: {
                n2 = 506;
                break;
            }
            case 3: {
                if (previousTouchState instanceof ReadyClientSettings.TouchState.WithCoordinates && newTouchState instanceof ReadyClientSettings.TouchState.Scrolling) {
                    int deltaY;
                    int deltaX = ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getLastX() - ((ReadyClientSettings.TouchState.WithCoordinates)((Object)previousTouchState)).getLastX();
                    Pair pair = MouseKt.createMouseEvent$isHorizontal(deltaX, deltaY = ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getLastY() - ((ReadyClientSettings.TouchState.WithCoordinates)((Object)previousTouchState)).getLastY()) ? TuplesKt.to((Object)deltaX, (Object)(MouseKt.toMouseInt(event.getModifiers()) | 0x40)) : TuplesKt.to((Object)deltaY, (Object)MouseKt.toMouseInt(event.getModifiers()));
                    int wheelDelta = ((Number)pair.component1()).intValue();
                    int modifiers = ((Number)pair.component2()).intValue();
                    int negatedWheelDelta = -wheelDelta;
                    double normalizedWheelDelta = (double)negatedWheelDelta / (double)TOUCH_PIXEL_PER_UNIT;
                    int notNullNormalizedWheelDelta = (int)ConvertKt.roundToInfinity(normalizedWheelDelta);
                    return new MouseWheelEvent(source, 507, connectionMillis + (long)event.getTimeStamp(), modifiers, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialX() - locationOnScreen.x, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialY() - locationOnScreen.y, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialX() - locationOnScreen.x, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialY() - locationOnScreen.y, 0, false, 0, 1, notNullNormalizedWheelDelta, normalizedWheelDelta);
                }
                n2 = 506;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int id = n2;
        ClientMouseEvent.MouseEventType mouseEventType2 = event.getMouseEventType();
        int deltaX = WhenMappings.$EnumSwitchMapping$0[mouseEventType2.ordinal()];
        switch (deltaX) {
            case 4: 
            case 6: {
                n = 0;
                break;
            }
            default: {
                n = event.getButton() + 1;
            }
        }
        int awtEventButton = n;
        int modifiers = MouseKt.toMouseInt(event.getModifiers());
        int buttonModifier = awtEventButton == 0 || event.getMouseEventType() == ClientMouseEvent.MouseEventType.UP ? 0 : InputEvent.getMaskForButton(awtEventButton);
        boolean canTriggerPopup = awtEventButton == 3 && id == 501;
        return new MouseEvent(source, id, connectionMillis + (long)event.getTimeStamp(), modifiers | buttonModifier, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, event.getClickCount(), canTriggerPopup, awtEventButton);
    }

    @NotNull
    public static final MouseWheelEvent createMouseWheelEvent(@NotNull Component source, @NotNull ClientWheelEvent event, long connectionMillis) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Pair pair2 = MouseKt.createMouseWheelEvent$isHorizontal-0(event) ? TuplesKt.to((Object)event.getDeltaX(), (Object)(MouseKt.toMouseInt(event.getModifiers()) | 0x40)) : TuplesKt.to((Object)event.getDeltaY(), (Object)MouseKt.toMouseInt(event.getModifiers()));
        double wheelDelta = ((Number)pair2.component1()).doubleValue();
        int modifiers = ((Number)pair2.component2()).intValue();
        ClientWheelEvent.ScrollingMode scrollingMode = event.getMode();
        int n = WhenMappings.$EnumSwitchMapping$1[scrollingMode.ordinal()];
        switch (n) {
            case 1: {
                pair = TuplesKt.to((Object)0, (Object)(wheelDelta / (double)PIXEL_PER_UNIT));
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)0, (Object)wheelDelta);
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)1, (Object)wheelDelta);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair3 = pair;
        int mode = ((Number)pair3.component1()).intValue();
        double normalizedWheelDelta = ((Number)pair3.component2()).doubleValue();
        int notNullNormalizedWheelDelta = (int)ConvertKt.roundToInfinity(normalizedWheelDelta);
        Point locationOnScreen = source.getLocationOnScreen();
        return new MouseWheelEvent(source, 507, connectionMillis + (long)event.getTimeStamp(), modifiers, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, 0, false, mode, 1, notNullNormalizedWheelDelta, normalizedWheelDelta);
    }

    /*
     * WARNING - void declaration
     */
    private static final int toMouseInt(Set<? extends MouseModifier> $this$toMouseInt) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = $this$toMouseInt;
        Map<MouseModifier, Integer> map = mouseModifierMask;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MouseModifier mouseModifier = (MouseModifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = MapsKt.getValue(map, (Object)p0);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            int n = ((Number)element$iv).intValue();
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 | p1;
        }
        return accumulator$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calculateNewTouchState$isEnoughDeltaForScrolling(ReadyClientSettings.TouchState.Scrolling previousTouchState, int newX, int newY) {
        int n = newX - previousTouchState.getLastX();
        boolean bl = false;
        if (Math.abs(n) > 10) return true;
        n = newY - previousTouchState.getLastY();
        bl = false;
        if (Math.abs(n) <= 10) return false;
        return true;
    }

    private static final boolean createMouseEvent$isHorizontal(int deltaX, int deltaY) {
        int n = deltaX;
        boolean bl = false;
        int n2 = Math.abs(n);
        n = deltaY;
        bl = false;
        return n2 > Math.abs(n);
    }

    private static final boolean createMouseWheelEvent$isHorizontal-0(ClientWheelEvent event) {
        double d = event.getDeltaX();
        boolean bl = false;
        double d2 = Math.abs(d);
        d = event.getDeltaY();
        bl = false;
        return d2 > Math.abs(d);
    }

    static {
        Pair[] pairArray = PropertyKt.getOption(PIXEL_PER_UNIT_ENV_NAME, DEFAULT_PIXEL_PER_UNIT);
        boolean bl = false;
        PIXEL_PER_UNIT = Integer.parseInt((String)pairArray);
        TOUCH_PIXEL_PER_UNIT = 3 * PIXEL_PER_UNIT;
        pairArray = new Pair[]{TuplesKt.to((Object)MouseModifier.ALT_KEY, (Object)512), TuplesKt.to((Object)MouseModifier.CTRL_KEY, (Object)128), TuplesKt.to((Object)MouseModifier.SHIFT_KEY, (Object)64), TuplesKt.to((Object)MouseModifier.META_KEY, (Object)256)};
        mouseModifierMask = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ClientMouseEvent.MouseEventType.values().length];
            nArray[ClientMouseEvent.MouseEventType.UP.ordinal()] = 1;
            nArray[ClientMouseEvent.MouseEventType.DOWN.ordinal()] = 2;
            nArray[ClientMouseEvent.MouseEventType.TOUCH_DRAG.ordinal()] = 3;
            nArray[ClientMouseEvent.MouseEventType.MOVE.ordinal()] = 4;
            nArray[ClientMouseEvent.MouseEventType.CLICK.ordinal()] = 5;
            nArray[ClientMouseEvent.MouseEventType.OUT.ordinal()] = 6;
            nArray[ClientMouseEvent.MouseEventType.DRAG.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ClientWheelEvent.ScrollingMode.values().length];
            nArray[ClientWheelEvent.ScrollingMode.PIXEL.ordinal()] = 1;
            nArray[ClientWheelEvent.ScrollingMode.LINE.ordinal()] = 2;
            nArray[ClientWheelEvent.ScrollingMode.PAGE.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

