/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij.md;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/LocalImagesInliner;", "", "()V", "inlineImage", "", "localPath", "Ljava/nio/file/Path;", "extension", "inlineLocalImages", "html", "projector-server-core"})
public final class LocalImagesInliner {
    @NotNull
    public static final LocalImagesInliner INSTANCE = new LocalImagesInliner();

    private LocalImagesInliner() {
    }

    @NotNull
    public final String inlineLocalImages(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Document doc = Jsoup.parse((String)html);
        Elements images = doc.getElementsByTag("img");
        Intrinsics.checkNotNullExpressionValue((Object)images, (String)"images");
        Iterable $this$forEach$iv = (Iterable)images;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String src = it.attr("src");
            Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
            if (!StringsKt.startsWith$default((String)src, (String)"file:", (boolean)false, (int)2, null)) continue;
            String extension = StringsKt.substringAfterLast((String)src, (char)'.', (String)"");
            Path path = Path.of(new URI(StringsKt.substringBefore$default((String)src, (char)'?', null, (int)2, null)));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String inlinedImage = INSTANCE.inlineImage(path, extension);
            it.attr("src", inlinedImage);
        }
        String string = doc.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc.toString()");
        return string;
    }

    private final String inlineImage(Path localPath, String extension) {
        String string;
        try {
            byte[] bytes = Files.readAllBytes(localPath);
            String base64Content = Base64.getEncoder().encodeToString(bytes);
            String string2 = extension;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            String string5 = string4;
            string = Intrinsics.areEqual((Object)string5, (Object)"svg") ? "data:image/svg+xml;base64," + base64Content : "data:image/" + extension + ";base64," + base64Content;
        }
        catch (Throwable t) {
            string = "Can't inline image because of " + t;
        }
        return string;
    }
}

