/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    private static final Logger LOG = Logger.getInstance(MergeableLineMarkerInfo.class);
    private @Nullable Function<PsiElement, @Nls(capitalization=Nls.Capitalization.Title) String> myPresentationProvider;

    @Deprecated
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon2, int __, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(2);
        }
        super(element, textRange, icon2, tooltipProvider, navHandler, alignment);
        this.myPresentationProvider = null;
    }

    @Deprecated
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon2, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(3);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(4);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(5);
        }
        super(element, textRange, icon2, tooltipProvider, navHandler, alignment);
        this.myPresentationProvider = null;
    }

    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, @NotNull Icon icon2, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull @NotNull Supplier<@NotNull @Nls String> accessibleNameProvider) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(7);
        }
        if (icon2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(8);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(9);
        }
        if (accessibleNameProvider == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(10);
        }
        super(element, textRange, icon2, tooltipProvider, navHandler, alignment, accessibleNameProvider);
        this.myPresentationProvider = null;
    }

    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, @NotNull Icon icon2, @Nullable Function<? super T, String> tooltipProvider, @Nullable Function<PsiElement, @Nls(capitalization=Nls.Capitalization.Title) String> presentationProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment, @NotNull @NotNull Supplier<@NotNull @Nls String> accessibleNameProvider) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(11);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(12);
        }
        if (icon2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(13);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(14);
        }
        if (accessibleNameProvider == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(15);
        }
        super(element, textRange, icon2, tooltipProvider, navHandler, alignment, accessibleNameProvider);
        this.myPresentationProvider = null;
        this.myPresentationProvider = presentationProvider;
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> var1);

    @NotNull
    public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(16);
        }
        Function function = element -> {
            HashSet tooltips = new HashSet(ContainerUtil.mapNotNull((Collection)infos, info -> info.getLineMarkerTooltip()));
            StringBuilder tooltip = new StringBuilder();
            for (String info2 : tooltips) {
                if (tooltip.length() > 0) {
                    tooltip.append("<hr size=1 noshade>");
                }
                tooltip.append(UIUtil.getHtmlBody((String)info2));
            }
            return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
        };
        if (function == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(17);
        }
        return function;
    }

    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(18);
        }
        return GutterIconRenderer.Alignment.LEFT;
    }

    private static Supplier<@NotNull @Nls String> getCommonAccessibleNameProvider(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(19);
        }
        return infos.get(0).getAccessibleNameProvider();
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getElementPresentation(@NotNull PsiElement element) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(20);
        }
        String string = this.myPresentationProvider != null ? (String)this.myPresentationProvider.fun((Object)element) : element.getText();
        if (string == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static List<LineMarkerInfo<?>> merge(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(22);
        }
        SmartList result = new SmartList();
        for (int i2 = 0; i2 < markers.size(); ++i2) {
            MergeableLineMarkerInfo<?> marker = markers.get(i2);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i2; --k) {
                MergeableLineMarkerInfo<?> current = markers.get(k);
                boolean canMergeWith = marker.canMergeWith(current);
                if (ApplicationManager.getApplication().isUnitTestMode() && !canMergeWith && current.canMergeWith(marker)) {
                    LOG.error(current.getClass() + "[" + current.getLineMarkerTooltip() + "] can merge " + marker.getClass() + "[" + marker.getLineMarkerTooltip() + "], but not vice versa");
                }
                if (!canMergeWith) continue;
                toMerge.add(0, current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result.add(new MyLineMarkerInfo((List<? extends MergeableLineMarkerInfo<?>>)toMerge));
        }
        SmartList smartList = result;
        if (smartList == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessibleNameProvider";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTooltip";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTooltip";
                break;
            }
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIconAlignment";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAccessibleNameProvider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getElementPresentation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MergedGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final List<LineMarkerInfo<?>> myInfos;

        MergedGutterIconNavigationHandler(List<? extends MergeableLineMarkerInfo<?>> markers) {
            ArrayList infos = new ArrayList(markers);
            infos.sort(Comparator.comparingInt(o -> o.startOffset));
            this.myInfos = Collections.unmodifiableList(infos);
        }

        @NotNull
        List<LineMarkerInfo<?>> getMergedLineMarkersInfos() {
            List<LineMarkerInfo<?>> list = this.myInfos;
            if (list == null) {
                MergedGutterIconNavigationHandler.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public void navigate(MouseEvent e, PsiElement elt) {
            IPopupChooserBuilder<LineMarkerInfo<?>> builder = JBPopupFactory.getInstance().createPopupChooserBuilder(this.myInfos);
            builder.setRenderer(new SelectionAwareListCellRenderer(dom -> {
                Object element;
                Icon icon2 = null;
                GutterIconRenderer renderer = dom.createGutterRenderer();
                if (renderer != null) {
                    Icon originalIcon = renderer.getIcon();
                    icon2 = IconUtil.scale((Icon)originalIcon, null, (float)(JBUIScale.scale((float)16.0f) / (float)originalIcon.getIconWidth()));
                }
                String elementPresentation = (element = dom.getElement()) == null ? IdeBundle.message("node.structureview.invalid", new Object[0]) : (dom instanceof MergeableLineMarkerInfo ? ((MergeableLineMarkerInfo)dom).getElementPresentation((PsiElement)element) : element.getText());
                String text2 = StringUtil.first((String)elementPresentation, (int)100, (boolean)true).replace('\n', ' ');
                JBLabel label = new JBLabel(text2, icon2, 2);
                label.setBorder(JBUI.Borders.empty((int)2));
                return label;
            }));
            builder.setItemChosenCallback(value2 -> {
                GutterIconNavigationHandler handler = value2.getNavigationHandler();
                if (handler != null) {
                    handler.navigate(e, value2.getElement());
                }
            }).createPopup().show(new RelativePoint(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MergedGutterIconNavigationHandler", "getMergedLineMarkersInfos"));
        }
    }

    private static final class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private DefaultActionGroup myCommonActionGroup;

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(0);
            }
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers, @NotNull MergeableLineMarkerInfo<?> template) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (template == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), MergeableLineMarkerInfo.getCommonAccessibleNameProvider(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
            this.myCommonActionGroup = MyLineMarkerInfo.getCommonActionGroup(markers);
        }

        private static DefaultActionGroup getCommonActionGroup(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(3);
            }
            DefaultActionGroup commonActionGroup = null;
            boolean first = true;
            for (MergeableLineMarkerInfo<?> marker : markers) {
                ActionGroup actions;
                GutterIconRenderer renderer = marker.createGutterRenderer();
                if (renderer == null || (actions = renderer.getPopupMenuActions()) == null) continue;
                if (commonActionGroup == null) {
                    commonActionGroup = new DefaultActionGroup();
                }
                if (!first) {
                    commonActionGroup.add(Separator.getInstance());
                }
                first = false;
                commonActionGroup.addAll(actions);
            }
            return commonActionGroup;
        }

        @NotNull
        private static TextRange getCommonTextRange(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(4);
            }
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo<?> marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
            if (textRange == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @NotNull
        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(6);
            }
            return new MergedGutterIconNavigationHandler(markers);
        }

        @Override
        public GutterIconRenderer createGutterRenderer() {
            if (this.myCommonActionGroup == null) {
                return super.createGutterRenderer();
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                @Override
                public AnAction getClickAction() {
                    return null;
                }

                @Override
                public boolean isNavigateAction() {
                    return true;
                }

                @Override
                public ActionGroup getPopupMenuActions() {
                    return myCommonActionGroup;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonActionGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTextRange";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonNavigationHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

