/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentIntObjectHashMap;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.SimpleEntry;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentIntKeyRefValueHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectHashMap<IntReference<V>> myMap = new ConcurrentIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentIntKeyRefValueHashMap() {
    }

    @NotNull
    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, @NotNull ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @NotNull
    public V cacheOrGet(int key, @NotNull V value2) {
        Object result;
        block5: {
            IntReference<V> ref;
            boolean replaced;
            if (value2 == null) {
                ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(0);
            }
            IntReference<V> newRef = this.createReference(key, value2, this.myQueue);
            do {
                if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                    result = value2;
                } else {
                    Object old = ref.get();
                    if (old == null) continue;
                    result = old;
                }
                break block5;
            } while (!(replaced = this.myMap.replace(key, ref, newRef)));
            result = value2;
        }
        this.processQueue();
        V v = result;
        if (v == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(1);
        }
        return v;
    }

    public boolean remove(int key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(2);
        }
        boolean removed = this.myMap.remove(key, this.createReference(key, value2, this.myQueue));
        this.processQueue();
        return removed;
    }

    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(3);
        }
        if (newValue == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(4);
        }
        boolean replaced = this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
        this.processQueue();
        return replaced;
    }

    public V put(int key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(5);
        }
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value2, this.myQueue));
        this.processQueue();
        return (V)SoftReference.deref(ref);
    }

    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return (V)SoftReference.deref(ref);
    }

    public V remove(int key) {
        IntReference<V> ref = this.myMap.remove(key);
        this.processQueue();
        return (V)SoftReference.deref(ref);
    }

    @NotNull
    private static IncorrectOperationException pointlessContainsKey() {
        return new IncorrectOperationException("containsKey() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @NotNull
    private static IncorrectOperationException pointlessContainsValue() {
        return new IncorrectOperationException("containsValue() makes no sense for weak/soft map because GC can clear the key any moment now");
    }

    public boolean containsKey(int key) {
        throw ConcurrentIntKeyRefValueHashMap.pointlessContainsKey();
    }

    public boolean containsValue(@NotNull V value2) {
        if (value2 == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(6);
        }
        throw ConcurrentIntKeyRefValueHashMap.pointlessContainsValue();
    }

    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    public int @NotNull [] keys() {
        int[] nArray = this.myMap.keys();
        if (nArray == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(7);
        }
        return nArray;
    }

    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        return new MyEntrySetView();
    }

    @NotNull
    private Iterator<IntObjectMap.Entry<V>> entriesIterator() {
        final Iterator entryIterator = this.myMap.entrySet().iterator();
        return new Iterator<IntObjectMap.Entry<V>>(){
            private IntObjectMap.Entry<V> nextVEntry;
            private IntObjectMap.Entry<IntReference<V>> nextReferenceEntry;
            private IntObjectMap.Entry<IntReference<V>> lastReturned;
            {
                this.nextAliveEntry();
            }

            @Override
            public boolean hasNext() {
                return this.nextVEntry != null;
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntObjectMap.Entry result = this.nextVEntry;
                this.lastReturned = this.nextReferenceEntry;
                this.nextAliveEntry();
                return result;
            }

            private void nextAliveEntry() {
                while (entryIterator.hasNext()) {
                    IntObjectMap.Entry entry = (IntObjectMap.Entry)entryIterator.next();
                    Object v = ((IntReference)entry.getValue()).get();
                    if (v == null) continue;
                    int key = entry.getKey();
                    this.nextVEntry = new SimpleEntry(key, v);
                    this.nextReferenceEntry = entry;
                    return;
                }
                this.nextVEntry = null;
            }

            @Override
            public void remove() {
                IntObjectMap.Entry last = this.lastReturned;
                if (last == null) {
                    throw new NoSuchElementException();
                }
                ConcurrentIntKeyRefValueHashMap.this.myMap.replaceNode(last.getKey(), null, last.getValue());
            }
        };
    }

    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    public boolean isEmpty() {
        this.processQueue();
        return this.myMap.isEmpty();
    }

    @NotNull
    public Enumeration<V> elements() {
        final Enumeration<IntReference<V>> elementRefs = this.myMap.elements();
        return new Enumeration<V>(){
            private V next = this.findNextRef();

            private V findNextRef() {
                while (elementRefs.hasMoreElements()) {
                    IntReference result = (IntReference)elementRefs.nextElement();
                    Object v = result.get();
                    if (v == null) continue;
                    return v;
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public V nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = this.findNextRef();
                return v;
            }
        };
    }

    public V putIfAbsent(int key, @NotNull V value2) {
        Object prev;
        if (value2 == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(8);
        }
        IntReference<V> newRef = this.createReference(key, value2, this.myQueue);
        while (true) {
            IntReference<V> oldRef;
            if ((oldRef = this.myMap.putIfAbsent(key, newRef)) == null) {
                prev = null;
                break;
            }
            Object oldVal = oldRef.get();
            if (oldVal == null) {
                if (this.myMap.replace(key, oldRef, newRef)) {
                    prev = null;
                    break;
                }
            } else {
                prev = oldVal;
                break;
            }
            this.processQueue();
        }
        this.processQueue();
        return prev;
    }

    @NotNull
    public Collection<V> values() {
        HashSet<V> result = new HashSet<V>();
        Enumeration<V> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        HashSet<V> hashSet = result;
        if (hashSet == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/ConcurrentIntKeyRefValueHashMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/ConcurrentIntKeyRefValueHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyEntrySetView
    extends AbstractSet<IntObjectMap.Entry<V>> {
        private MyEntrySetView() {
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            Iterator iterator = ConcurrentIntKeyRefValueHashMap.this.entriesIterator();
            if (iterator == null) {
                MyEntrySetView.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Override
        public int size() {
            return ConcurrentIntKeyRefValueHashMap.this.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/ConcurrentIntKeyRefValueHashMap$MyEntrySetView", "iterator"));
        }
    }

    static interface IntReference<V>
    extends Supplier<V> {
        public int getKey();
    }
}

