/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationContext {
    private static final Logger LOG = Logger.getInstance(ConfigurationContext.class);
    public static final Key<ConfigurationContext> SHARED_CONTEXT = Key.create((String)"SHARED_CONTEXT");
    private final Location<PsiElement> myLocation;
    private final Editor myEditor;
    private RunnerAndConfigurationSettings myConfiguration;
    private boolean myInitialized;
    private boolean myMultipleSelection;
    private Ref<RunnerAndConfigurationSettings> myExistingConfiguration;
    private final Module myModule;
    private final RunConfiguration myRuntimeConfiguration;
    private final DataContext myDataContext;
    private final String myPlace;
    private List<RuntimeConfigurationProducer> myPreferredProducers;
    private List<ConfigurationFromContext> myConfigurationsFromContext;

    @Deprecated
    @NotNull
    public static ConfigurationContext getFromContext(DataContext dataContext) {
        return ConfigurationContext.getFromContext(dataContext, "unknown");
    }

    @NotNull
    public static ConfigurationContext getFromContext(DataContext dataContext, String place) {
        PsiElement psiElement;
        DataManager dataManager = DataManager.getInstance();
        ConfigurationContext sharedContext = dataManager.loadFromDataContext(dataContext, SHARED_CONTEXT);
        Location sharedLocation = sharedContext == null ? null : sharedContext.getLocation();
        Object sharedPsiElement = sharedLocation == null ? null : sharedLocation.getPsiElement();
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        Location<PsiElement> location = ConfigurationContext.calcLocation(dataContext, module);
        PsiElement psiElement2 = psiElement = location == null ? null : location.getPsiElement();
        if (sharedLocation == null || location == null || !Comparing.equal(sharedPsiElement, (Object)psiElement)) {
            boolean isMultipleSelection = ConfigurationContext.isMultipleSelection(dataContext);
            sharedContext = new ConfigurationContext(dataContext, location, module, isMultipleSelection, place);
            dataManager.saveInDataContext(dataContext, SHARED_CONTEXT, sharedContext);
        }
        ConfigurationContext configurationContext = sharedContext;
        if (configurationContext == null) {
            ConfigurationContext.$$$reportNull$$$0(0);
        }
        return configurationContext;
    }

    @NotNull
    public static ConfigurationContext createEmptyContextForLocation(@NotNull Location location) {
        if (location == null) {
            ConfigurationContext.$$$reportNull$$$0(1);
        }
        return new ConfigurationContext(location);
    }

    private ConfigurationContext(DataContext dataContext, Location<PsiElement> location, Module module, boolean multipleSelection, String place) {
        ExecutionEnvironment environment;
        RunConfiguration configuration = (RunConfiguration)RunConfiguration.DATA_KEY.getData(dataContext);
        if (configuration == null && (environment = (ExecutionEnvironment)((Object)dataContext.getData(ExecutionDataKeys.EXECUTION_ENVIRONMENT))) != null) {
            this.myConfiguration = environment.getRunnerAndConfigurationSettings();
            if (this.myConfiguration != null) {
                this.myExistingConfiguration = Ref.create((Object)this.myConfiguration);
                configuration = this.myConfiguration.getConfiguration();
            }
        }
        this.myEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.myRuntimeConfiguration = configuration;
        this.myDataContext = dataContext;
        this.myModule = module;
        this.myLocation = location;
        this.myMultipleSelection = multipleSelection;
        this.myPlace = place;
    }

    @Nullable
    private static Location<PsiElement> calcLocation(@NotNull DataContext dataContext, Module module) {
        Location location;
        if (dataContext == null) {
            ConfigurationContext.$$$reportNull$$$0(2);
        }
        if ((location = (Location)Location.DATA_KEY.getData(dataContext)) != null) {
            return location;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        PsiElement element = ConfigurationContext.getSelectedPsiElement(dataContext, project);
        if (element == null) {
            return null;
        }
        return new PsiLocation<PsiElement>(project, module, element);
    }

    private static boolean isMultipleSelection(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ConfigurationContext.$$$reportNull$$$0(3);
        }
        Location location = (Location)Location.DATA_KEY.getData(dataContext);
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        return location != null && locations != null && locations.length > 1 || elements != null && elements.length > 1 || files != null && files.length > 1;
    }

    public ConfigurationContext(@NotNull PsiElement element) {
        if (element == null) {
            ConfigurationContext.$$$reportNull$$$0(4);
        }
        this.myModule = ModuleUtilCore.findModuleForPsiElement(element);
        this.myLocation = new PsiLocation<PsiElement>(element.getProject(), this.myModule, element);
        this.myRuntimeConfiguration = null;
        this.myDataContext = this::getDefaultData;
        this.myEditor = null;
        this.myPlace = null;
    }

    private ConfigurationContext(@NotNull Location location) {
        if (location == null) {
            ConfigurationContext.$$$reportNull$$$0(5);
        }
        this.myLocation = location;
        this.myModule = location.getModule();
        this.myEditor = null;
        this.myRuntimeConfiguration = null;
        this.myDataContext = this::getDefaultData;
        this.myPlace = null;
    }

    private Object getDefaultData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myLocation.getProject();
        }
        if (PlatformCoreDataKeys.MODULE.is(dataId)) {
            return this.myModule;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return this.myLocation;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.myLocation.getPsiElement();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return ContainerUtil.ar((Object[])new PsiElement[]{this.myLocation.getPsiElement()});
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return PsiUtilCore.getVirtualFile(this.myLocation.getPsiElement());
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    public DataContext getDefaultDataContext() {
        return this::getDefaultData;
    }

    public boolean containsMultipleSelection() {
        return this.myMultipleSelection;
    }

    @Nullable
    public synchronized RunnerAndConfigurationSettings getConfiguration() {
        if (this.myConfiguration == null && !this.myInitialized) {
            this.createConfiguration();
        }
        return this.myConfiguration;
    }

    private void createConfiguration() {
        LOG.assertTrue(this.myConfiguration == null);
        Location location = this.getLocation();
        this.myConfiguration = location != null && !DumbService.isDumb(location.getProject()) ? PreferredProducerFind.createConfiguration(location, this) : null;
        this.myInitialized = true;
    }

    public synchronized void setConfiguration(@NotNull RunnerAndConfigurationSettings configuration) {
        if (configuration == null) {
            ConfigurationContext.$$$reportNull$$$0(6);
        }
        this.myConfiguration = configuration;
        this.myInitialized = true;
    }

    @Nullable
    public Location getLocation() {
        return this.myLocation;
    }

    @Nullable
    public String getPlace() {
        return this.myPlace;
    }

    @Nullable
    public PsiElement getPsiLocation() {
        return this.myLocation != null ? this.myLocation.getPsiElement() : null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExisting() {
        RunnerAndConfigurationSettings configuration;
        RunnerAndConfigurationSettings configuration2;
        if (this.myExistingConfiguration != null && ((configuration2 = (RunnerAndConfigurationSettings)this.myExistingConfiguration.get()) == null || !Registry.is((String)"suggest.all.run.configurations.from.context") || configuration2.equals(this.myConfiguration))) {
            return configuration2;
        }
        this.myExistingConfiguration = new Ref();
        if (this.myLocation == null) {
            return null;
        }
        PsiElement psiElement = this.myLocation.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        if (MultipleRunLocationsProvider.findAlternativeLocations(this.myLocation) != null) {
            this.myExistingConfiguration.set(null);
            return null;
        }
        List<RuntimeConfigurationProducer> producers = this.findPreferredProducers();
        ArrayList<ExistingConfiguration> existingConfigurations = new ArrayList<ExistingConfiguration>();
        if (producers != null) {
            for (RuntimeConfigurationProducer runtimeConfigurationProducer : producers) {
                configuration = runtimeConfigurationProducer.findExistingConfiguration(this.myLocation, this);
                if (configuration == null) continue;
                existingConfigurations.add(new ExistingConfiguration(configuration, null));
            }
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(this.getProject())) {
            configuration = runConfigurationProducer.findExistingConfiguration(this);
            if (configuration == null) continue;
            existingConfigurations.add(new ExistingConfiguration(configuration, runConfigurationProducer));
        }
        this.myExistingConfiguration.set((Object)this.findPreferredConfiguration(existingConfigurations, psiElement));
        return (RunnerAndConfigurationSettings)this.myExistingConfiguration.get();
    }

    @Nullable
    private RunnerAndConfigurationSettings findPreferredConfiguration(@NotNull List<ExistingConfiguration> existingConfigurations, @NotNull PsiElement psiElement) {
        List<ConfigurationFromContext> configurationsFromContext;
        if (existingConfigurations == null) {
            ConfigurationContext.$$$reportNull$$$0(7);
        }
        if (psiElement == null) {
            ConfigurationContext.$$$reportNull$$$0(8);
        }
        if ((configurationsFromContext = this.getConfigurationsFromContext()) == null) {
            return null;
        }
        for (ExistingConfiguration configuration2 : existingConfigurations) {
            RunnerAndConfigurationSettings settings = configuration2.getSettings();
            if (settings.equals(this.myConfiguration)) {
                return settings;
            }
            if (this.myRuntimeConfiguration == null || settings.getConfiguration() != this.myRuntimeConfiguration) continue;
            return settings;
        }
        Set fromContextSettings = configurationsFromContext.stream().map(c -> c.getConfigurationSettings()).collect(Collectors.toSet());
        if (!ContainerUtil.exists(existingConfigurations, e -> fromContextSettings.contains(e.getSettings()))) {
            return null;
        }
        if (Registry.is((String)"suggest.all.run.configurations.from.context")) {
            return null;
        }
        List contexts = ContainerUtil.mapNotNull(existingConfigurations, configuration -> {
            if (configuration.getProducer() == null || !fromContextSettings.contains(configuration.getSettings())) {
                return null;
            }
            return new ConfigurationFromContextImpl(configuration.getProducer(), configuration.getSettings(), psiElement);
        });
        if (!contexts.isEmpty()) {
            ConfigurationFromContext min = Collections.min(contexts, ConfigurationFromContext.COMPARATOR);
            return min.getConfigurationSettings();
        }
        ExistingConfiguration first = (ExistingConfiguration)ContainerUtil.getFirstItem(existingConfigurations);
        return first != null ? first.getSettings() : null;
    }

    @Nullable
    private static PsiElement getSelectedPsiElement(DataContext dataContext, Project project) {
        VirtualFile[] files;
        int offset;
        PsiFile psiFile;
        PsiElement element = null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null && (element = psiFile.findElementAt(offset = editor.getCaretModel().getOffset())) == null && offset > 0 && offset == psiFile.getTextLength()) {
            element = psiFile.findElementAt(offset - 1);
        }
        if (element == null) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            PsiElement psiElement = element = elements != null && elements.length > 0 ? elements[0] : null;
        }
        if (element == null && (files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 0) {
            element = PsiManager.getInstance(project).findFile(files[0]);
        }
        return element;
    }

    @NotNull
    public RunManager getRunManager() {
        RunManager runManager = RunManager.getInstance(this.getProject());
        if (runManager == null) {
            ConfigurationContext.$$$reportNull$$$0(9);
        }
        return runManager;
    }

    public Project getProject() {
        return this.myConfiguration == null ? this.myLocation.getProject() : this.myConfiguration.getConfiguration().getProject();
    }

    public Module getModule() {
        return this.myModule;
    }

    public DataContext getDataContext() {
        return this.myDataContext;
    }

    @Nullable
    public RunConfiguration getOriginalConfiguration(@Nullable ConfigurationType type) {
        if (type == null || this.myRuntimeConfiguration != null && this.myRuntimeConfiguration.getType() == type) {
            return this.myRuntimeConfiguration;
        }
        return null;
    }

    public boolean isCompatibleWithOriginalRunConfiguration(@NotNull ConfigurationType type) {
        if (type == null) {
            ConfigurationContext.$$$reportNull$$$0(10);
        }
        return this.myRuntimeConfiguration == null || this.myRuntimeConfiguration.getType() == type;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public List<RuntimeConfigurationProducer> findPreferredProducers() {
        if (this.myPreferredProducers == null) {
            this.myPreferredProducers = PreferredProducerFind.findPreferredProducers(this.myLocation, this, true);
        }
        return this.myPreferredProducers;
    }

    @Nullable
    public List<ConfigurationFromContext> getConfigurationsFromContext() {
        if (this.myConfigurationsFromContext == null) {
            this.myConfigurationsFromContext = PreferredProducerFind.getConfigurationsFromContext(this.myLocation, this, true);
        }
        return this.myConfigurationsFromContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ConfigurationContext";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingConfigurations";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ConfigurationContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyContextForLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcLocation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMultipleSelection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWithOriginalRunConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExistingConfiguration {
        private final RunnerAndConfigurationSettings myConfigurationSettings;
        private final RunConfigurationProducer<?> myProducer;

        private ExistingConfiguration(@NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable RunConfigurationProducer<?> producer) {
            if (configurationSettings == null) {
                ExistingConfiguration.$$$reportNull$$$0(0);
            }
            this.myConfigurationSettings = configurationSettings;
            this.myProducer = producer;
        }

        @NotNull
        private RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myConfigurationSettings;
            if (runnerAndConfigurationSettings == null) {
                ExistingConfiguration.$$$reportNull$$$0(1);
            }
            return runnerAndConfigurationSettings;
        }

        @Nullable
        private RunConfigurationProducer<?> getProducer() {
            return this.myProducer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ConfigurationContext$ExistingConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ConfigurationContext$ExistingConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

