/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.util.containers.IntObjectMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestIconMapper
implements PoolOfTestIcons {
    private static final IntObjectMap<TestStateInfo.Magnitude> magnitudes = ConcurrentCollectionFactory.createConcurrentIntObjectMap();

    public static TestStateInfo.Magnitude getMagnitude(int value2) {
        return (TestStateInfo.Magnitude)((Object)magnitudes.get(value2));
    }

    @Nullable
    public static Icon getIcon(@NotNull TestStateInfo.Magnitude magnitude) {
        if (magnitude == null) {
            TestIconMapper.$$$reportNull$$$0(0);
        }
        switch (magnitude) {
            case SKIPPED_INDEX: {
                return SKIPPED_ICON;
            }
            case COMPLETE_INDEX: {
                return PASSED_ICON;
            }
            case NOT_RUN_INDEX: {
                return NOT_RAN;
            }
            case RUNNING_INDEX: {
                return null;
            }
            case TERMINATED_INDEX: {
                return TERMINATED_ICON;
            }
            case IGNORED_INDEX: {
                return IGNORED_ICON;
            }
            case FAILED_INDEX: {
                return FAILED_ICON;
            }
            case ERROR_INDEX: {
                return ERROR_ICON;
            }
            case PASSED_INDEX: {
                return PASSED_ICON;
            }
        }
        return null;
    }

    @Nullable
    public static Icon getToolbarIcon(@NotNull TestStateInfo.Magnitude magnitude) {
        if (magnitude == null) {
            TestIconMapper.$$$reportNull$$$0(1);
        }
        switch (magnitude) {
            case SKIPPED_INDEX: {
                return AllIcons.RunConfigurations.ToolbarSkipped;
            }
            case COMPLETE_INDEX: {
                return AllIcons.RunConfigurations.ToolbarPassed;
            }
            case NOT_RUN_INDEX: {
                return AllIcons.RunConfigurations.TestNotRan;
            }
            case TERMINATED_INDEX: {
                return AllIcons.RunConfigurations.ToolbarTerminated;
            }
            case IGNORED_INDEX: {
                return AllIcons.RunConfigurations.ShowIgnored;
            }
            case FAILED_INDEX: {
                return AllIcons.RunConfigurations.ToolbarFailed;
            }
            case ERROR_INDEX: {
                return AllIcons.RunConfigurations.ToolbarError;
            }
            case PASSED_INDEX: {
                return AllIcons.RunConfigurations.ToolbarPassed;
            }
        }
        return null;
    }

    static {
        for (TestStateInfo.Magnitude value2 : TestStateInfo.Magnitude.values()) {
            magnitudes.put(value2.getValue(), (Object)value2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "magnitude";
        objectArray2[1] = "com/intellij/execution/testframework/TestIconMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getToolbarIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

