/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BrowserUtil {
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w+.\\-]{2,}:");
    private static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(StringUtil.toLowerCase((String)url)).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        return anchorMatcher.find() ? anchorMatcher.reset().replaceAll("") : url;
    }

    @Nullable
    public static URL getURL(String url) throws MalformedURLException {
        return BrowserUtil.isAbsoluteURL(url) ? VfsUtilCore.convertToURL(url) : new URL("file", "", url);
    }

    public static void open(@NonNls @NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(0);
        }
        BrowserUtil.getBrowserLauncher().open(url);
    }

    public static void browse(@NotNull VirtualFile file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(1);
        }
        BrowserUtil.browse(file.getUrl(), null);
    }

    public static void browse(@NotNull File file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(2);
        }
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull Path file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(3);
        }
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull URL url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(4);
        }
        BrowserUtil.browse(url.toExternalForm(), null);
    }

    public static void browse(@NotNull URI uri) {
        if (uri == null) {
            BrowserUtil.$$$reportNull$$$0(5);
        }
        BrowserUtil.getBrowserLauncher().browse(uri);
    }

    public static void browse(@NonNls @NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(6);
        }
        BrowserUtil.browse(url, null);
    }

    public static void browse(@NotNull String url, @Nullable Project project) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(7);
        }
        BrowserUtil.getBrowserLauncher().browse(url, null, project);
    }

    public static boolean browseAbsolute(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(8);
        }
        if (BrowserUtil.isAbsoluteURL(url)) {
            BrowserUtil.browse(url);
            return true;
        }
        return false;
    }

    private static BrowserLauncher getBrowserLauncher() {
        return ApplicationManager.getApplication() != null ? BrowserLauncher.getInstance() : new BrowserLauncherAppless();
    }

    @NotNull
    public static List<String> getOpenBrowserCommand(@NotNull String browserPathOrName, boolean newWindowIfPossible) {
        if (browserPathOrName == null) {
            BrowserUtil.$$$reportNull$$$0(9);
        }
        if (new File(browserPathOrName).isFile()) {
            List<String> list = Collections.singletonList(browserPathOrName);
            if (list == null) {
                BrowserUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (SystemInfo.isMac) {
            ArrayList command = ContainerUtil.newArrayList((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", browserPathOrName});
            if (newWindowIfPossible) {
                command.add("-n");
            }
            ArrayList arrayList = command;
            if (arrayList == null) {
                BrowserUtil.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        if (SystemInfo.isWindows) {
            List<String> list = Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote((String)""), browserPathOrName);
            if (list == null) {
                BrowserUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<String> list = Collections.singletonList(browserPathOrName);
        if (list == null) {
            BrowserUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static String getDefaultAlternativeBrowserPath() {
        if (SystemInfo.isWindows) {
            return "C:\\Program Files\\Internet Explorer\\IExplore.exe";
        }
        if (SystemInfo.isMac) {
            return "open";
        }
        if (SystemInfo.isUnix) {
            return "/usr/bin/firefox";
        }
        return "";
    }

    @Deprecated
    public static void launchBrowser(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(14);
        }
        BrowserUtil.browse(url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserPathOrName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/BrowserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/BrowserUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenBrowserCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "browse";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "browseAbsolute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOpenBrowserCommand";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "launchBrowser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

