/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorCoreUtil {
    public static boolean isTrueSmoothScrollingEnabled() {
        return Boolean.getBoolean("idea.true.smooth.scrolling");
    }

    public static void indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, boolean shouldUseSmartTabs) {
        if (editor == null) {
            EditorCoreUtil.$$$reportNull$$$0(0);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int newCaretOffset = EditorCoreUtil.indentLine(project, editor, lineNumber, indent, caretOffset, shouldUseSmartTabs);
        editor.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset, boolean shouldUseSmartTabs) {
        int newCaretOffset;
        if (editor == null) {
            EditorCoreUtil.$$$reportNull$$$0(1);
        }
        EditorSettings editorSettings = editor.getSettings();
        int tabSize = editorSettings.getTabSize(project);
        Document document = editor.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        int spacesEnd = 0;
        int lineStart = 0;
        int lineEnd = 0;
        int tabsEnd = 0;
        if (lineNumber < document.getLineCount()) {
            lineStart = document.getLineStartOffset(lineNumber);
            lineEnd = document.getLineEndOffset(lineNumber);
            boolean inTabs = true;
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd; ++spacesEnd) {
                char c = text2.charAt(spacesEnd);
                if (c == '\t') continue;
                if (inTabs) {
                    inTabs = false;
                    tabsEnd = spacesEnd;
                }
                if (c != ' ') break;
            }
            if (inTabs) {
                tabsEnd = lineEnd;
            }
        }
        if ((newCaretOffset = caretOffset) >= lineStart && newCaretOffset < lineEnd && spacesEnd == lineEnd) {
            spacesEnd = newCaretOffset;
            tabsEnd = Math.min(spacesEnd, tabsEnd);
        }
        int oldLength = EditorCoreUtil.getSpaceWidthInColumns(text2, lineStart, spacesEnd, tabSize);
        tabsEnd = EditorCoreUtil.getSpaceWidthInColumns(text2, lineStart, tabsEnd, tabSize);
        int newLength = oldLength + indent;
        if (newLength < 0) {
            newLength = 0;
        }
        if ((tabsEnd += indent) < 0) {
            tabsEnd = 0;
        }
        if (!shouldUseSmartTabs) {
            tabsEnd = newLength;
        }
        StringBuilder buf = new StringBuilder(newLength);
        int i2 = 0;
        while (i2 < newLength) {
            if (tabSize > 0 && editorSettings.isUseTabCharacter(project) && i2 + tabSize <= tabsEnd) {
                buf.append('\t');
                i2 += tabSize;
                continue;
            }
            buf.append(' ');
            ++i2;
        }
        int newSpacesEnd = lineStart + buf.length();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - (spacesEnd - lineStart);
        } else if (newCaretOffset >= lineStart && newCaretOffset > newSpacesEnd) {
            newCaretOffset = newSpacesEnd;
        }
        if (buf.length() > 0) {
            if (spacesEnd > lineStart) {
                document.replaceString(lineStart, spacesEnd, buf.toString());
            } else {
                document.insertString(lineStart, buf.toString());
            }
        } else if (spacesEnd > lineStart) {
            document.deleteString(lineStart, spacesEnd);
        }
        return newCaretOffset;
    }

    public static EditorHighlighter createEmptyHighlighter(final @Nullable Project project, final @NotNull Document document) {
        if (document == null) {
            EditorCoreUtil.$$$reportNull$$$0(2);
        }
        EmptyEditorHighlighter highlighter = new EmptyEditorHighlighter(new TextAttributes()){

            @Override
            @NotNull
            public HighlighterIterator createIterator(int startOffset) {
                this.setText(document.getImmutableCharSequence());
                HighlighterIterator highlighterIterator = super.createIterator(startOffset);
                if (highlighterIterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return highlighterIterator;
            }

            @Override
            public void setAttributes(TextAttributes attributes) {
            }

            @Override
            public void setColorScheme(@NotNull EditorColorsScheme scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/EditorCoreUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createIterator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/EditorCoreUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setColorScheme";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        highlighter.setEditor(new HighlighterClient(){

            @Override
            public Project getProject() {
                return project;
            }

            @Override
            public void repaint(int start, int end) {
            }

            @Override
            public Document getDocument() {
                return document;
            }
        });
        return highlighter;
    }

    private static int getSpaceWidthInColumns(CharSequence seq, int startOffset, int endOffset, int tabSize) {
        int result = 0;
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            if (seq.charAt(i2) == '\t') {
                result = (result / tabSize + 1) * tabSize;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, @NotNull LogicalPosition logicalPosition) {
        if (editor == null) {
            EditorCoreUtil.$$$reportNull$$$0(3);
        }
        if (logicalPosition == null) {
            EditorCoreUtil.$$$reportNull$$$0(4);
        }
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals(logicalPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/EditorCoreUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createEmptyHighlighter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inVirtualSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

