/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.Hash;
import java.util.NoSuchElementException;

final class StrippedIntOpenHashSet {
    private transient int[] key;
    private transient int mask;
    private transient boolean containsNull;
    private transient int n;
    private transient int maxFill;
    private final transient int minN;
    private int size;
    private final float f;

    private StrippedIntOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = Hash.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill(this.n, f);
        this.key = new int[this.n + 1];
    }

    StrippedIntOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    StrippedIntOpenHashSet() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public boolean add(int k) {
        if (k == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            int[] key = this.key;
            int pos = Hash.mix(k) & this.mask;
            int curr = key[pos];
            if (curr != 0) {
                if (curr == k) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (curr != k) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, this.f));
        }
        assert (this.contains(k));
        return true;
    }

    private void shiftKeys(int pos) {
        int[] key = this.key;
        while (true) {
            int curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0) {
                    key[last] = 0;
                    return;
                }
                int slot = Hash.mix(curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
        }
    }

    private boolean removeEntry(int pos) {
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int k) {
        try {
            if (k == 0) {
                if (this.containsNull) {
                    boolean bl = this.removeNullEntry();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            int[] key = this.key;
            int pos = Hash.mix(k) & this.mask;
            int curr = key[pos];
            if (curr == 0) {
                boolean bl = false;
                return bl;
            }
            if (k == curr) {
                boolean bl = this.removeEntry(pos);
                return bl;
            }
            do {
                if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
                boolean bl = false;
                return bl;
            } while (k != curr);
            boolean bl = this.removeEntry(pos);
            return bl;
        }
        finally {
            assert (!this.contains(k));
        }
    }

    public boolean contains(int k) {
        if (k == 0) {
            return this.containsNull;
        }
        int[] key = this.key;
        int pos = Hash.mix(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] toArray() {
        int[] result = new int[this.size];
        SetIterator iterator = this.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            result[i2++] = iterator.nextInt();
        }
        return result;
    }

    public SetIterator iterator() {
        return new SetIterator();
    }

    private void rehash(int newN) {
        int[] key = this.key;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int i2 = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i2] == 0) {
            }
            int pos = Hash.mix(key[i2]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.n, this.f);
        this.key = newKey;
        for (int k : key) {
            if (k != 0) assert (this.contains(k));
        }
    }

    public final class SetIterator {
        int pos;
        int c;
        boolean mustReturnNull;

        public SetIterator() {
            this.pos = StrippedIntOpenHashSet.this.n;
            this.c = StrippedIntOpenHashSet.this.size;
            this.mustReturnNull = StrippedIntOpenHashSet.this.containsNull;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextInt() {
            int v;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                return StrippedIntOpenHashSet.this.key[StrippedIntOpenHashSet.this.n];
            }
            int[] key = StrippedIntOpenHashSet.this.key;
            while ((v = key[--this.pos]) == 0) {
            }
            return v;
        }
    }
}

