/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsUtil
extends VfsUtilCore {
    private static final Logger LOG = Logger.getInstance(VfsUtil.class);
    public static final long NOTIFICATION_DELAY_MILLIS = 300L;

    public static void saveText(@NotNull VirtualFile file, @NotNull String text2) throws IOException {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            VfsUtil.$$$reportNull$$$0(1);
        }
        Charset charset = file.getCharset();
        try (OutputStream stream = file.getOutputStream(file);){
            stream.write(text2.getBytes(charset));
        }
    }

    public static byte @NotNull [] toByteArray(@NotNull VirtualFile file, @NotNull String text2) throws IOException {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            VfsUtil.$$$reportNull$$$0(3);
        }
        if (text2.isEmpty()) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                VfsUtil.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        Charset charset = file.getCharset();
        byte[] byArray = text2.getBytes(charset);
        if (byArray == null) {
            VfsUtil.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    public static void copyDirectory(Object requestor, @NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, @Nullable VirtualFileFilter filter) throws IOException {
        VirtualFile[] children2;
        if (fromDir == null) {
            VfsUtil.$$$reportNull$$$0(6);
        }
        if (toDir == null) {
            VfsUtil.$$$reportNull$$$0(7);
        }
        for (VirtualFile child : children2 = fromDir.getChildren()) {
            if (child.is(VFileProperty.SYMLINK) || child.is(VFileProperty.SPECIAL) || filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.findChild(child.getName());
            if (newChild == null) {
                newChild = toDir.createChildDirectory(requestor, child.getName());
            }
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    @NotNull
    public static VirtualFile copy(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(8);
        }
        if (toDir == null) {
            VfsUtil.$$$reportNull$$$0(9);
        }
        if (file.isDirectory()) {
            VirtualFile newDir = toDir.createChildDirectory(requestor, file.getName());
            VfsUtil.copyDirectory(requestor, file, newDir, null);
            VirtualFile virtualFile2 = newDir;
            if (virtualFile2 == null) {
                VfsUtil.$$$reportNull$$$0(10);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = VfsUtil.copyFile(requestor, file, toDir);
        if (virtualFile3 == null) {
            VfsUtil.$$$reportNull$$$0(11);
        }
        return virtualFile3;
    }

    public static VirtualFile @NotNull [] getCommonAncestors(VirtualFile @NotNull [] files) {
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(12);
        }
        HashMap map = new HashMap();
        for (VirtualFile aFile : files) {
            Set<VirtualFile> filesSet;
            VirtualFile directory;
            VirtualFile virtualFile2 = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    VfsUtil.$$$reportNull$$$0(13);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] path2 = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path2[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new HashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        for (Set filesSet : map.values()) {
            VirtualFile ancestor = null;
            for (VirtualFile file : filesSet) {
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(ancestorsList);
        if (virtualFileArray == null) {
            VfsUtil.$$$reportNull$$$0(14);
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(15);
        }
        VirtualFile ancestor = null;
        for (VirtualFile virtualFile2 : files) {
            if (ancestor == null) {
                ancestor = virtualFile2;
                continue;
            }
            if ((ancestor = VfsUtil.getCommonAncestor(ancestor, virtualFile2)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@Nullable VirtualFile base, String ... path2) {
        if (path2 == null) {
            VfsUtil.$$$reportNull$$$0(16);
        }
        VirtualFile file = base;
        for (String pathElement : path2) {
            if (file == null) {
                return null;
            }
            file = "..".equals(pathElement) ? file.getParent() : file.findChild(pathElement);
        }
        return file;
    }

    @Nullable
    public static VirtualFile findFileByURL(@NotNull URL url) {
        if (url == null) {
            VfsUtil.$$$reportNull$$$0(17);
        }
        String vfsUrl = VfsUtil.convertFromUrl(url);
        return VirtualFileManager.getInstance().findFileByUrl(vfsUrl);
    }

    @Nullable
    public static VirtualFile findFile(@NotNull Path file, boolean refreshIfNeeded) {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(18);
        }
        return VfsUtil.findFile(file.toAbsolutePath().toString().replace(File.separatorChar, '/'), refreshIfNeeded);
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull File file, boolean refreshIfNeeded) {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(19);
        }
        return VfsUtil.findFile(file.getAbsolutePath().replace(File.separatorChar, '/'), refreshIfNeeded);
    }

    @Nullable
    private static VirtualFile findFile(@NotNull String filePath2, boolean refreshIfNeeded) {
        if (filePath2 == null) {
            VfsUtil.$$$reportNull$$$0(20);
        }
        VirtualFileSystem fileSystem = StandardFileSystems.local();
        VirtualFile virtualFile2 = fileSystem.findFileByPath(filePath2);
        if (refreshIfNeeded && (virtualFile2 == null || !virtualFile2.isValid())) {
            virtualFile2 = fileSystem.refreshAndFindFileByPath(filePath2);
        }
        return virtualFile2;
    }

    @Nullable
    public static VirtualFile refreshAndFindChild(@NotNull VirtualFile directory, @NotNull String name) {
        if (directory == null) {
            VfsUtil.$$$reportNull$$$0(21);
        }
        if (name == null) {
            VfsUtil.$$$reportNull$$$0(22);
        }
        if (directory instanceof NewVirtualFile) {
            return ((NewVirtualFile)directory).refreshAndFindChild(name);
        }
        return VfsUtil.findFileByIoFile(new File(VfsUtil.virtualToIoFile(directory), name), true);
    }

    @NotNull
    public static URI toUri(@NotNull File file) {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(23);
        }
        Object path2 = file.toURI().getPath();
        try {
            if (SystemInfo.isWindows && ((String)path2).charAt(0) != '/') {
                path2 = "/" + (String)path2;
            }
            return new URI("file", "", (String)path2, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public static URI toUri(@NonNls @NotNull String uri) {
        int firstSlashIndex;
        int index;
        if (uri == null) {
            VfsUtil.$$$reportNull$$$0(24);
        }
        if ((index = ((String)uri).indexOf("://")) < 0) {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
        if (SystemInfo.isWindows && ((String)uri).startsWith("file://") && ((String)uri).charAt(firstSlashIndex = index + "://".length()) != '/') {
            uri = "file:///" + ((String)uri).substring(firstSlashIndex);
        }
        try {
            return new URI((String)uri);
        }
        catch (URISyntaxException e) {
            LOG.debug("uri is not fully encoded", (Throwable)e);
            try {
                int fragmentIndex = ((String)uri).lastIndexOf(35);
                String path2 = ((String)uri).substring(index + 1, fragmentIndex > 0 ? fragmentIndex : ((String)uri).length());
                String fragment = fragmentIndex > 0 ? ((String)uri).substring(fragmentIndex + 1) : null;
                return new URI(((String)uri).substring(0, index), path2, fragment);
            }
            catch (URISyntaxException e1) {
                LOG.debug((Throwable)e1);
                return null;
            }
        }
    }

    @NotNull
    public static String getUrlForLibraryRoot(@NotNull File libraryRoot) {
        if (libraryRoot == null) {
            VfsUtil.$$$reportNull$$$0(25);
        }
        return VfsUtil.getUrlForLibraryRoot(libraryRoot.getAbsolutePath(), libraryRoot.getName());
    }

    @NotNull
    public static String getUrlForLibraryRoot(@NotNull Path libraryRoot) {
        if (libraryRoot == null) {
            VfsUtil.$$$reportNull$$$0(26);
        }
        return VfsUtil.getUrlForLibraryRoot(libraryRoot.toAbsolutePath().toString(), libraryRoot.getFileName().toString());
    }

    @NotNull
    private static String getUrlForLibraryRoot(@NotNull String libraryRootAbsolutePath, @NotNull String libraryRootFileName) {
        if (libraryRootAbsolutePath == null) {
            VfsUtil.$$$reportNull$$$0(27);
        }
        if (libraryRootFileName == null) {
            VfsUtil.$$$reportNull$$$0(28);
        }
        String path2 = FileUtil.toSystemIndependentName((String)libraryRootAbsolutePath);
        String string = FileTypeRegistry.getInstance().getFileTypeByFileName(libraryRootFileName) == ArchiveFileType.INSTANCE ? VirtualFileManager.constructUrl("jar", path2 + "!/") : VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path2);
        if (string == null) {
            VfsUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String getNextAvailableName(@NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) {
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            VfsUtil.$$$reportNull$$$0(31);
        }
        if (extension == null) {
            VfsUtil.$$$reportNull$$$0(32);
        }
        String dotExt = PathUtil.makeFileName("", extension);
        String fileName = prefix + dotExt;
        int i2 = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + "_" + i2 + dotExt;
            ++i2;
        }
        String string = fileName;
        if (string == null) {
            VfsUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static VirtualFile createChildSequent(Object requestor, @NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) throws IOException {
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(34);
        }
        if (prefix == null) {
            VfsUtil.$$$reportNull$$$0(35);
        }
        if (extension == null) {
            VfsUtil.$$$reportNull$$$0(36);
        }
        VirtualFile virtualFile2 = dir.createChildData(requestor, VfsUtil.getNextAvailableName(dir, prefix, extension));
        if (virtualFile2 == null) {
            VfsUtil.$$$reportNull$$$0(37);
        }
        return virtualFile2;
    }

    public static String @NotNull [] filterNames(String @NotNull [] names) {
        if (names == null) {
            VfsUtil.$$$reportNull$$$0(38);
        }
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            if (names == null) {
                VfsUtil.$$$reportNull$$$0(39);
            }
            return names;
        }
        String[] result = ArrayUtil.newStringArray((int)(names.length - filteredCount));
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result[count++] = string;
        }
        if (result == null) {
            VfsUtil.$$$reportNull$$$0(40);
        }
        return result;
    }

    public static boolean isBadName(String name) {
        return name == null || name.isEmpty() || "/".equals(name) || "\\".equals(name);
    }

    public static VirtualFile createDirectories(@NotNull String directoryPath) throws IOException {
        if (directoryPath == null) {
            VfsUtil.$$$reportNull$$$0(41);
        }
        return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.createDirectoryIfMissing(directoryPath));
    }

    public static VirtualFile createDirectoryIfMissing(@Nullable VirtualFile parent, @NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            VfsUtil.$$$reportNull$$$0(42);
        }
        if (parent == null) {
            return VfsUtil.createDirectoryIfMissing(LocalFileSystem.getInstance(), relativePath);
        }
        for (String each : StringUtil.split((String)relativePath, (String)"/")) {
            VirtualFile child = parent.findChild(each);
            if (child == null) {
                child = parent.createChildDirectory(parent.getFileSystem(), each);
            }
            parent = child;
        }
        return parent;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull String directoryPath) throws IOException {
        if (directoryPath == null) {
            VfsUtil.$$$reportNull$$$0(43);
        }
        return VfsUtil.createDirectoryIfMissing(LocalFileSystem.getInstance(), directoryPath);
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull VirtualFileSystem fileSystem, @NotNull String directoryPath) throws IOException {
        String path2;
        VirtualFile file;
        if (fileSystem == null) {
            VfsUtil.$$$reportNull$$$0(44);
        }
        if (directoryPath == null) {
            VfsUtil.$$$reportNull$$$0(45);
        }
        if ((file = fileSystem.refreshAndFindFileByPath(path2 = FileUtil.toSystemIndependentName((String)directoryPath))) != null) {
            return file;
        }
        int pos = path2.lastIndexOf(47);
        if (pos < 0) {
            return null;
        }
        VirtualFile parent = VfsUtil.createDirectoryIfMissing(fileSystem, path2.substring(0, pos));
        if (parent == null) {
            return null;
        }
        String dirName = path2.substring(pos + 1);
        VirtualFile child = parent.findChild(dirName);
        if (child != null && child.isDirectory()) {
            return child;
        }
        return parent.createChildDirectory(fileSystem, dirName);
    }

    @NotNull
    public static List<VirtualFile> collectChildrenRecursively(@NotNull VirtualFile root) {
        if (root == null) {
            VfsUtil.$$$reportNull$$$0(46);
        }
        final ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VfsUtil.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.add(file);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VfsUtil$1", "visitFile"));
            }
        });
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            VfsUtil.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    public static void processFileRecursivelyWithoutIgnored(final @NotNull VirtualFile root, final @NotNull Processor<? super VirtualFile> processor) {
        if (root == null) {
            VfsUtil.$$$reportNull$$$0(48);
        }
        if (processor == null) {
            VfsUtil.$$$reportNull$$$0(49);
        }
        final FileTypeRegistry ftm = FileTypeRegistry.getInstance();
        VfsUtil.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!processor.process((Object)file)) {
                    VirtualFileVisitor.Result result = 2.skipTo(root);
                    if (result == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = file.isDirectory() && ftm.isFileIgnored(file) ? SKIP_CHILDREN : CONTINUE;
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtil$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    @NlsSafe
    public static String getReadableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(50);
        }
        String url = null;
        if (file.isInLocalFileSystem()) {
            url = file.getPresentableUrl();
        }
        if (url == null) {
            url = file.getUrl();
        }
        String string = url;
        if (string == null) {
            VfsUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getUserHomeDir() {
        String path2 = SystemProperties.getUserHome();
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
    }

    public static VirtualFile @NotNull [] getChildren(@NotNull VirtualFile dir) {
        VirtualFile[] children2;
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(52);
        }
        VirtualFile[] virtualFileArray = (children2 = dir.getChildren()) == null ? VirtualFile.EMPTY_ARRAY : children2;
        if (virtualFileArray == null) {
            VfsUtil.$$$reportNull$$$0(53);
        }
        return virtualFileArray;
    }

    @NotNull
    public static List<VirtualFile> getChildren(@NotNull VirtualFile dir, @NotNull VirtualFileFilter filter) {
        if (dir == null) {
            VfsUtil.$$$reportNull$$$0(54);
        }
        if (filter == null) {
            VfsUtil.$$$reportNull$$$0(55);
        }
        List result = null;
        for (VirtualFile child : dir.getChildren()) {
            if (!filter.accept(child)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(child);
        }
        List list = result != null ? result : ContainerUtil.emptyList();
        if (list == null) {
            VfsUtil.$$$reportNull$$$0(56);
        }
        return list;
    }

    @Nullable
    public static String getParentDir(@Nullable String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf(47);
        return index < 0 ? null : url.substring(0, index);
    }

    @Nullable
    @NlsSafe
    public static String extractFileName(@Nullable String urlOrPath) {
        if (urlOrPath == null) {
            return null;
        }
        int index = urlOrPath.lastIndexOf(47);
        return index < 0 ? null : urlOrPath.substring(index + 1);
    }

    @NotNull
    public static List<VirtualFile> markDirty(boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List list;
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(57);
        }
        if ((list = ContainerUtil.filter((Object[])files, (Condition)Conditions.notNull())).isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VfsUtil.$$$reportNull$$$0(58);
            }
            return list2;
        }
        for (VirtualFile file : list) {
            if (reloadChildren && file.isValid()) {
                file.getChildren();
            }
            if (!(file instanceof NewVirtualFile)) continue;
            if (recursive) {
                ((NewVirtualFile)file).markDirtyRecursively();
                continue;
            }
            ((NewVirtualFile)file).markDirty();
        }
        List list3 = list;
        if (list3 == null) {
            VfsUtil.$$$reportNull$$$0(59);
        }
        return list3;
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List<VirtualFile> list;
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(60);
        }
        if ((list = VfsUtil.markDirty(recursive, reloadChildren, files)).isEmpty()) {
            return;
        }
        LocalFileSystem.getInstance().refreshFiles(list, async, recursive, null);
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, File ... files) {
        if (files == null) {
            VfsUtil.$$$reportNull$$$0(61);
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile[] virtualFiles = (VirtualFile[])ContainerUtil.map((Object[])files, fileSystem::refreshAndFindFileByIoFile, (Object[])new VirtualFile[files.length]);
        VfsUtil.markDirtyAndRefresh(async, recursive, reloadChildren, virtualFiles);
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file) {
        VirtualFile localFile;
        VirtualFileSystem fileSystem;
        if (file == null) {
            VfsUtil.$$$reportNull$$$0(62);
        }
        if (file.isValid() && (fileSystem = file.getFileSystem()) instanceof ArchiveFileSystem && (localFile = ((ArchiveFileSystem)fileSystem).getLocalByEntry(file)) != null) {
            VirtualFile virtualFile2 = localFile;
            if (virtualFile2 == null) {
                VfsUtil.$$$reportNull$$$0(63);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = file;
        if (virtualFile3 == null) {
            VfsUtil.$$$reportNull$$$0(64);
        }
        return virtualFile3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 47: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 63: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 47: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 63: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 47: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VfsUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 12: 
            case 15: 
            case 57: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRoot";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRootAbsolutePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRootFileName";
                break;
            }
            case 30: 
            case 34: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VfsUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toByteArray";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAncestors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlForLibraryRoot";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailableName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildSequent";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildrenRecursively";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableUrl";
                break;
            }
            case 53: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "markDirty";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toByteArray";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 47: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 63: 
            case 64: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFileByURL";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toUri";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getUrlForLibraryRoot";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNextAvailableName";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createChildSequent";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryIfMissing";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenRecursively";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processFileRecursivelyWithoutIgnored";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getReadableUrl";
                break;
            }
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "markDirty";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefresh";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 47: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 63: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

