/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

final class MacScrollBarUI
extends DefaultScrollBarUI {
    private static final List<Reference<MacScrollBarUI>> UI = new ArrayList<Reference<MacScrollBarUI>>();
    private final Alarm myAlarm = new Alarm();
    private boolean myTrackHovered;
    private static final AtomicReference<AWTEventListener> MOVEMENT_LISTENER = new AtomicReference<1>(new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            JScrollPane pane;
            Object source;
            if (event != null && 503 == event.getID() && (source = event.getSource()) instanceof Component && (pane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)((Component)source))) != null) {
                this.pauseThumbAnimation(pane.getHorizontalScrollBar());
                this.pauseThumbAnimation(pane.getVerticalScrollBar());
            }
        }

        private void pauseThumbAnimation(JScrollBar bar) {
            ScrollBarUI object;
            ScrollBarUI scrollBarUI = object = bar == null ? null : bar.getUI();
            if (object instanceof MacScrollBarUI) {
                MacScrollBarUI ui = (MacScrollBarUI)object;
                if (0.0f < ui.myThumb.animator.myValue) {
                    ui.onThumbMove();
                }
            }
        }
    });

    MacScrollBarUI() {
        super(14, 14, 11);
    }

    @Override
    boolean isAbsolutePositioning(MouseEvent event) {
        return Behavior.JumpToSpot == Behavior.CURRENT.get();
    }

    @Override
    boolean isTrackClickable() {
        return MacScrollBarUI.isOpaque(this.myScrollBar) || this.myTrack.animator.myValue > 0.0f && this.myThumb.animator.myValue > 0.0f;
    }

    @Override
    boolean isTrackExpandable() {
        return !MacScrollBarUI.isOpaque(this.myScrollBar);
    }

    @Override
    void onTrackHover(boolean hover) {
        this.myTrackHovered = hover;
        if (this.myScrollBar != null && MacScrollBarUI.isOpaque(this.myScrollBar)) {
            this.myTrack.animator.start(hover);
            this.myThumb.animator.start(hover);
        } else if (hover) {
            this.myTrack.animator.start(true);
        } else {
            this.myThumb.animator.start(false);
        }
    }

    @Override
    void onThumbHover(boolean hover) {
    }

    @Override
    void paintTrack(Graphics2D g, JComponent c) {
        if (this.myTrack.animator.myValue > 0.0f && this.myThumb.animator.myValue > 0.0f || MacScrollBarUI.isOpaque(c)) {
            super.paintTrack(g, c);
        }
    }

    @Override
    void paintThumb(Graphics2D g, JComponent c) {
        if (MacScrollBarUI.isOpaque(c)) {
            this.paint(this.myThumb, g, c, true);
        } else if (this.myThumb.animator.myValue > 0.0f) {
            this.paint(this.myThumb, g, c, false);
        }
    }

    @Override
    void onThumbMove() {
        if (this.myScrollBar != null && this.myScrollBar.isShowing() && !MacScrollBarUI.isOpaque(this.myScrollBar)) {
            if (!this.myTrackHovered && this.myThumb.animator.myValue == 0.0f) {
                this.myTrack.animator.rewind(false);
            }
            this.myThumb.animator.rewind(true);
            this.myAlarm.cancelAllRequests();
            if (!this.myTrackHovered) {
                this.myAlarm.addRequest(() -> this.myThumb.animator.start(false), 700);
            }
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateStyle(Style.CURRENT.get());
        MacScrollBarUI.processReferences(this, null, null);
        AWTEventListener listener = MOVEMENT_LISTENER.getAndSet(null);
        if (listener != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(listener, 32L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        MacScrollBarUI.processReferences(null, this, null);
        this.myAlarm.cancelAllRequests();
        super.uninstallUI(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processReferences(MacScrollBarUI toAdd, MacScrollBarUI toRemove, List<? super MacScrollBarUI> list) {
        List<Reference<MacScrollBarUI>> list2 = UI;
        synchronized (list2) {
            Iterator<Reference<MacScrollBarUI>> iterator = UI.iterator();
            while (iterator.hasNext()) {
                Reference<MacScrollBarUI> reference = iterator.next();
                MacScrollBarUI ui = reference.get();
                if (ui == null || ui == toRemove) {
                    iterator.remove();
                    continue;
                }
                if (list == null) continue;
                list.add(ui);
            }
            if (toAdd != null) {
                UI.add(new WeakReference<MacScrollBarUI>(toAdd));
            }
        }
    }

    private void updateStyle(Style style) {
        if (this.myScrollBar != null) {
            this.myScrollBar.setOpaque(style != Style.Overlay);
            this.myScrollBar.revalidate();
            this.myScrollBar.repaint();
            this.onThumbMove();
        }
    }

    private static ID createDelegate(String name, Pointer pointer, Callback callback) {
        ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)name);
        if (!ID.NIL.equals((Object)delegateClass)) {
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)pointer, (Callback)callback, (String)"v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            Foundation.registerObjcClassPair((ID)delegateClass);
        }
        return Foundation.invoke((String)name, (String)"new", (Object[])new Object[0]);
    }

    private static <T> T callMac(NotNullProducer<? extends T> producer) {
        if (SystemInfo.isMac) {
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                Object object = producer.produce();
                return (T)object;
            }
            catch (Throwable throwable) {
                Logger.getInstance(MacScrollBarUI.class).warn(throwable);
            }
            finally {
                pool.drain();
            }
        }
        return null;
    }

    private static abstract class Native<T>
    implements Callback,
    Runnable,
    NotNullProducer<T> {
        private T myValue;

        Native() {
            Logger.getInstance(MacScrollBarUI.class).debug("initialize ", new Object[]{this});
            MacScrollBarUI.callMac(() -> this.initialize());
            UIUtil.invokeLaterIfNeeded((Runnable)this);
        }

        abstract ID initialize();

        T get() {
            return this.myValue;
        }

        public void callback(ID self, Pointer selector, ID event) {
            Logger.getInstance(MacScrollBarUI.class).debug("update ", new Object[]{this});
            UIUtil.invokeLaterIfNeeded((Runnable)this);
        }

        @Override
        public void run() {
            this.myValue = MacScrollBarUI.callMac(this);
        }
    }

    private static enum Style {
        Legacy,
        Overlay;

        private static final Native<Style> CURRENT;

        static {
            CURRENT = new Native<Style>(){

                @Override
                public void run() {
                    Style newStyle;
                    Style oldStyle = (Style)((Object)this.get());
                    if (SystemInfoRt.isMac && !Registry.is((String)"ide.mac.disableMacScrollbars", (boolean)false)) {
                        super.run();
                    }
                    if ((newStyle = (Style)((Object)this.get())) != oldStyle) {
                        ArrayList list = new ArrayList();
                        MacScrollBarUI.processReferences(null, null, list);
                        for (MacScrollBarUI ui : list) {
                            ui.updateStyle(newStyle);
                        }
                    }
                }

                @NotNull
                public Style produce() {
                    ID style = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSScroller"), (String)"preferredScrollerStyle", (Object[])new Object[0]);
                    Style value2 = 1 == style.intValue() ? Overlay : Legacy;
                    Logger.getInstance(MacScrollBarUI.class).debug("scroll bar style ", new Object[]{value2, " from ", style});
                    Style style2 = value2;
                    if (style2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return style2;
                }

                public String toString() {
                    return "scroll bar style";
                }

                @Override
                ID initialize() {
                    return Foundation.invoke((ID)Foundation.invoke((String)"NSNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]), (String)"addObserver:selector:name:object:", (Object[])new Object[]{MacScrollBarUI.createDelegate("JBScrollBarStyleObserver", Foundation.createSelector((String)"handleScrollerStyleChanged:"), this), Foundation.createSelector((String)"handleScrollerStyleChanged:"), Foundation.nsString((String)"NSPreferredScrollerStyleDidChangeNotification"), ID.NIL});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/MacScrollBarUI$Style$1", "produce"));
                }
            };
        }
    }

    private static enum Behavior {
        NextPage,
        JumpToSpot;

        private static final Native<Behavior> CURRENT;

        static {
            CURRENT = new Native<Behavior>(){

                @NotNull
                public Behavior produce() {
                    ID defaults = Foundation.invoke((String)"NSUserDefaults", (String)"standardUserDefaults", (Object[])new Object[0]);
                    Foundation.invoke((ID)defaults, (String)"synchronize", (Object[])new Object[0]);
                    ID behavior = Foundation.invoke((ID)defaults, (String)"boolForKey:", (Object[])new Object[]{Foundation.nsString((String)"AppleScrollerPagingBehavior")});
                    Behavior value2 = 1 == behavior.intValue() ? JumpToSpot : NextPage;
                    Logger.getInstance(MacScrollBarUI.class).debug("scroll bar behavior ", new Object[]{value2, " from ", behavior});
                    Behavior behavior2 = value2;
                    if (behavior2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return behavior2;
                }

                public String toString() {
                    return "scroll bar behavior";
                }

                @Override
                ID initialize() {
                    return Foundation.invoke((ID)Foundation.invoke((String)"NSDistributedNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]), (String)"addObserver:selector:name:object:", (Object[])new Object[]{MacScrollBarUI.createDelegate("JBScrollBarBehaviorObserver", Foundation.createSelector((String)"handleBehaviorChanged:"), this), Foundation.createSelector((String)"handleBehaviorChanged:"), Foundation.nsString((String)"AppleNoRedisplayAppearancePreferenceChanged"), ID.NIL, 2});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/MacScrollBarUI$Behavior$1", "produce"));
                }
            };
        }
    }
}

