/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Touchbar {
    private static final Key<ActionGroup> ACTION_GROUP_KEY = Key.create((String)"Touchbar.ActionGroup.key");
    private static final boolean EXPAND_OPTION_BUTTONS = Boolean.getBoolean("Touchbar.expand.option.button");

    @Nullable
    public static ActionGroup getActions(@NotNull JComponent component) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(0);
        }
        return (ActionGroup)ComponentUtil.getClientProperty((JComponent)component, ACTION_GROUP_KEY);
    }

    public static void setActions(@NotNull JComponent component, @Nullable ActionGroup group) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(1);
        }
        ComponentUtil.putClientProperty((JComponent)component, ACTION_GROUP_KEY, (Object)group);
    }

    public static void setActions(@NotNull JComponent component, @Nullable AnAction action) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(2);
        }
        Touchbar.setActions(component, action == null ? null : new DefaultActionGroup(action));
    }

    public static void setActions(@NotNull JComponent component, @NotNull String actionId) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(3);
        }
        if (actionId == null) {
            Touchbar.$$$reportNull$$$0(4);
        }
        Touchbar.setActions(component, ActionManager.getInstance().getAction(actionId));
    }

    public static void setButtonActions(@NotNull JComponent component, JButton button) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(5);
        }
        Touchbar.setButtonActions(component, Collections.singletonList(button));
    }

    public static void setButtonActions(@NotNull JComponent component, JButton[] buttons) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(6);
        }
        Touchbar.setButtonActions(component, Arrays.asList(buttons));
    }

    public static void setButtonActions(@NotNull JComponent component, Collection<JButton> buttons) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(7);
        }
        Touchbar.setButtonActions(component, buttons, null, null);
    }

    public static void setButtonActions(@NotNull JComponent component, Collection<JButton> buttons, Collection<JButton> principal, JButton defaultButton) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(8);
        }
        Touchbar.setButtonActions(component, buttons, principal, defaultButton, null);
    }

    public static void setButtonActions(@NotNull JComponent component, Collection<JButton> buttons, Collection<JButton> principal, JButton defaultButton, @Nullable ActionGroup extraActions) {
        if (component == null) {
            Touchbar.$$$reportNull$$$0(9);
        }
        DefaultActionGroup result = new DefaultActionGroup();
        if (buttons != null) {
            result.add(Touchbar.buildActionsFromButtons(buttons, defaultButton, false));
        }
        if (extraActions != null) {
            result.add(extraActions);
        }
        if (principal != null) {
            result.add(Touchbar.buildActionsFromButtons(principal, defaultButton, true));
        }
        Touchbar.setActions(component, result);
    }

    @NotNull
    private static DefaultActionGroup buildActionsFromButtons(Collection<JButton> buttons, JButton defaultButton, boolean isPrincipal) {
        DefaultActionGroup result = new DefaultActionGroup();
        if (EXPAND_OPTION_BUTTONS) {
            DefaultActionGroup options = null;
            for (JButton jb : buttons) {
                JBOptionButton ob;
                Action[] opts;
                if (!(jb instanceof JBOptionButton) || (opts = (ob = (JBOptionButton)jb).getOptions()) == null) continue;
                for (Action a : opts) {
                    AnAction anAct;
                    if (a == null || (anAct = Touchbar._createActionFromButton(a, ob, true)) == null) continue;
                    if (options == null) {
                        options = new DefaultActionGroup();
                    }
                    options.add(anAct);
                }
            }
            if (options != null) {
                result.add(options);
            }
        }
        for (JButton jb : buttons) {
            AnAction anAct = Touchbar._createActionFromButton(jb.getAction(), jb, false);
            if (anAct == null) continue;
            if (jb == defaultButton) {
                TouchbarActionCustomizations.setDefault(anAct, true);
            }
            result.add(anAct);
        }
        if (isPrincipal) {
            TouchbarActionCustomizations.setPrincipal(result, true);
        }
        DefaultActionGroup defaultActionGroup = result;
        if (defaultActionGroup == null) {
            Touchbar.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    private static AnAction _createActionFromButton(final @Nullable Action action, final @NotNull JButton button, final boolean useTextFromAction) {
        Object anAct;
        if (button == null) {
            Touchbar.$$$reportNull$$$0(11);
        }
        Object object = anAct = action == null ? null : action.getValue("AnAction");
        if (anAct == null) {
            anAct = new DumbAwareAction(){
                {
                    this.setEnabledInModalContext(true);
                    if (useTextFromAction) {
                        Object name = action == null ? button.getText() : action.getValue("Name");
                        this.getTemplatePresentation().setText(name instanceof String ? (String)name : "");
                    }
                }

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (action == null) {
                        button.doClick();
                        return;
                    }
                    action.actionPerformed(new ActionEvent(button, 1001, null));
                }

                @Override
                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(action == null ? button.isEnabled() : action.isEnabled());
                    if (!useTextFromAction) {
                        e.getPresentation().setText((String)DialogWrapper.extractMnemonic((String)button.getText()).second);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ui/mac/touchbar/Touchbar$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (!(anAct instanceof AnAction)) {
            return null;
        }
        TouchbarActionCustomizations.setComponent((AnAction)anAct, button).setShowText(true).setShowImage(false);
        return (AnAction)anAct;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/Touchbar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/Touchbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildActionsFromButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setActions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setButtonActions";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "_createActionFromButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

