/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messager;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.messager.CalloutComponent;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public final class Callout {
    public static final int NORTH_WEST = 1;
    public static final int NORTH_EAST = 2;
    public static final int SOUTH_WEST = 3;
    public static final int SOUTH_EAST = 4;

    public static void showText(JTree tree, TreePath path2, int direction, @NlsContexts.Label String text2) {
        Callout.showText(TreeUtil.getPointForPath(tree, path2), direction, text2);
    }

    public static void showTextBelow(JComponent component, @NlsContexts.Label String text2) {
        RelativePoint calloutPoint = RelativePoint.getSouthWestOf((JComponent)component);
        calloutPoint.getPoint().x += 5;
        Callout.showText(calloutPoint, 4, text2);
    }

    public static void showText(RelativePoint aPoint, int direction, @NlsContexts.Label String text2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JLabel label = new JLabel(text2);
        label.setHorizontalAlignment(0);
        CalloutComponent callout = new CalloutComponent(label);
        callout.show(direction, aPoint);
    }

    public static void showText(JComponent component, int direction, @NlsContexts.Label String text2) {
        RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight() / 2));
        Callout.showText(point, direction, text2);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Portlet Test");
        frame.setDefaultCloseOperation(3);
        frame.setLocation(300, 300);
        frame.setSize(200, 200);
        JPanel pane = new JPanel(new FlowLayout());
        final JButton first = new JButton("North east");
        first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Callout.showText(first, 2, "North east");
            }
        });
        pane.add(first);
        final JButton second = new JButton("North west");
        second.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Callout.showText(second, 1, "North west");
            }
        });
        pane.add(second);
        final JButton third = new JButton("South east");
        third.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Callout.showText(third, 4, "South east");
            }
        });
        pane.add(third);
        final JButton fourth = new JButton("South west");
        fourth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Callout.showText(fourth, 3, "South west");
            }
        });
        pane.add(fourth);
        frame.getContentPane().setLayout(new GridBagLayout());
        frame.getContentPane().add(pane);
        frame.setVisible(true);
    }
}

