/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.navigation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.HistoryListener;
import com.intellij.ui.navigation.Place;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class History {
    public static final DataKey<History> KEY = DataKey.create((String)"History");
    private final List<Place> myHistory;
    private int myCurrentPos;
    private final Place.Navigator myRoot;
    private boolean myNavigatedNow;
    private final CopyOnWriteArraySet<HistoryListener> myListeners;

    public History(@NotNull Place.Navigator root) {
        if (root == null) {
            History.$$$reportNull$$$0(0);
        }
        this.myHistory = new ArrayList<Place>();
        this.myListeners = new CopyOnWriteArraySet();
        this.myRoot = root;
    }

    public void pushQueryPlace() {
        if (this.isNavigatingNow()) {
            return;
        }
        Place place = this.query();
        if (place != null) {
            this.pushPlace(this.query());
        }
    }

    public void pushPlace(@NotNull Place place) {
        if (place == null) {
            History.$$$reportNull$$$0(1);
        }
        while (this.myCurrentPos >= 0 && this.myCurrentPos < this.myHistory.size() - 1) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
        if (this.myHistory.size() > 0) {
            Place prev = this.myHistory.get(this.myHistory.size() - 1);
            if (prev.equals(place)) {
                return;
            }
            if (prev.isMoreGeneralFor(place)) {
                this.myHistory.remove(prev);
            }
        }
        this.addPlace(place);
    }

    private void addPlace(Place place) {
        this.myHistory.add(place);
        this.myCurrentPos = this.myHistory.size() - 1;
    }

    public void pushPlaceForElement(String name, Object value2) {
        if (!this.canNavigateFor(name)) {
            return;
        }
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return;
        }
        this.pushPlace(checkPlace.cloneForElement(name, value2));
    }

    public Place getPlaceForElement(String name, String value2) {
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return new Place();
        }
        return checkPlace.cloneForElement(name, value2);
    }

    public void navigateTo(Place place) {
        this.myRoot.navigateTo(place, false);
    }

    public void back() {
        assert (this.canGoBack());
        this.goThere(this.myCurrentPos - 1);
    }

    private void goThere(int nextPos) {
        this.myNavigatedNow = true;
        Place next = this.myHistory.get(nextPos);
        Place from = this.getCurrent();
        this.fireStarted(from, next);
        try {
            ActionCallback callback = this.myRoot.navigateTo(next, false);
            callback.doWhenDone(() -> {
                this.myCurrentPos = nextPos;
            }).doWhenProcessed(() -> {
                this.myNavigatedNow = false;
                this.fireFinished(from, next);
            });
        }
        catch (Throwable e) {
            this.myNavigatedNow = false;
            throw new RuntimeException(e);
        }
    }

    public boolean isNavigatingNow() {
        return this.myNavigatedNow;
    }

    public boolean canGoBack() {
        return this.myHistory.size() > 1 && this.myCurrentPos > 0;
    }

    public void forward() {
        assert (this.canGoForward());
        this.goThere(this.myCurrentPos + 1);
    }

    public boolean canGoForward() {
        return this.myHistory.size() > 1 && this.myCurrentPos < this.myHistory.size() - 1;
    }

    public void clear() {
        this.myHistory.clear();
        this.myCurrentPos = -1;
    }

    @NotNull
    public Place query() {
        Place result = new Place();
        this.myRoot.queryPlace(result);
        Place place = result;
        if (place == null) {
            History.$$$reportNull$$$0(2);
        }
        return place;
    }

    private Place getCurrent() {
        if (this.myCurrentPos >= 0 && this.myCurrentPos < this.myHistory.size()) {
            return this.myHistory.get(this.myCurrentPos);
        }
        return null;
    }

    private boolean canNavigateFor(String pathElement) {
        if (this.isNavigatingNow()) {
            return false;
        }
        Place checkPlace = this.getCheckPlace(pathElement);
        return checkPlace != null && checkPlace.getPath(pathElement) != null;
    }

    @Nullable
    private Place getCheckPlace(String pathElement) {
        Place checkPlace = this.getCurrent();
        if (checkPlace == null || checkPlace.getPath(pathElement) == null) {
            checkPlace = this.query();
        }
        return checkPlace.getPath(pathElement) != null ? checkPlace : null;
    }

    public void addListener(final HistoryListener listener, Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                History.this.myListeners.remove(listener);
            }
        });
    }

    private void fireStarted(Place from, Place to) {
        for (HistoryListener each : this.myListeners) {
            each.navigationStarted(from, to);
        }
    }

    private void fireFinished(Place from, Place to) {
        for (HistoryListener each : this.myListeners) {
            each.navigationFinished(from, to);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/navigation/History";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/navigation/History";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pushPlace";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

