/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.reference.SoftReference;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.util.Axis;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragHelper
extends MouseDragHelper<JBTabsImpl> {
    private final JBTabsImpl myTabs;
    private TabInfo myDragSource;
    private Rectangle myDragOriginalRec;
    Rectangle myDragRec;
    private Dimension myHoldDelta;
    private TabInfo myDragOutSource;
    private Reference<TabLabel> myPressedTabLabel;

    protected DragHelper(@NotNull JBTabsImpl tabs, @NotNull Disposable parentDisposable) {
        if (tabs == null) {
            DragHelper.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DragHelper.$$$reportNull$$$0(1);
        }
        super(parentDisposable, tabs);
        this.myTabs = tabs;
    }

    @Override
    protected boolean isDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        if (event == null) {
            DragHelper.$$$reportNull$$$0(2);
        }
        if (dragToScreenPoint == null) {
            DragHelper.$$$reportNull$$$0(3);
        }
        if (startScreenPoint == null) {
            DragHelper.$$$reportNull$$$0(4);
        }
        if (this.myDragSource == null || !this.myDragSource.canBeDraggedOut()) {
            return false;
        }
        TabLabel label = this.myTabs.myInfo2Label.get(this.myDragSource);
        if (label == null) {
            return false;
        }
        int dX = dragToScreenPoint.x - startScreenPoint.x;
        int dY = dragToScreenPoint.y - startScreenPoint.y;
        return this.myTabs.isDragOut(label, dX, dY);
    }

    @Override
    protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean justStarted) {
        if (event == null) {
            DragHelper.$$$reportNull$$$0(5);
        }
        if (dragToScreenPoint == null) {
            DragHelper.$$$reportNull$$$0(6);
        }
        if (startScreenPoint == null) {
            DragHelper.$$$reportNull$$$0(7);
        }
        TabInfo.DragOutDelegate delegate = this.myDragOutSource.getDragOutDelegate();
        if (justStarted) {
            delegate.dragOutStarted(event, this.myDragOutSource);
        }
        delegate.processDragOut(event, this.myDragOutSource);
        event.consume();
    }

    @Override
    protected void processDragOutFinish(@NotNull MouseEvent event) {
        if (event == null) {
            DragHelper.$$$reportNull$$$0(8);
        }
        super.processDragOutFinish(event);
        boolean wasSorted = DragHelper.prepareDisableSorting();
        try {
            this.myDragOutSource.getDragOutDelegate().dragOutFinished(event, this.myDragOutSource);
        }
        finally {
            DragHelper.disableSortingIfNeed(event, wasSorted);
        }
    }

    private static boolean prepareDisableSorting() {
        boolean wasSorted = UISettings.getInstance().getSortTabsAlphabetically();
        if (wasSorted) {
            UISettings.getInstance().setSortTabsAlphabetically(false);
        }
        return wasSorted;
    }

    private static void disableSortingIfNeed(@NotNull MouseEvent event, boolean wasSorted) {
        if (event == null) {
            DragHelper.$$$reportNull$$$0(9);
        }
        if (!wasSorted) {
            return;
        }
        if (event.isConsumed()) {
            UISettings.getInstance().setSortTabsAlphabetically(true);
        } else {
            UISettings.getInstance().fireUISettingsChanged();
            ApplicationManager.getApplication().invokeLater(() -> {
                Notification notification = new Notification("System Messages", IdeBundle.message("alphabetical.mode.is.on.notification", new Object[0]), "", NotificationType.INFORMATION);
                notification.addAction(DumbAwareAction.create(ApplicationBundle.message("checkbox.sort.tabs.alphabetically", new Object[0]), (Consumer<? super AnActionEvent>)((Consumer)e -> {
                    UISettings.getInstance().setSortTabsAlphabetically(true);
                    UISettings.getInstance().fireUISettingsChanged();
                    notification.expire();
                })));
                Notifications.Bus.notify(notification);
            });
        }
    }

    @Override
    protected void processDragOutCancel() {
        this.myDragOutSource.getDragOutDelegate().dragOutCancelled(this.myDragOutSource);
    }

    @Override
    protected void processMousePressed(@NotNull MouseEvent event) {
        TabLabel label;
        if (event == null) {
            DragHelper.$$$reportNull$$$0(10);
        }
        this.myPressedTabLabel = (label = this.findLabel(new RelativePoint(event).getPoint((Component)this.myTabs))) == null ? null : new WeakReference<TabLabel>(label);
    }

    @Override
    protected void processDrag(@NotNull MouseEvent event, @NotNull Point targetScreenPoint, @NotNull Point startPointScreen) {
        TabLabel targetLabel;
        if (event == null) {
            DragHelper.$$$reportNull$$$0(11);
        }
        if (targetScreenPoint == null) {
            DragHelper.$$$reportNull$$$0(12);
        }
        if (startPointScreen == null) {
            DragHelper.$$$reportNull$$$0(13);
        }
        if (!(this.myTabs.isTabDraggingEnabled() && this.isDragSource(event) && MouseDragHelper.checkModifiers(event))) {
            return;
        }
        SwingUtilities.convertPointFromScreen(startPointScreen, this.myTabs);
        if (this.isDragJustStarted()) {
            TabLabel pressedTabLabel = (TabLabel)SoftReference.dereference(this.myPressedTabLabel);
            if (pressedTabLabel == null) {
                return;
            }
            Rectangle labelBounds = pressedTabLabel.getBounds();
            this.myHoldDelta = new Dimension(startPointScreen.x - labelBounds.x, startPointScreen.y - labelBounds.y);
            this.myDragSource = pressedTabLabel.getInfo();
            this.myDragRec = new Rectangle(startPointScreen, labelBounds.getSize());
            this.myDragOriginalRec = (Rectangle)this.myDragRec.clone();
            this.myDragOriginalRec.x -= this.myHoldDelta.width;
            this.myDragOriginalRec.y -= this.myHoldDelta.height;
        } else {
            if (this.myDragRec == null) {
                return;
            }
            Point toPoint = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this.myTabs);
            this.myDragRec.x = toPoint.x;
            this.myDragRec.y = toPoint.y;
        }
        this.myDragRec.x -= this.myHoldDelta.width;
        this.myDragRec.y -= this.myHoldDelta.height;
        Rectangle headerRec = this.myTabs.getLastLayoutPass().getHeaderRectangle();
        ScreenUtil.moveToFit((Rectangle)this.myDragRec, (Rectangle)headerRec, null);
        int deadZoneX = 0;
        int deadZoneY = 0;
        TabLabel top = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width / 2, this.myDragRec.y + deadZoneY));
        TabLabel bottom = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width / 2, this.myDragRec.y + this.myDragRec.height - deadZoneY));
        TabLabel left = this.findLabel(new Point(this.myDragRec.x + deadZoneX, this.myDragRec.y + this.myDragRec.height / 2));
        TabLabel right = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width - deadZoneX, this.myDragRec.y + this.myDragRec.height / 2));
        if (this.myTabs.isHorizontalTabs()) {
            targetLabel = this.findMostOverlapping(Axis.X, left, right);
            if (targetLabel == null) {
                targetLabel = this.findMostOverlapping(Axis.Y, top, bottom);
            }
        } else {
            targetLabel = this.findMostOverlapping(Axis.Y, top, bottom);
            if (targetLabel == null) {
                targetLabel = this.findMostOverlapping(Axis.X, left, right);
            }
        }
        if (targetLabel != null) {
            Rectangle saved = this.myDragRec;
            this.myDragRec = null;
            this.myTabs.reallocate(this.myDragSource, targetLabel.getInfo());
            this.myDragOriginalRec = this.myTabs.myInfo2Label.get(this.myDragSource).getBounds();
            this.myDragRec = saved;
            this.myTabs.moveDraggedTabLabel();
        } else {
            this.myTabs.moveDraggedTabLabel();
            int border = this.myTabs.getBorderThickness();
            headerRec.x -= border;
            headerRec.y -= border;
            headerRec.width += border * 2;
            headerRec.height += border * 2;
            this.myTabs.repaint(headerRec);
        }
        event.consume();
    }

    private boolean isDragSource(MouseEvent event) {
        Object source = event.getSource();
        if (source instanceof Component) {
            return SwingUtilities.windowForComponent(this.myTabs) == SwingUtilities.windowForComponent((Component)source);
        }
        return false;
    }

    private TabLabel findMostOverlapping(Axis measurer, TabLabel ... labels) {
        double freeSpace = measurer.getMinValue(this.myDragRec) < measurer.getMinValue(this.myDragOriginalRec) ? (double)(measurer.getMaxValue(this.myDragOriginalRec) - measurer.getMaxValue(this.myDragRec)) : (double)(measurer.getMinValue(this.myDragRec) - measurer.getMinValue(this.myDragOriginalRec));
        int max = -1;
        TabLabel maxLabel = null;
        for (TabLabel each : labels) {
            Rectangle eachBounds;
            if (each == null || (double)measurer.getSize(eachBounds = each.getBounds()) > freeSpace + freeSpace * 0.3) continue;
            Rectangle intersection = this.myDragRec.intersection(eachBounds);
            int size = intersection.width * intersection.height;
            if (size <= max) continue;
            max = size;
            maxLabel = each;
        }
        return maxLabel;
    }

    @Nullable
    private TabLabel findLabel(Point dragPoint) {
        Component at = this.myTabs.findComponentAt(dragPoint);
        if (at instanceof InplaceButton) {
            return null;
        }
        TabLabel label = this.findLabel(at);
        return label != null && label.getParent() == this.myTabs && label.getInfo() != this.myDragSource ? label : null;
    }

    @Nullable
    private TabLabel findLabel(Component c) {
        for (Component eachParent = c; eachParent != null && eachParent != this.myTabs; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof TabLabel)) continue;
            return (TabLabel)eachParent;
        }
        return null;
    }

    @Override
    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        if (dragComponent == null) {
            DragHelper.$$$reportNull$$$0(14);
        }
        if (dragComponentPoint == null) {
            DragHelper.$$$reportNull$$$0(15);
        }
        return this.findLabel(dragComponentPoint) != null;
    }

    @Override
    protected boolean canFinishDragging(@NotNull JComponent component, @NotNull RelativePoint point) {
        JBTabsImpl tabs;
        Component realDropTarget;
        if (component == null) {
            DragHelper.$$$reportNull$$$0(16);
        }
        if (point == null) {
            DragHelper.$$$reportNull$$$0(17);
        }
        if ((realDropTarget = UIUtil.getDeepestComponentAt((Component)point.getOriginalComponent(), (int)point.getOriginalPoint().x, (int)point.getOriginalPoint().y)) == null) {
            realDropTarget = SwingUtilities.getDeepestComponentAt(point.getOriginalComponent(), point.getOriginalPoint().x, point.getOriginalPoint().y);
        }
        if (this.myTabs.getVisibleInfos().isEmpty() && realDropTarget != null && ((tabs = (JBTabsImpl)UIUtil.getParentOfType(JBTabsImpl.class, (Component)realDropTarget)) == null || !tabs.isEditorTabs())) {
            return false;
        }
        return !this.myTabs.contains(point.getPoint((Component)this.myTabs)) || !this.myTabs.getVisibleInfos().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        if (event == null) {
            DragHelper.$$$reportNull$$$0(18);
        }
        super.processDragFinish(event, willDragOutStart);
        boolean wasSorted = !willDragOutStart && DragHelper.prepareDisableSorting();
        try {
            this.endDrag(willDragOutStart);
        }
        finally {
            DragHelper.disableSortingIfNeed(event, wasSorted);
        }
    }

    private void endDrag(boolean willDragOutStart) {
        if (willDragOutStart) {
            this.myDragOutSource = this.myDragSource;
        }
        this.myDragSource = null;
        this.myDragRec = null;
        this.myTabs.resetTabsCache();
        if (!willDragOutStart) {
            this.myTabs.fireTabsMoved();
        }
        this.myTabs.relayout(true, false);
        this.myTabs.revalidate();
    }

    @Override
    protected void processDragCancel() {
        this.endDrag(false);
    }

    public TabInfo getDragSource() {
        return this.myDragSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragToScreenPoint";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startScreenPoint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetScreenPoint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPointScreen";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragComponent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragComponentPoint";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/DragHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragOut";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragOutFinish";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "disableSortingIfNeed";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processMousePressed";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processDrag";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "canStartDragging";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "canFinishDragging";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragFinish";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

