/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.usages.impl.rules.ImportUsageFilteringRule;
import com.intellij.usages.impl.rules.ReadAccessFilteringRule;
import com.intellij.usages.impl.rules.UsageInGeneratedCodeFilteringRule;
import com.intellij.usages.impl.rules.WriteAccessFilteringRule;
import com.intellij.usages.rules.ImportFilteringRule;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\n"}, d2={"fromExtensions", "", "project", "Lcom/intellij/openapi/project/Project;", "result", "", "Lcom/intellij/usages/rules/UsageFilteringRule;", "platformUsageFilteringRules", "", "usageFilteringRules", "intellij.platform.usageView"})
@JvmName(name="UsageFilteringRules")
public final class UsageFilteringRules {
    @ApiStatus.Internal
    @NotNull
    public static final List<UsageFilteringRule> usageFilteringRules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList result = new ArrayList(UsageFilteringRules.platformUsageFilteringRules(project));
        UsageFilteringRules.fromExtensions(project, result);
        List list = ContainerUtil.immutableCopy((List)result);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.immutableCopy(result)");
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<UsageFilteringRule> platformUsageFilteringRules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<UsageFilteringRule> result = new ArrayList<UsageFilteringRule>();
        result.add(ReadAccessFilteringRule.INSTANCE);
        result.add(WriteAccessFilteringRule.INSTANCE);
        if (GeneratedSourcesFilter.EP_NAME.hasAnyExtensions()) {
            result.add(new UsageInGeneratedCodeFilteringRule(project));
        }
        if (ImportFilteringRule.EP_NAME.hasAnyExtensions()) {
            result.add(ImportUsageFilteringRule.INSTANCE);
        }
        return result;
    }

    private static final void fromExtensions(Project project, List<UsageFilteringRule> result) {
        ExtensionPointName<UsageFilteringRuleProvider> extensionPointName = UsageFilteringRuleProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"UsageFilteringRuleProvider.EP_NAME");
        for (UsageFilteringRuleProvider provider : extensionPointName.getExtensionList()) {
            ContainerUtil.addAll((Collection)result, (Iterable)provider.getApplicableRules(project));
        }
    }
}

