/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditSourceOnEnterKeyHandler {
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyboardShortcut ENTER_SHORTCUT = new KeyboardShortcut(ENTER, null);

    public static void install(@NotNull JTree tree) {
        if (tree == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(0);
        }
        EditSourceOnEnterKeyHandler.install((JComponent)tree);
    }

    public static void install(@NotNull JComponent component) {
        if (component == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(1);
        }
        EditSourceOnEnterKeyHandler.install(component, null);
    }

    public static void install(@NotNull JComponent component, @Nullable Runnable whenPerformed) {
        if (component == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(2);
        }
        EditSourceOnEnterKeyHandler.onEnterKey(component, () -> {
            if (Registry.is((String)"edit.source.on.enter.key.disabled")) {
                return false;
            }
            if (EditSourceOnEnterKeyHandler.isOverriddenByAction("EditSource")) {
                return false;
            }
            if (EditSourceOnEnterKeyHandler.isOverriddenByAction("ViewSource")) {
                return false;
            }
            DataContext context = DataManager.getInstance().getDataContext(component);
            List<Navigatable> navigatables = EditSourceOnEnterKeyHandler.getNavigatables(context);
            if (navigatables.isEmpty()) {
                return false;
            }
            boolean requestFocus = AdvancedSettings.getBoolean("edit.source.on.enter.key.request.focus.in.editor");
            navigatables.forEach(navigatable -> navigatable.navigate(requestFocus));
            if (whenPerformed != null) {
                whenPerformed.run();
            }
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isOverriddenByAction(@NotNull String actionId) {
        KeymapManager manager;
        if (actionId == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(3);
        }
        if ((manager = KeymapManager.getInstance()) == null) return false;
        if (null == ContainerUtil.find((Object[])manager.getActiveKeymap().getShortcuts(actionId), ENTER_SHORTCUT::equals)) return false;
        return true;
    }

    @NotNull
    private static List<Navigatable> getNavigatables(@NotNull DataContext context) {
        Object[] array;
        if (context == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(4);
        }
        if ((array = (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(context)) == null || array.length == 0) {
            List<Navigatable> list = Collections.emptyList();
            if (list == null) {
                EditSourceOnEnterKeyHandler.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = ContainerUtil.filter((Object[])array, Navigatable::canNavigateToSource);
        if (list.isEmpty() && Registry.is((String)"edit.source.on.enter.key.non.source.navigation.enabled")) {
            for (Object navigatable : array) {
                if (!navigatable.canNavigate()) continue;
                List<Object> list2 = Collections.singletonList(navigatable);
                if (list2 == null) {
                    EditSourceOnEnterKeyHandler.$$$reportNull$$$0(6);
                }
                return list2;
            }
        }
        List list3 = list;
        if (list3 == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private static void onEnterKey(@NotNull JComponent component, @NotNull BooleanSupplier action) {
        if (component == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(8);
        }
        if (action == null) {
            EditSourceOnEnterKeyHandler.$$$reportNull$$$0(9);
        }
        ActionListener listener = component.getActionForKeyStroke(ENTER);
        component.registerKeyboardAction(event -> {
            if (!action.getAsBoolean() && listener != null) {
                listener.actionPerformed(event);
            }
        }, ENTER, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EditSourceOnEnterKeyHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EditSourceOnEnterKeyHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenByAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatables";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onEnterKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

