/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BaseBusConnection;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MessageBusConnectionImpl
extends BaseBusConnection
implements MessageBusConnection {
    private MessageHandler defaultHandler;

    MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(0);
        }
        super(bus);
    }

    public <L> void subscribe(@NotNull Topic<L> topic) throws IllegalStateException {
        MessageHandler defaultHandler;
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(1);
        }
        if ((defaultHandler = this.defaultHandler) == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        if (topic.getListenerClass().isInstance(defaultHandler)) {
            throw new IllegalStateException("Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + defaultHandler.getClass() + "'");
        }
        this.subscribe(topic, defaultHandler);
    }

    public void setDefaultHandler(MessageHandler handler) {
        this.defaultHandler = handler;
    }

    public void dispose() {
        MessageBusImpl bus = this.bus;
        if (bus == null) {
            return;
        }
        this.bus = null;
        this.defaultHandler = null;
        bus.notifyConnectionTerminated(this.subscriptions.getAndSet(ArrayUtilRt.EMPTY_OBJECT_ARRAY));
    }

    @Override
    public void disconnect() {
        Disposer.dispose((Disposable)this);
    }

    public void deliverImmediately() {
        this.bus.deliverImmediately(this);
    }

    static boolean nullizeHandlersFromMessage(@NotNull Message message, @Nullable Object @NotNull [] topicAndHandlerPairs) {
        if (message == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(2);
        }
        if (topicAndHandlerPairs == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(3);
        }
        int nullElementCount = 0;
        for (int messageIndex = 0; messageIndex < message.handlers.length; ++messageIndex) {
            Object handler = message.handlers[messageIndex];
            if (handler == null) {
                ++nullElementCount;
            }
            for (int i2 = 0; i2 < topicAndHandlerPairs.length; i2 += 2) {
                if (message.topic != topicAndHandlerPairs[i2] || handler != topicAndHandlerPairs[i2 + 1]) continue;
                message.handlers[messageIndex] = null;
                ++nullElementCount;
            }
        }
        return nullElementCount == message.handlers.length;
    }

    boolean isMyHandler(@NotNull Topic<?> topic, @NotNull Object handler) {
        if (topic == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            MessageBusConnectionImpl.$$$reportNull$$$0(5);
        }
        if (this.defaultHandler == handler) {
            return true;
        }
        Object[] topicAndHandlerPairs = (Object[])this.subscriptions.get();
        int n = topicAndHandlerPairs.length;
        for (int i2 = 0; i2 < n; i2 += 2) {
            if (topic != topicAndHandlerPairs[i2] || handler != topicAndHandlerPairs[i2 + 1]) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topicAndHandlerPairs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/messages/impl/MessageBusConnectionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribe";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "nullizeHandlersFromMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

