/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.proxy;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.proxy.NonStaticAuthenticator;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonProxy
extends ProxySelector {
    private static final Logger LOG = Logger.getInstance(CommonProxy.class);
    private static final CommonProxy ourInstance = new CommonProxy();
    private final CommonAuthenticator myAuthenticator = new CommonAuthenticator();
    private static final ThreadLocal<Boolean> ourReenterDefence = new ThreadLocal();
    public static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static final long ourErrorInterval = TimeUnit.MINUTES.toMillis(3L);
    private static final AtomicInteger ourNotificationCount = new AtomicInteger();
    private static volatile long ourErrorTime;
    private static volatile ProxySelector ourWrong;
    private static final AtomicReference<Map<String, String>> ourProps;
    private final Object myLock = new Object();
    private final Set<Pair<HostInfo, Thread>> myNoProxy = new HashSet<Pair<HostInfo, Thread>>();
    private final Map<String, ProxySelector> myCustom = new HashMap<String, ProxySelector>();
    private final Map<String, NonStaticAuthenticator> myCustomAuth = new HashMap<String, NonStaticAuthenticator>();

    public static CommonProxy getInstance() {
        return ourInstance;
    }

    private CommonProxy() {
        this.ensureAuthenticator();
    }

    public static void isInstalledAssertion() {
        ProxySelector aDefault = ProxySelector.getDefault();
        if (ourInstance != aDefault) {
            if (ourWrong != aDefault || CommonProxy.itsTime()) {
                LOG.error("ProxySelector.setDefault() was changed to [" + aDefault.toString() + "] - other than com.intellij.util.proxy.CommonProxy.ourInstance.\nThis will make some " + ApplicationNamesInfo.getInstance().getProductName() + " network calls fail.\nInstead, methods of com.intellij.util.proxy.CommonProxy should be used for proxying.");
                ourWrong = aDefault;
            }
            ProxySelector.setDefault(ourInstance);
            ourInstance.ensureAuthenticator();
        }
        CommonProxy.assertSystemPropertiesSet();
    }

    private static boolean itsTime() {
        boolean b;
        boolean bl = b = System.currentTimeMillis() - ourErrorTime > ourErrorInterval && ourNotificationCount.get() < 5;
        if (b) {
            ourErrorTime = System.currentTimeMillis();
            ourNotificationCount.incrementAndGet();
        }
        return b;
    }

    private static void assertSystemPropertiesSet() {
        Map<String, String> props = CommonProxy.getOldStyleProperties();
        Map<String, String> was = ourProps.get();
        if (Comparing.equal(was, props) && !CommonProxy.itsTime()) {
            return;
        }
        ourProps.set(props);
        String message = CommonProxy.getMessageFromProps(props);
        if (message != null) {
            LOG.info(message);
        }
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String getMessageFromProps(Map<String, String> props) {
        String message = null;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (Strings.isEmptyOrSpaces((CharSequence)entry.getValue())) continue;
            message = IdeCoreBundle.message("proxy.old.way.label", entry.getKey(), entry.getValue());
            break;
        }
        return message;
    }

    public static Map<String, String> getOldStyleProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.proxyHost", System.getProperty("http.proxyHost"));
        props.put("https.proxyHost", System.getProperty("https.proxyHost"));
        props.put("socksProxyHost", System.getProperty("socksProxyHost"));
        return props;
    }

    public void ensureAuthenticator() {
        Authenticator.setDefault(this.myAuthenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noProxy(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            CommonProxy.$$$reportNull$$$0(0);
        }
        if (host == null) {
            CommonProxy.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy added: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.add((Pair<HostInfo, Thread>)Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoProxy(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            CommonProxy.$$$reportNull$$$0(2);
        }
        if (host == null) {
            CommonProxy.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy removed: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.remove(Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noAuthentication(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            CommonProxy.$$$reportNull$$$0(4);
        }
        if (host == null) {
            CommonProxy.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy added: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.add((Pair<HostInfo, Thread>)Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoAuthentication(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            CommonProxy.$$$reportNull$$$0(6);
        }
        if (host == null) {
            CommonProxy.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("no proxy removed: " + protocol + "://" + host + ":" + port);
            this.myNoProxy.remove(Pair.create((Object)new HostInfo(protocol, host, port), (Object)Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustom(@NotNull String key, @NotNull ProxySelector proxySelector) {
        if (key == null) {
            CommonProxy.$$$reportNull$$$0(8);
        }
        if (proxySelector == null) {
            CommonProxy.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom set: " + key + ", " + proxySelector);
            this.myCustom.put(key, proxySelector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAuth(@NotNull String key, @NotNull NonStaticAuthenticator authenticator) {
        if (key == null) {
            CommonProxy.$$$reportNull$$$0(10);
        }
        if (authenticator == null) {
            CommonProxy.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom auth set: " + key + ", " + authenticator);
            this.myCustomAuth.put(key, authenticator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAuth(@NotNull String key) {
        if (key == null) {
            CommonProxy.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom auth removed: " + key);
            this.myCustomAuth.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustom(@NotNull String key) {
        if (key == null) {
            CommonProxy.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom set: " + key);
            this.myCustom.remove(key);
        }
    }

    @NotNull
    public List<Proxy> select(@NotNull URL url) {
        if (url == null) {
            CommonProxy.$$$reportNull$$$0(14);
        }
        List<Proxy> list = this.select(CommonProxy.createUri(url));
        if (list == null) {
            CommonProxy.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static boolean isLocalhost(@NotNull String hostName) {
        if (hostName == null) {
            CommonProxy.$$$reportNull$$$0(16);
        }
        return hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1") || hostName.equals("::1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<Proxy> select(@Nullable URI uri) {
        Map<String, ProxySelector> copy;
        CommonProxy.isInstalledAssertion();
        if (uri == null) {
            List<Proxy> list = NO_PROXY_LIST;
            if (list == null) {
                CommonProxy.$$$reportNull$$$0(17);
            }
            return list;
        }
        LOG.debug("CommonProxy.select called for " + uri);
        if (Boolean.TRUE.equals(ourReenterDefence.get())) {
            List<Proxy> list = NO_PROXY_LIST;
            if (list == null) {
                CommonProxy.$$$reportNull$$$0(18);
            }
            return list;
        }
        ourReenterDefence.set(Boolean.TRUE);
        String host = Strings.notNullize((String)uri.getHost());
        if (CommonProxy.isLocalhost(host)) {
            List<Proxy> list = NO_PROXY_LIST;
            List<Proxy> list2 = list;
            if (list2 == null) {
                CommonProxy.$$$reportNull$$$0(19);
            }
            return list2;
        }
        HostInfo info = new HostInfo(uri.getScheme(), host, CommonProxy.correctPortByProtocol(uri));
        Object object = this.myLock;
        synchronized (object) {
            if (this.myNoProxy.contains(Pair.create((Object)info, (Object)Thread.currentThread()))) {
                LOG.debug("CommonProxy.select returns no proxy (in no proxy list) for " + uri);
                List<Proxy> list = NO_PROXY_LIST;
                // MONITOREXIT @DISABLED, blocks:[0, 6, 13] lbl28 : MonitorExitStatement: MONITOREXIT : var5_5
                List<Proxy> list3 = list;
                if (list3 == null) {
                    CommonProxy.$$$reportNull$$$0(20);
                }
                return list3;
            }
            copy = Map.copyOf(this.myCustom);
        }
        for (Map.Entry<String, ProxySelector> entry : copy.entrySet()) {
            List<Proxy> proxies = entry.getValue().select(uri);
            if (proxies == null || proxies.isEmpty()) continue;
            LOG.debug("CommonProxy.select returns custom proxy for " + uri + ", " + proxies);
            List<Proxy> list = proxies;
            List<Proxy> list4 = list;
            if (list4 == null) {
                CommonProxy.$$$reportNull$$$0(21);
            }
            return list4;
        }
        object = NO_PROXY_LIST;
        Object object2 = object;
        if (object2 == null) {
            CommonProxy.$$$reportNull$$$0(22);
        }
        return object2;
        finally {
            ourReenterDefence.remove();
        }
    }

    private static int correctPortByProtocol(@NotNull URI uri) {
        if (uri == null) {
            CommonProxy.$$$reportNull$$$0(23);
        }
        if (uri.getPort() == -1) {
            if ("http".equals(uri.getScheme())) {
                return 80;
            }
            if ("https".equals(uri.getScheme())) {
                return 443;
            }
        }
        return uri.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        HashMap<String, ProxySelector> copy;
        LOG.info("connect failed to " + uri.toString() + ", sa: " + sa.toString(), (Throwable)ioe);
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            copy = new HashMap<String, ProxySelector>(this.myCustom);
        }
        for (Map.Entry entry : copy.entrySet()) {
            ((ProxySelector)entry.getValue()).connectFailed(uri, sa, ioe);
        }
    }

    public Authenticator getAuthenticator() {
        return this.myAuthenticator;
    }

    public static String getHostNameReliably(String requestingHost, InetAddress site, URL requestingUrl) {
        String host = requestingHost;
        if (host == null) {
            if (site != null) {
                host = site.getHostName();
            } else if (requestingUrl != null) {
                host = requestingUrl.getHost();
            }
        }
        host = host == null ? "" : host;
        return host;
    }

    private static URI createUri(URL url) {
        return VfsUtil.toUri(url.toString());
    }

    static {
        ourProps = new AtomicReference();
        ProxySelector.setDefault(ourInstance);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxySelector";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/proxy/CommonProxy";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/proxy/CommonProxy";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "noProxy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeNoProxy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "noAuthentication";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeNoAuthentication";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCustom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCustomAuth";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomAuth";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeCustom";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isLocalhost";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "correctPortByProtocol";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class HostInfo {
        public final String myProtocol;
        public final String myHost;
        public final int myPort;

        public HostInfo(@Nullable String protocol, @NotNull String host, int port) {
            if (host == null) {
                HostInfo.$$$reportNull$$$0(0);
            }
            this.myPort = port;
            this.myHost = host;
            this.myProtocol = protocol;
        }

        public String getProtocol() {
            return this.myProtocol;
        }

        public String getHost() {
            return this.myHost;
        }

        public int getPort() {
            return this.myPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostInfo info = (HostInfo)o;
            return this.myPort == info.myPort && this.myHost.equals(info.myHost) && Objects.equals(this.myProtocol, info.myProtocol);
        }

        public int hashCode() {
            int result = this.myProtocol != null ? this.myProtocol.hashCode() : 0;
            result = 31 * result + this.myHost.hashCode();
            result = 31 * result + this.myPort;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy$HostInfo", "<init>"));
        }
    }

    private final class CommonAuthenticator
    extends Authenticator {
        private CommonAuthenticator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            Map<String, NonStaticAuthenticator> copy;
            String siteStr = this.getRequestingSite() == null ? null : this.getRequestingSite().toString();
            LOG.debug("CommonAuthenticator.getPasswordAuthentication called for " + siteStr);
            String host = CommonProxy.getHostNameReliably(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingURL());
            int port = this.getRequestingPort();
            Iterator<Map.Entry<String, NonStaticAuthenticator>> iterator = CommonProxy.this.myLock;
            synchronized (iterator) {
                HostInfo hostInfo = new HostInfo(this.getRequestingProtocol(), host, port);
                Pair pair = new Pair((Object)hostInfo, (Object)Thread.currentThread());
                if (CommonProxy.this.myNoProxy.contains(pair)) {
                    LOG.debug("CommonAuthenticator.getPasswordAuthentication found host in no proxies set (" + siteStr + ")");
                    return null;
                }
                copy = Map.copyOf(CommonProxy.this.myCustomAuth);
            }
            if (!copy.isEmpty()) {
                for (Map.Entry<String, NonStaticAuthenticator> entry : copy.entrySet()) {
                    NonStaticAuthenticator authenticator = entry.getValue();
                    this.prepareAuthenticator(authenticator);
                    PasswordAuthentication authentication = authenticator.getPasswordAuthentication();
                    if (authentication == null) continue;
                    LOG.debug("CommonAuthenticator.getPasswordAuthentication found custom authenticator for " + siteStr + ", " + entry.getKey() + ", " + authenticator);
                    this.logAuthentication(authentication);
                    return authentication;
                }
            }
            return null;
        }

        private void prepareAuthenticator(NonStaticAuthenticator authenticator) {
            authenticator.setRequestingHost(this.getRequestingHost());
            authenticator.setRequestingSite(this.getRequestingSite());
            authenticator.setRequestingPort(this.getRequestingPort());
            authenticator.setRequestingProtocol(this.getRequestingProtocol());
            @NlsSafe String requestingPrompt = this.getRequestingPrompt();
            authenticator.setRequestingPrompt(requestingPrompt);
            authenticator.setRequestingScheme(this.getRequestingScheme());
            authenticator.setRequestingURL(this.getRequestingURL());
            authenticator.setRequestorType(this.getRequestorType());
        }

        private void logAuthentication(PasswordAuthentication authentication) {
            if (authentication == null) {
                LOG.debug("CommonAuthenticator.getPasswordAuthentication returned null");
            } else {
                LOG.debug("CommonAuthenticator.getPasswordAuthentication returned authentication pair with login: " + authentication.getUserName());
            }
        }
    }
}

