/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.common.canvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.client.common.canvas.Canvas;
import org.jetbrains.projector.client.common.canvas.Context2d;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.data.AlphaCompositeRule;
import org.jetbrains.projector.common.protocol.data.CommonPath;
import org.jetbrains.projector.common.protocol.data.StrokeData;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\n\u0010\b\u001a\u00020\t*\u00020\nJ\u001a\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011J\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014J\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017J\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001aJ\n\u0010\u001b\u001a\u00020\t*\u00020\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/projector/client/common/canvas/Extensions;", "", "()V", "applyStrokeData", "", "Lorg/jetbrains/projector/client/common/canvas/Context2d;", "strokeData", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "argbIntToRgbaString", "", "", "resizeSavingImage", "Lorg/jetbrains/projector/client/common/canvas/Canvas;", "width", "height", "toCanvasLineCap", "Lorg/jetbrains/projector/client/common/canvas/Context2d$LineCap;", "Lorg/jetbrains/projector/common/protocol/data/StrokeData$Basic$CapType;", "toCanvasLineJoin", "Lorg/jetbrains/projector/client/common/canvas/Context2d$LineJoin;", "Lorg/jetbrains/projector/common/protocol/data/StrokeData$Basic$JoinType;", "toContext2dRule", "Lorg/jetbrains/projector/client/common/canvas/Context2d$CompositeOperationType;", "Lorg/jetbrains/projector/common/protocol/data/AlphaCompositeRule;", "toFillRule", "Lorg/jetbrains/projector/client/common/canvas/Context2d$FillRule;", "Lorg/jetbrains/projector/common/protocol/data/CommonPath$WindingType;", "toFontFaceName", "", "projector-client-common"})
public final class Extensions {
    @NotNull
    public static final Extensions INSTANCE = new Extensions();

    private Extensions() {
    }

    public final void resizeSavingImage(@NotNull Canvas $this$resizeSavingImage, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$resizeSavingImage, (String)"<this>");
        if ($this$resizeSavingImage.getWidth() == width && $this$resizeSavingImage.getHeight() == height) {
            return;
        }
        if ($this$resizeSavingImage.getWidth() == 0 || $this$resizeSavingImage.getHeight() == 0) {
            $this$resizeSavingImage.setWidth(width);
            $this$resizeSavingImage.setHeight(height);
            return;
        }
        Canvas.Snapshot snapshot = $this$resizeSavingImage.takeSnapshot();
        double d = (double)$this$resizeSavingImage.getWidth() / (double)width - (double)$this$resizeSavingImage.getHeight() / (double)height;
        boolean bl = false;
        boolean scalingChanged = Math.abs(d) < 0.1;
        $this$resizeSavingImage.setWidth(width);
        $this$resizeSavingImage.setHeight(height);
        if (scalingChanged) {
            $this$resizeSavingImage.getContext2d().drawImage(snapshot, 0.0, 0.0, $this$resizeSavingImage.getWidth(), $this$resizeSavingImage.getHeight());
        } else {
            $this$resizeSavingImage.getContext2d().drawImage(snapshot, 0.0, 0.0);
        }
    }

    @NotNull
    public final Context2d.FillRule toFillRule(@NotNull CommonPath.WindingType $this$toFillRule) {
        Context2d.FillRule fillRule;
        Intrinsics.checkNotNullParameter((Object)$this$toFillRule, (String)"<this>");
        CommonPath.WindingType windingType = $this$toFillRule;
        int n = WhenMappings.$EnumSwitchMapping$0[windingType.ordinal()];
        switch (n) {
            case 1: {
                fillRule = Context2d.FillRule.EVENODD;
                break;
            }
            case 2: {
                fillRule = Context2d.FillRule.NONZERO;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fillRule;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyStrokeData(@NotNull Context2d $this$applyStrokeData, @NotNull StrokeData strokeData) {
        double[] dArray;
        Context2d context2d2;
        Intrinsics.checkNotNullParameter((Object)$this$applyStrokeData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)strokeData, (String)"strokeData");
        Do do_ = Do.INSTANCE;
        StrokeData strokeData2 = strokeData;
        if (strokeData2 instanceof StrokeData.Basic) {
            $this$applyStrokeData.setLineWidth(((StrokeData.Basic)strokeData).getLineWidth());
            $this$applyStrokeData.setLineCap(this.toCanvasLineCap(((StrokeData.Basic)strokeData).getEndCap()));
            $this$applyStrokeData.setLineJoin(this.toCanvasLineJoin(((StrokeData.Basic)strokeData).getLineJoin()));
            $this$applyStrokeData.setMiterLimit(((StrokeData.Basic)strokeData).getMiterLimit());
            context2d2 = $this$applyStrokeData;
            List list = ((StrokeData.Basic)strokeData).getDashArray();
            if (list == null) {
                dArray = null;
            } else {
                Collection<Double> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list;
                Context2d context2d3 = context2d2;
                boolean $i$f$map = false;
                void var10_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    float f = ((Number)item$iv$iv).floatValue();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Double d = (double)p0;
                    collection.add(d);
                }
                collection = (List)destination$iv$iv;
                context2d2 = context2d3;
                List list2 = collection;
                dArray = CollectionsKt.toDoubleArray((Collection)list2);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double[] dArray2 = dArray;
        context2d2.setLineDash(dArray2 == null ? new double[]{} : dArray2);
        $this$applyStrokeData.setLineDashOffset(((StrokeData.Basic)strokeData).getDashPhase());
        strokeData2 = Unit.INSTANCE;
        boolean $i$f$exhaustive = false;
    }

    @NotNull
    public final Context2d.LineCap toCanvasLineCap(@NotNull StrokeData.Basic.CapType $this$toCanvasLineCap) {
        Context2d.LineCap lineCap;
        Intrinsics.checkNotNullParameter((Object)$this$toCanvasLineCap, (String)"<this>");
        StrokeData.Basic.CapType capType = $this$toCanvasLineCap;
        int n = WhenMappings.$EnumSwitchMapping$1[capType.ordinal()];
        switch (n) {
            case 1: {
                lineCap = Context2d.LineCap.ROUND;
                break;
            }
            case 2: {
                lineCap = Context2d.LineCap.SQUARE;
                break;
            }
            case 3: {
                lineCap = Context2d.LineCap.BUTT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return lineCap;
    }

    @NotNull
    public final Context2d.LineJoin toCanvasLineJoin(@NotNull StrokeData.Basic.JoinType $this$toCanvasLineJoin) {
        Context2d.LineJoin lineJoin;
        Intrinsics.checkNotNullParameter((Object)$this$toCanvasLineJoin, (String)"<this>");
        StrokeData.Basic.JoinType joinType = $this$toCanvasLineJoin;
        int n = WhenMappings.$EnumSwitchMapping$2[joinType.ordinal()];
        switch (n) {
            case 1: {
                lineJoin = Context2d.LineJoin.ROUND;
                break;
            }
            case 2: {
                lineJoin = Context2d.LineJoin.BEVEL;
                break;
            }
            case 3: {
                lineJoin = Context2d.LineJoin.MITER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return lineJoin;
    }

    @NotNull
    public final Context2d.CompositeOperationType toContext2dRule(@NotNull AlphaCompositeRule $this$toContext2dRule) {
        Context2d.CompositeOperationType compositeOperationType;
        Intrinsics.checkNotNullParameter((Object)$this$toContext2dRule, (String)"<this>");
        AlphaCompositeRule alphaCompositeRule = $this$toContext2dRule;
        int n = WhenMappings.$EnumSwitchMapping$3[alphaCompositeRule.ordinal()];
        switch (n) {
            case 1: {
                compositeOperationType = Context2d.CompositeOperationType.SRC_OVER;
                break;
            }
            case 2: {
                compositeOperationType = Context2d.CompositeOperationType.DST_OVER;
                break;
            }
            case 3: {
                compositeOperationType = Context2d.CompositeOperationType.SRC_IN;
                break;
            }
            case 4: {
                compositeOperationType = Context2d.CompositeOperationType.DST_IN;
                break;
            }
            case 5: {
                compositeOperationType = Context2d.CompositeOperationType.SRC_OUT;
                break;
            }
            case 6: {
                compositeOperationType = Context2d.CompositeOperationType.DST_OUT;
                break;
            }
            case 7: {
                compositeOperationType = Context2d.CompositeOperationType.SRC_ATOP;
                break;
            }
            case 8: {
                compositeOperationType = Context2d.CompositeOperationType.DST_ATOP;
                break;
            }
            case 9: {
                compositeOperationType = Context2d.CompositeOperationType.XOR;
                break;
            }
            case 10: {
                compositeOperationType = Context2d.CompositeOperationType.SRC;
                break;
            }
            case 11: {
                compositeOperationType = Context2d.CompositeOperationType.CLEAR;
                break;
            }
            case 12: {
                compositeOperationType = Context2d.CompositeOperationType.DST;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return compositeOperationType;
    }

    @NotNull
    public final String toFontFaceName(short $this$toFontFaceName) {
        return "serverFont" + $this$toFontFaceName;
    }

    @NotNull
    public final String argbIntToRgbaString(int $this$argbIntToRgbaString) {
        int colorValue = $this$argbIntToRgbaString;
        int b = colorValue & 0xFF;
        int g = colorValue >>> 8 & 0xFF;
        int r = colorValue >>> 16 & 0xFF;
        double a = (double)(colorValue >>> 24 & 0xFF) / 255.0;
        return "rgba(" + r + "," + g + "," + b + "," + a + ")";
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[CommonPath.WindingType.values().length];
            nArray[CommonPath.WindingType.EVEN_ODD.ordinal()] = 1;
            nArray[CommonPath.WindingType.NON_ZERO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StrokeData.Basic.CapType.values().length];
            nArray[StrokeData.Basic.CapType.ROUND.ordinal()] = 1;
            nArray[StrokeData.Basic.CapType.SQUARE.ordinal()] = 2;
            nArray[StrokeData.Basic.CapType.BUTT.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[StrokeData.Basic.JoinType.values().length];
            nArray[StrokeData.Basic.JoinType.ROUND.ordinal()] = 1;
            nArray[StrokeData.Basic.JoinType.BEVEL.ordinal()] = 2;
            nArray[StrokeData.Basic.JoinType.MITER.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[AlphaCompositeRule.values().length];
            nArray[AlphaCompositeRule.SRC_OVER.ordinal()] = 1;
            nArray[AlphaCompositeRule.DST_OVER.ordinal()] = 2;
            nArray[AlphaCompositeRule.SRC_IN.ordinal()] = 3;
            nArray[AlphaCompositeRule.DST_IN.ordinal()] = 4;
            nArray[AlphaCompositeRule.SRC_OUT.ordinal()] = 5;
            nArray[AlphaCompositeRule.DST_OUT.ordinal()] = 6;
            nArray[AlphaCompositeRule.SRC_ATOP.ordinal()] = 7;
            nArray[AlphaCompositeRule.DST_ATOP.ordinal()] = 8;
            nArray[AlphaCompositeRule.XOR.ordinal()] = 9;
            nArray[AlphaCompositeRule.SRC.ordinal()] = 10;
            nArray[AlphaCompositeRule.CLEAR.ordinal()] = 11;
            nArray[AlphaCompositeRule.DST.ordinal()] = 12;
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

