/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import org.apache.tika.parser.microsoft.onenote.JCIDPropertySetTypeEnum;

class JCID {
    long jcid;
    long index;
    boolean isBinary;
    boolean isPropertySet;
    boolean isGraphNode;
    boolean isFileData;
    boolean isReadOnly;

    JCID() {
    }

    public boolean isObjectSpaceObjectPropSet() {
        return this.isPropertySet || !this.isBinary && !this.isGraphNode && !this.isFileData && !this.isReadOnly && this.index > 0L;
    }

    public void loadFrom32BitIndex(long fullIndex) {
        this.jcid = fullIndex;
        this.index = fullIndex & 0xFFFFL;
        this.isBinary = (fullIndex >> 16 & 1L) == 1L;
        this.isPropertySet = (fullIndex >> 17 & 1L) == 1L;
        this.isGraphNode = (fullIndex >> 18 & 1L) == 1L;
        this.isFileData = (fullIndex >> 19 & 1L) == 1L;
        boolean bl = this.isReadOnly = (fullIndex >> 20 & 1L) == 1L;
        if (fullIndex >> 21 != 0L) {
            throw new RuntimeException("RESERVED_NONZERO");
        }
    }

    public String toString() {
        return "JCID{jcid=" + (Object)((Object)JCIDPropertySetTypeEnum.of(this.jcid)) + " (0x" + Long.toHexString(this.jcid) + "), index=" + this.index + ", isBinary=" + this.isBinary + ", isPropertySet=" + this.isPropertySet + ", isGraphNode=" + this.isGraphNode + ", isFileData=" + this.isFileData + ", isReadOnly=" + this.isReadOnly + '}';
    }

    public long getJcid() {
        return this.jcid;
    }

    public void setJcid(long jcid) {
        this.jcid = jcid;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean binary) {
        this.isBinary = binary;
    }

    public boolean isPropertySet() {
        return this.isPropertySet;
    }

    public void setPropertySet(boolean propertySet) {
        this.isPropertySet = propertySet;
    }

    public boolean isGraphNode() {
        return this.isGraphNode;
    }

    public void setGraphNode(boolean graphNode) {
        this.isGraphNode = graphNode;
    }

    public boolean isFileData() {
        return this.isFileData;
    }

    public void setFileData(boolean fileData) {
        this.isFileData = fileData;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }
}

