/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.fieldaccess;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Range;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedEmptyFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedIndexFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedRangeFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedStringFieldAccess;

public class BracketFieldAccess
extends FieldAccess {
    private JsonQuery end;
    private JsonQuery begin;
    private boolean isRange;

    public BracketFieldAccess(JsonQuery src, JsonQuery begin, boolean permissive) {
        super(src, permissive);
        this.begin = begin;
        this.isRange = false;
    }

    public BracketFieldAccess(JsonQuery src, JsonQuery begin, JsonQuery end, boolean permissive) {
        super(src, permissive);
        this.begin = begin;
        this.end = end;
        this.isRange = true;
    }

    public String toString() {
        if (this.isRange) {
            return String.format("%s[%s : %s]%s", this.target, this.begin == null ? "" : this.begin, this.end == null ? "" : this.end, this.permissive ? "?" : "");
        }
        return String.format("%s[%s]%s", this.target, this.begin, this.permissive ? "?" : "");
    }

    @Override
    public ResolvedFieldAccess resolveFieldAccess(Scope scope, JsonNode in) throws JsonQueryException {
        if (this.isRange) {
            List<IntNode> accessorBeginTuple = this.begin == null ? Collections.singletonList(new IntNode(0)) : this.begin.apply(scope, in);
            List<IntNode> accessorEndTuple = this.end == null ? Collections.singletonList(new IntNode(Integer.MAX_VALUE)) : this.end.apply(scope, in);
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (JsonNode jsonNode : accessorBeginTuple) {
                for (JsonNode jsonNode2 : accessorEndTuple) {
                    if (JsonNodeUtils.isIntegralNumber(jsonNode) && JsonNodeUtils.isIntegralNumber(jsonNode2)) {
                        long indexBegin = jsonNode.asLong();
                        long indexEnd = jsonNode2.asLong();
                        ranges.add(new Range(indexBegin, indexEnd));
                        continue;
                    }
                    if (!this.permissive) {
                        throw JsonQueryException.format("Start and end indices of an %s slice must be numbers", in.getNodeType());
                    }
                    return new ResolvedEmptyFieldAccess(this.permissive);
                }
            }
            return new ResolvedRangeFieldAccess(this.permissive, ranges);
        }
        ArrayList<Long> indices = new ArrayList<Long>();
        ArrayList<String> keys = new ArrayList<String>();
        List<JsonNode> accessorTuple = this.begin.apply(scope, in);
        for (JsonNode jsonNode : accessorTuple) {
            if (JsonNodeUtils.isIntegralNumber(jsonNode)) {
                long index = jsonNode.asLong();
                indices.add(index);
                continue;
            }
            if (jsonNode.isTextual()) {
                String key = jsonNode.asText();
                keys.add(key);
                continue;
            }
            if (!this.permissive) {
                throw JsonQueryException.format("Cannot index %s with %s", in.getNodeType(), jsonNode.getNodeType());
            }
            return new ResolvedEmptyFieldAccess(this.permissive);
        }
        if (!indices.isEmpty() && !keys.isEmpty()) {
            throw new JsonQueryException("bad index");
        }
        if (!indices.isEmpty()) {
            return new ResolvedIndexFieldAccess(this.permissive, indices);
        }
        if (!keys.isEmpty()) {
            return new ResolvedStringFieldAccess(this.permissive, keys);
        }
        return new ResolvedEmptyFieldAccess(this.permissive);
    }
}

