/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributedCharacters {
    protected char[] chars = new char[10];
    protected Font[] fonts = new Font[10];
    protected Color[] colors = new Color[10];
    protected int[] runStart = new int[10];
    protected int[] runLimit = new int[10];
    protected int current = -1;

    public void append(char c, Font font, Color color) {
        if (font == null) {
            return;
        }
        if (++this.current == this.chars.length) {
            char[] cArray = new char[2 * this.chars.length];
            Font[] fontArray = new Font[2 * this.chars.length];
            Color[] colorArray = new Color[2 * this.chars.length];
            int[] nArray = new int[2 * this.chars.length];
            int[] nArray2 = new int[2 * this.chars.length];
            System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
            System.arraycopy(this.fonts, 0, fontArray, 0, this.chars.length);
            System.arraycopy(this.colors, 0, colorArray, 0, this.chars.length);
            System.arraycopy(this.runStart, 0, nArray, 0, this.chars.length);
            System.arraycopy(this.runLimit, 0, nArray2, 0, this.chars.length);
            this.chars = cArray;
            this.fonts = fontArray;
            this.colors = colorArray;
            this.runStart = nArray;
            this.runLimit = nArray2;
        }
        this.chars[this.current] = c;
        this.fonts[this.current] = font;
        this.colors[this.current] = color;
        if (this.current != 0) {
            int n = this.current - 1;
            if (this.fonts[n].equals(font) && this.colors[n].equals(color)) {
                this.runStart[this.current] = this.runStart[n];
                this.runLimit[this.runStart[this.current]] = this.current;
            } else {
                this.runLimit[this.current] = this.current;
                this.runStart[this.current] = this.current;
            }
        }
    }

    public void append(char[] cArray, Font font, Color color) {
        int n;
        if (cArray == null || cArray.length == 0 || font == null || color == null) {
            return;
        }
        if (++this.current + cArray.length >= this.chars.length) {
            n = Math.max(this.current + cArray.length, 2 * this.chars.length);
            char[] cArray2 = new char[n];
            Font[] fontArray = new Font[n];
            Color[] colorArray = new Color[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.chars, 0, cArray2, 0, this.chars.length);
            System.arraycopy(this.fonts, 0, fontArray, 0, this.fonts.length);
            System.arraycopy(this.colors, 0, colorArray, 0, this.chars.length);
            System.arraycopy(this.runStart, 0, nArray, 0, this.chars.length);
            System.arraycopy(this.runLimit, 0, nArray2, 0, this.chars.length);
            this.chars = cArray2;
            this.fonts = fontArray;
            this.colors = colorArray;
            this.runStart = nArray;
            this.runLimit = nArray2;
        }
        System.arraycopy(cArray, 0, this.chars, this.current, cArray.length);
        for (n = 0; n < cArray.length; ++n) {
            this.fonts[n + this.current] = font;
            this.colors[n + this.current] = color;
        }
        n = this.current - 1;
        int n2 = this.current + cArray.length - 1;
        if (n < 0) {
            this.runLimit[0] = n2;
        } else {
            int n3;
            if (this.fonts[n].equals(font) && this.colors[n].equals(color)) {
                this.runLimit[this.runStart[n]] = n2;
                n3 = this.runStart[n];
            } else {
                this.runLimit[this.current] = n2;
                n3 = this.current;
            }
            for (int i = this.current; i <= n2; ++i) {
                this.runStart[i] = n3;
            }
        }
        this.current = n2;
    }

    public AttributedCharacterIterator iterator() {
        int n = this.current + 1;
        char[] cArray = new char[n];
        Font[] fontArray = new Font[n];
        Color[] colorArray = new Color[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        System.arraycopy(this.runStart, 0, nArray, 0, n);
        System.arraycopy(this.runLimit, 0, nArray2, 0, n);
        System.arraycopy(this.chars, 0, cArray, 0, n);
        System.arraycopy(this.fonts, 0, fontArray, 0, n);
        System.arraycopy(this.colors, 0, colorArray, 0, n);
        AttributedCharacterIteratorImpl attributedCharacterIteratorImpl = new AttributedCharacterIteratorImpl(cArray, fontArray, colorArray, nArray, nArray2);
        return attributedCharacterIteratorImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributedCharacterIteratorImpl
    implements AttributedCharacterIterator {
        protected int current;
        protected char[] chars;
        protected Font[] fonts;
        protected Color[] colors;
        protected int[] runStart;
        protected int[] runLimit;
        protected Set<AttributedCharacterIterator.Attribute> singleton;

        public AttributedCharacterIteratorImpl(char[] cArray, Font[] fontArray, Color[] colorArray, int[] nArray, int[] nArray2) {
            this.chars = cArray;
            this.fonts = fontArray;
            this.colors = colorArray;
            this.runStart = nArray;
            this.runLimit = nArray2;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public char current() {
            if (this.current >= this.chars.length) {
                return '\uffff';
            }
            return this.chars[this.current];
        }

        @Override
        public char first() {
            this.current = 0;
            if (this.current >= this.chars.length) {
                return '\uffff';
            }
            return this.chars[this.current];
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.chars.length;
        }

        @Override
        public int getIndex() {
            return this.current;
        }

        @Override
        public char last() {
            int n = this.getEndIndex();
            if (n == 0) {
                return '\uffff';
            }
            this.current = n - 1;
            return this.chars[this.current];
        }

        @Override
        public char next() {
            if (this.current >= this.getEndIndex() - 1) {
                return '\uffff';
            }
            return this.chars[++this.current];
        }

        @Override
        public char previous() {
            if (this.current == 0) {
                return '\uffff';
            }
            return this.chars[--this.current];
        }

        @Override
        public char setIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == this.getEndIndex()) {
                this.current = this.getEndIndex();
                return '\uffff';
            }
            this.current = n;
            return this.chars[this.current];
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            if (this.singleton == null) {
                HashSet<TextAttribute> hashSet = new HashSet<TextAttribute>(4);
                hashSet.add(TextAttribute.FONT);
                hashSet.add(TextAttribute.FOREGROUND);
                this.singleton = Collections.unmodifiableSet(hashSet);
            }
            return this.singleton;
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            if (attribute == TextAttribute.FONT) {
                return this.fonts[this.getIndex()];
            }
            if (attribute == TextAttribute.FOREGROUND) {
                return this.colors[this.getIndex()];
            }
            return null;
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>(1);
            hashMap.put(TextAttribute.FONT, this.fonts[this.getIndex()]);
            hashMap.put(TextAttribute.FOREGROUND, this.colors[this.getIndex()]);
            return hashMap;
        }

        @Override
        public int getRunLimit() {
            return this.runLimit[this.runStart[this.getIndex()]] + 1;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (attribute != TextAttribute.FONT && attribute != TextAttribute.FOREGROUND) {
                return this.getEndIndex();
            }
            return this.getRunLimit();
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
            if (set.contains(TextAttribute.FONT) || set.contains(TextAttribute.FOREGROUND)) {
                return this.getRunLimit();
            }
            return this.getEndIndex();
        }

        @Override
        public int getRunStart() {
            return this.runStart[this.getIndex()];
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (attribute != TextAttribute.FONT && attribute != TextAttribute.FOREGROUND) {
                return 0;
            }
            return this.getRunStart();
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
            if (set.contains(TextAttribute.FONT) || set.contains(TextAttribute.FOREGROUND)) {
                return this.getRunStart();
            }
            return 0;
        }
    }
}

