'\"
'\" Copyright (c) 1991-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH wm n 8.5 Tk "Tk Built-In Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
wm \- Communicate with window manager
.SH SYNOPSIS
\fBwm\fR \fIoption window \fR?\fIargs\fR?
.BE
.SH DESCRIPTION
.PP
The \fBwm\fR command is used to interact with window managers in
order to control such things as the title for a window, its geometry,
or the increments in terms of which it may be resized.  The \fBwm\fR
command can take any of a number of different forms, depending on
the \fIoption\fR argument.  All of the forms expect at least one
additional argument, \fIwindow\fR, which must be the path name of a
top-level window.
.PP
The legal forms for the \fBwm\fR command are:
.TP
\fBwm aspect \fIwindow\fR ?\fIminNumer minDenom maxNumer maxDenom\fR?
.
If \fIminNumer\fR, \fIminDenom\fR, \fImaxNumer\fR, and \fImaxDenom\fR
are all specified, then they will be passed to the window manager
and the window manager should use them to enforce a range of
acceptable aspect ratios for \fIwindow\fR.  The aspect ratio of
\fIwindow\fR (width/length) will be constrained to lie
between \fIminNumer\fR/\fIminDenom\fR and \fImaxNumer\fR/\fImaxDenom\fR.
If \fIminNumer\fR etc. are all specified as empty strings, then
any existing aspect ratio restrictions are removed.
If \fIminNumer\fR etc. are specified, then the command returns an
empty string.  Otherwise, it returns
a Tcl list containing four elements, which are the current values
of \fIminNumer\fR, \fIminDenom\fR, \fImaxNumer\fR, and \fImaxDenom\fR
(if no aspect restrictions are in effect, then an empty string is
returned).
.TP
\fBwm attributes \fIwindow\fR
.TP
\fBwm attributes \fIwindow\fR ?\fBoption\fR?
.TP
\fBwm attributes \fIwindow\fR ?\fBoption value option value...\fR?
.
This subcommand returns or sets platform specific attributes associated
with a window. The first form returns a list of the platform specific
flags and their values. The second form returns the value for the
specific option. The third form sets one or more of the values. The
values are as follows:
.RS
.PP
All platforms support the following attributes (though X11 users
should see the notes below):
.TP
\fB\-alpha\fR
.
Specifies the alpha transparency level of the toplevel. It accepts a value
from \fB0.0\fR (fully transparent) to \fB1.0\fR (opaque).  Values outside that
range will be constrained.  Where not supported, the \fB\-alpha\fR value
remains at \fB1.0\fR.
.TP
\fB\-fullscreen\fR
.
Places the window in a mode that takes up the entire screen, has no
borders, and covers the general use area (i.e. Start menu and taskbar on
Windows, dock and menubar on OSX, general window decorations on X11).
.TP
\fB\-topmost\fR
.
Specifies whether this is a topmost window (displays above all other windows).
.PP
On Windows, the following attributes may be set.
.TP
\fB\-disabled\fR
.
Specifies whether the window is in a disabled state.
.TP
\fB\-toolwindow\fR
.
Specifies a toolwindow style window (as defined in the MSDN).
.TP
\fB\-transparentcolor\fR
.
Specifies the transparent color index of the toplevel.  It takes any color
value accepted by \fBTk_GetColor\fR.  If the empty string is specified
(default), no transparent color is used.  This is supported on Windows
2000/XP+.  Where not supported, the \fB\-transparentcolor\fR value remains
at \fB{}\fR.
.PP
On Mac OS X, the following attributes may be set.
.TP
\fB\-modified\fR
.
Specifies the modification state of the window (determines whether the
window close widget contains the modification indicator and whether the
proxy icon is draggable).
.TP
\fB\-notify\fR
.
Specifies process notification state (bouncing of the application dock icon).
.TP
\fB\-titlepath\fR
.
Specifies the path of the file referenced as the window proxy icon (which
can be dragged and dropped in lieu of the file's finder icon).
.TP
\fB\-transparent\fR
.
Makes the window content area transparent and turns off the window shadow. For
the transparency to be effective, the toplevel background needs to be set to a
color with some alpha, e.g.
.QW systemTransparent .
.PP
On X11, the following attributes may be set. These are not supported by all
window managers, and will have no effect under older WMs.
.\" See http://www.freedesktop.org/Standards/wm-spec
.TP
\fB\-type\fR
.VS 8.6
Requests that the window should be interpreted by the window manager as being
of the specified type(s). This may cause the window to be decorated in a
different way or otherwise managed differently, though exactly what happens is
entirely up to the window manager. A list of types may be used, in order of
preference. The following values are mapped to constants defined in the EWMH
specification (using others is possible, but not advised):
.RS
.TP
\fBdesktop\fR
.
indicates a desktop feature,
.TP
\fBdock\fR
.
indicates a dock/panel feature,
.TP
\fBtoolbar\fR
.
indicates a toolbar window that should be acting on behalf of another window,
as indicated with \fBwm transient\fR,
.TP
\fBmenu\fR
.
indicates a torn-off menu that should be acting on behalf of another window,
as indicated with \fBwm transient\fR,
.TP
\fButility\fR
.
indicates a utility window (e.g., palette or toolbox) that should be acting on
behalf of another window, as indicated with \fBwm transient\fR,
.TP
\fBsplash\fR
.
indicates a splash screen, displayed during application start up,
.TP
\fBdialog\fR
.
indicates a general dialog window, that should be acting on behalf of another
window, as indicated with \fBwm transient\fR,
.TP
\fBdropdown_menu\fR
.
indicates a menu summoned from a menu bar, which should usually also be set to
be override-redirected (with \fBwm overrideredirect\fR),
.TP
\fBpopup_menu\fR
.
indicates a popup menu, which should usually also be set to be
override-redirected (with \fBwm overrideredirect\fR),
.TP
\fBtooltip\fR
.
indicates a tooltip window, which should usually also be set to be
override-redirected (with \fBwm overrideredirect\fR),
.TP
\fBnotification\fR
.
indicates a window that provides a background notification of some event,
which should usually also be set to be override-redirected (with \fBwm
overrideredirect\fR),
.TP
\fBcombo\fR
.
indicates the drop-down list of a combobox widget, which should usually also
be set to be override-redirected (with \fBwm overrideredirect\fR),
.TP
\fBdnd\fR
.
indicates a window that represents something being dragged, which should
usually also be set to be override-redirected (with
\fBwm overrideredirect\fR),
.TP
\fBnormal\fR
.
indicates a window that has no special interpretation.
.RE
.VE 8.6
.TP
\fB\-zoomed\fR
.
Requests that the window should be maximized. This is the same as \fBwm state
zoomed\fR on Windows and Mac OS X.
.PP
On X11, changes to window attributes are performed asynchronously. Querying
the value of an attribute returns the current state, which will not be the
same as the value most recently set if the window manager has not yet
processed the request or if it does not support the attribute.
.RE
.TP
\fBwm client \fIwindow\fR ?\fIname\fR?
.
If \fIname\fR is specified, this command stores \fIname\fR (which
should be the name of
the host on which the application is executing) in \fIwindow\fR's
\fBWM_CLIENT_MACHINE\fR property for use by the window manager or
session manager.
The command returns an empty string in this case.
If \fIname\fR is not specified, the command returns the last name
set in a \fBwm client\fR command for \fIwindow\fR.
If \fIname\fR is specified as an empty string, the command deletes the
\fBWM_CLIENT_MACHINE\fR property from \fIwindow\fR.
.TP
\fBwm colormapwindows \fIwindow\fR ?\fIwindowList\fR?
.
This command is used to manipulate the \fBWM_COLORMAP_WINDOWS\fR
property, which provides information to the window managers about
windows that have private colormaps.
.RS
.PP
If \fIwindowList\fR is not specified, the command returns a list
whose elements are the names of the windows in the \fBWM_COLORMAP_WINDOWS\fR
property.
If \fIwindowList\fR is specified, it consists of a list of window
path names;  the command overwrites the \fBWM_COLORMAP_WINDOWS\fR
property with the given windows and returns an empty string.
The \fBWM_COLORMAP_WINDOWS\fR property should normally contain a
list of the internal windows within \fIwindow\fR whose colormaps differ
from their parents.
.PP
The order of the windows in the property indicates a priority order:
the window manager will attempt to install as many colormaps as possible
from the head of this list when \fIwindow\fR gets the colormap focus.
If \fIwindow\fR is not included among the windows in \fIwindowList\fR,
Tk implicitly adds it at the end of the \fBWM_COLORMAP_WINDOWS\fR
property, so that its colormap is lowest in priority.
If \fBwm colormapwindows\fR is not invoked, Tk will automatically set
the property for each top-level window to all the internal windows
whose colormaps differ from their parents, followed by the top-level
itself;  the order of the internal windows is undefined.
See the ICCCM documentation for more information on the
\fBWM_COLORMAP_WINDOWS\fR property.
.RE
.TP
\fBwm command \fIwindow\fR ?\fIvalue\fR?
.
If \fIvalue\fR is specified, this command stores \fIvalue\fR in \fIwindow\fR's
\fBWM_COMMAND\fR property for use by the window manager or
session manager and returns an empty string.
\fIValue\fR must have proper list structure;  the elements should
contain the words of the command used to invoke the application.
If \fIvalue\fR is not specified then the command returns the last value
set in a \fBwm command\fR command for \fIwindow\fR.
If \fIvalue\fR is specified as an empty string, the command
deletes the \fBWM_COMMAND\fR property from \fIwindow\fR.
.TP
\fBwm deiconify \fIwindow\fR
.
Arrange for \fIwindow\fR to be displayed in normal (non-iconified) form.
This is done by mapping the window.  If the window has never been
mapped then this command will not map the window, but it will ensure
that when the window is first mapped it will be displayed
in de-iconified form.  On Windows, a deiconified window will also be
raised and be given the focus (made the active window).
Returns an empty string.
.TP
\fBwm focusmodel \fIwindow\fR ?\fBactive\fR|\fBpassive\fR?
.
If \fBactive\fR or \fBpassive\fR is supplied as an optional argument
to the command, then it specifies the focus model for \fIwindow\fR.
In this case the command returns an empty string.  If no additional
argument is supplied, then the command returns the current focus
model for \fIwindow\fR.
.RS
.PP
An \fBactive\fR focus model means that \fIwindow\fR will claim the
input focus for itself or its descendants, even at times when
the focus is currently in some other application.  \fBPassive\fR means that
\fIwindow\fR will never claim the focus for itself:  the window manager
should give the focus to \fIwindow\fR at appropriate times.  However,
once the focus has been given to \fIwindow\fR or one of its descendants,
the application may re-assign the focus among \fIwindow\fR's descendants.
The focus model defaults to \fBpassive\fR, and Tk's \fBfocus\fR command
assumes a passive model of focusing.
.RE
.TP
\fBwm forget \fIwindow\fR
.
The \fIwindow\fR will be unmapped from the screen and will no longer
be managed by \fBwm\fR.  Windows created with the \fBtoplevel\fR
command will be treated like \fBframe\fR windows once they are no
longer managed by \fBwm\fR, however, the \fB\-menu\fR configuration will be
remembered and the menus will return once the widget is managed again.
.TP
\fBwm frame \fIwindow\fR
.
If \fIwindow\fR has been reparented by the window manager into a
decorative frame, the command returns the platform specific window
identifier for the outermost frame that contains \fIwindow\fR (the
window whose parent is the root or virtual root).  If \fIwindow\fR
has not been reparented by the window manager then the command returns
the platform specific window identifier for \fIwindow\fR.
.TP
\fBwm geometry \fIwindow\fR ?\fInewGeometry\fR?
.
If \fInewGeometry\fR is specified, then the geometry of \fIwindow\fR
is changed and an empty string is returned.  Otherwise the current
geometry for \fIwindow\fR is returned (this is the most recent
geometry specified either by manual resizing or
in a \fBwm geometry\fR command).  \fINewGeometry\fR has
the form \fB=\fIwidth\fBx\fIheight\fB\(+-\fIx\fB\(+-\fIy\fR, where
any of \fB=\fR, \fIwidth\fBx\fIheight\fR, or \fB\(+-\fIx\fB\(+-\fIy\fR
may be omitted.  \fIWidth\fR and \fIheight\fR are positive integers
specifying the desired dimensions of \fIwindow\fR.  If \fIwindow\fR
is gridded (see \fBGRIDDED GEOMETRY MANAGEMENT\fR below) then the dimensions
are specified in grid units;  otherwise they are specified in pixel
units.
.RS
.PP
\fIX\fR and \fIy\fR specify the desired location of
\fIwindow\fR on the screen, in pixels.
If \fIx\fR is preceded by \fB+\fR, it specifies
the number of pixels between the left edge of the screen and the left
edge of \fIwindow\fR's border;  if preceded by \fB\-\fR then
\fIx\fR specifies the number of pixels
between the right edge of the screen and the right edge of \fIwindow\fR's
border.  If \fIy\fR is preceded by \fB+\fR then it specifies the
number of pixels between the top of the screen and the top
of \fIwindow\fR's border;  if \fIy\fR is preceded by \fB\-\fR then
it specifies the number of pixels between the bottom of \fIwindow\fR's
border and the bottom of the screen.
.PP
If \fInewGeometry\fR is specified as an empty string then any
existing user-specified geometry for \fIwindow\fR is cancelled, and
the window will revert to the size requested internally by its
widgets.
.PP
Note that this is related to \fBwinfo geometry\fR, but not the same. That can
only query the geometry, and always reflects Tk's current understanding of the
actual size and location of \fIwindow\fR, whereas \fBwm geometry\fR allows
both setting and querying of the \fIwindow manager\fR's understanding of the
size and location of the window. This can vary significantly, for example to
reflect the addition of decorative elements to \fIwindow\fR such as title
bars, and window managers are not required to precisely follow the requests
made through this command.
.RE
.TP
\fBwm grid \fIwindow\fR ?\fIbaseWidth baseHeight widthInc heightInc\fR?
.
This command indicates that \fIwindow\fR is to be managed as a
gridded window.
It also specifies the relationship between grid units and pixel units.
\fIBaseWidth\fR and \fIbaseHeight\fR specify the number of grid
units corresponding to the pixel dimensions requested internally
by \fIwindow\fR using \fBTk_GeometryRequest\fR.  \fIWidthInc\fR
and \fIheightInc\fR specify the number of pixels in each horizontal
and vertical grid unit.
These four values determine a range of acceptable sizes for
\fIwindow\fR, corresponding to grid-based widths and heights
that are non-negative integers.
Tk will pass this information to the window manager;  during
manual resizing, the window manager will restrict the window's size
to one of these acceptable sizes.
.RS
.PP
Furthermore, during manual resizing the window manager will display
the window's current size in terms of grid units rather than pixels.
If \fIbaseWidth\fR etc. are all specified as empty strings, then
\fIwindow\fR will no longer be managed as a gridded window.  If
\fIbaseWidth\fR etc. are specified then the return value is an
empty string.
.PP
Otherwise the return value is a Tcl list containing
four elements corresponding to the current \fIbaseWidth\fR,
\fIbaseHeight\fR, \fIwidthInc\fR, and \fIheightInc\fR;  if
\fIwindow\fR is not currently gridded, then an empty string
is returned.
.PP
Note: this command should not be needed very often, since the
\fBTk_SetGrid\fR library procedure and the \fBsetGrid\fR option
provide easier access to the same functionality.
.RE
.TP
\fBwm group \fIwindow\fR ?\fIpathName\fR?
.
If \fIpathName\fR is specified, it gives the path name for the leader of
a group of related windows.  The window manager may use this information,
for example, to unmap all of the windows in a group when the group's
leader is iconified.  \fIPathName\fR may be specified as an empty string to
remove \fIwindow\fR from any group association.  If \fIpathName\fR is
specified then the command returns an empty string;  otherwise it
returns the path name of \fIwindow\fR's current group leader, or an empty
string if \fIwindow\fR is not part of any group.
.TP
\fBwm iconbitmap \fIwindow\fR ?\fIbitmap\fR?
.
If \fIbitmap\fR is specified, then it names a bitmap in the standard
forms accepted by Tk (see the \fBTk_GetBitmap\fR manual entry for details).
This bitmap is passed to the window manager to be displayed in
\fIwindow\fR's icon, and the command returns an empty string.  If
an empty string is specified for \fIbitmap\fR, then any current icon
bitmap is cancelled for \fIwindow\fR.
If \fIbitmap\fR is specified then the command returns an empty string.
Otherwise it returns the name of
the current icon bitmap associated with \fIwindow\fR, or an empty
string if \fIwindow\fR has no icon bitmap.  On the Windows operating
system, an additional flag is supported:
.RS
.TP
\fBwm iconbitmap \fIwindow\fR ?\fB\-default\fR? ?\fIimage\fR?
.
If the \fB\-default\fR
flag is given, the icon is applied to all toplevel windows (existing
and future) to which no other specific icon has yet been applied.
In addition to bitmap image types, a full path specification to
any file which contains a valid
Windows icon is also accepted (usually .ico or .icr files), or any
file for which the shell has assigned an icon.  Tcl will
first test if the file contains an icon, then if it has an assigned
icon, and finally, if that fails, test for
a bitmap.
.RE
.TP
\fBwm iconify \fIwindow\fR
.
Arrange for \fIwindow\fR to be iconified.  It \fIwindow\fR has not
yet been mapped for the first time, this command will arrange for
it to appear in the iconified state when it is eventually mapped.
.TP
\fBwm iconmask \fIwindow\fR ?\fIbitmap\fR?
.
If \fIbitmap\fR is specified, then it names a bitmap in the standard
forms accepted by Tk (see the \fBTk_GetBitmap\fR manual entry for details).
This bitmap is passed to the window manager to be used as a mask
in conjunction with the \fBiconbitmap\fR option:  where the mask
has zeroes no icon will be displayed;  where it has ones, the bits
from the icon bitmap will be displayed.  If
an empty string is specified for \fIbitmap\fR then any current icon
mask is cancelled for \fIwindow\fR (this is equivalent to specifying
a bitmap of all ones).  If \fIbitmap\fR is specified
then the command returns an empty string.  Otherwise it
returns the name of the current icon mask associated with
\fIwindow\fR, or an empty string if no mask is in effect.
.TP
\fBwm iconname \fIwindow\fR ?\fInewName\fR?
.
If \fInewName\fR is specified, then it is passed to the window
manager;  the window manager should display \fInewName\fR inside
the icon associated with \fIwindow\fR.  In this case an empty
string is returned as result.  If \fInewName\fR is not specified
then the command returns the current icon name for \fIwindow\fR,
or an empty string if no icon name has been specified (in this
case the window manager will normally display the window's title,
as specified with the \fBwm title\fR command).
.TP
\fBwm iconphoto \fIwindow\fR ?\fB\-default\fR? \fIimage1\fR ?\fIimage2 ...\fR?
.
Sets the titlebar icon for \fIwindow\fR based on the named photo images.
If \fB\-default\fR is specified, this is applied to all future created
toplevels as well.  The data in the images is taken as a snapshot at the
time of invocation.  If the images are later changed, this is not
reflected to the titlebar icons.  Multiple images are accepted to allow
different images sizes (e.g., 16x16 and 32x32) to be provided. The window
manager may scale provided icons to an appropriate size.
.RS
.PP
On Windows, the images are packed into a Windows icon structure.
This will override an ico specified to \fBwm iconbitmap\fR, and
vice versa.
.PP
On X, the images are arranged into the _NET_WM_ICON X property, which
most modern window managers support.  A \fBwm iconbitmap\fR may exist
simultaneously.  It is recommended to use not more than 2 icons, placing
the larger icon first.
.PP
On Macintosh, the first image called is loaded into an OSX-native icon
format, and becomes the application icon in dialogs, the Dock, and
other contexts. At the
script level the command will accept only the first image passed in the
parameters as support for multiple sizes/resolutions on macOS is outside Tk's
scope. Developers should use the largest icon they can support
(preferably 512 pixels) to ensure smooth rendering on the Mac. 
.RE
.TP
\fBwm iconposition \fIwindow\fR ?\fIx y\fR?
.
If \fIx\fR and \fIy\fR are specified, they are passed to the window
manager as a hint about where to position the icon for \fIwindow\fR.
In this case an empty string is returned.  If \fIx\fR and \fIy\fR are
specified as empty strings then any existing icon position hint is cancelled.
If neither \fIx\fR nor \fIy\fR is specified, then the command returns
a Tcl list containing two values, which are the current icon position
hints (if no hints are in effect then an empty string is returned).
.TP
\fBwm iconwindow \fIwindow\fR ?\fIpathName\fR?
.
If \fIpathName\fR is specified, it is the path name for a window to
use as icon for \fIwindow\fR: when \fIwindow\fR is iconified then
\fIpathName\fR will be mapped to serve as icon, and when \fIwindow\fR
is de-iconified then \fIpathName\fR will be unmapped again.  If
\fIpathName\fR is specified as an empty string then any existing
icon window association for \fIwindow\fR will be cancelled.  If
the \fIpathName\fR argument is specified then an empty string is
returned.  Otherwise the command returns the path name of the
current icon window for \fIwindow\fR, or an empty string if there
is no icon window currently specified for \fIwindow\fR.
Button press events are disabled for \fIwindow\fR as long as it is
an icon window;  this is needed in order to allow window managers to
.QW own
those events.
Note: not all window managers support the notion of an icon window.
.TP
\fBwm manage \fIwidget\fR
.
The \fIwidget\fR specified will become a stand alone top-level window.  The
window will be decorated with the window managers title bar, etc. Only
\fIframe\fR, \fIlabelframe\fR and \fItoplevel\fR widgets can be used
with this command. Attempting to pass any other widget type will raise
an error. Attempting to manage a \fItoplevel\fR widget is benign and
achieves nothing. See also \fBGEOMETRY MANAGEMENT\fR.
.TP
\fBwm maxsize \fIwindow\fR ?\fIwidth height\fR?
.
If \fIwidth\fR and \fIheight\fR are specified, they give
the maximum permissible dimensions for \fIwindow\fR.
For gridded windows the dimensions are specified in
grid units;  otherwise they are specified in pixel units.
The window manager will restrict the window's dimensions to be
less than or equal to \fIwidth\fR and \fIheight\fR.
If \fIwidth\fR and \fIheight\fR are
specified, then the command returns an empty string.  Otherwise
it returns a Tcl list with two elements, which are the
maximum width and height currently in effect.
The maximum size defaults to the size of the screen.
See the sections on geometry management below for more information.
.TP
\fBwm minsize \fIwindow\fR ?\fIwidth height\fR?
.
If \fIwidth\fR and \fIheight\fR are specified, they give the
minimum permissible dimensions for \fIwindow\fR.
For gridded windows the dimensions are specified in
grid units;  otherwise they are specified in pixel units.
The window manager will restrict the window's dimensions to be
greater than or equal to \fIwidth\fR and \fIheight\fR.
If \fIwidth\fR and \fIheight\fR are
specified, then the command returns an empty string.  Otherwise
it returns a Tcl list with two elements, which are the
minimum width and height currently in effect.
The minimum size defaults to one pixel in each dimension.
See the sections on geometry management below for more information.
.TP
\fBwm overrideredirect \fIwindow\fR ?\fIboolean\fR?
.
If \fIboolean\fR is specified, it must have a proper boolean form and
the override-redirect flag for \fIwindow\fR is set to that value.
If \fIboolean\fR is not specified then \fB1\fR or \fB0\fR is
returned to indicate whether or not the override-redirect flag
is currently set for \fIwindow\fR.
Setting the override-redirect flag for a window causes
it to be ignored by the window manager;  among other things, this means
that the window will not be reparented from the root window into a
decorative frame and the user will not be able to manipulate the
window using the normal window manager mechanisms.
.RS
.PP
Note that the override-redirect flag is only guaranteed to be taken notice of
when the window is first mapped or when mapped after the state is changed from
withdrawn to normal. Some, but not all, platforms will take notice at
additional times.
.RE
.TP
\fBwm positionfrom \fIwindow\fR ?\fIwho\fR?
.
If \fIwho\fR is specified, it must be either \fBprogram\fR or
\fBuser\fR, or an abbreviation of one of these two.  It indicates
whether \fIwindow\fR's current position was requested by the
program or by the user.  Many window managers ignore program-requested
initial positions and ask the user to manually position the window;  if
\fBuser\fR is specified then the window manager should position the
window at the given place without asking the user for assistance.
If \fIwho\fR is specified as an empty string, then the current position
source is cancelled.
If \fIwho\fR is specified, then the command returns an empty string.
Otherwise it returns \fBuser\fR or \fBprogram\fR to indicate the
source of the window's current position, or an empty string if
no source has been specified yet.  Most window managers interpret
.QW "no source"
as equivalent to \fBprogram\fR.
Tk will automatically set the position source to \fBuser\fR
when a \fBwm geometry\fR command is invoked, unless the source has
been set explicitly to \fBprogram\fR.
.TP
\fBwm protocol \fIwindow\fR ?\fIname\fR? ?\fIcommand\fR?
.
This command is used to manage window manager protocols such as
\fBWM_DELETE_WINDOW\fR.
\fIName\fR is the name of an atom corresponding to a window manager
protocol, such as \fBWM_DELETE_WINDOW\fR or \fBWM_SAVE_YOURSELF\fR
or \fBWM_TAKE_FOCUS\fR.
If both \fIname\fR and \fIcommand\fR are specified, then \fIcommand\fR
is associated with the protocol specified by \fIname\fR.
\fIName\fR will be added to \fIwindow\fR's \fBWM_PROTOCOLS\fR
property to tell the window manager that the application has a
protocol handler for \fIname\fR, and \fIcommand\fR will
be invoked in the future whenever the window manager sends a
message to the client for that protocol.
In this case the command returns an empty string.
If \fIname\fR is specified but \fIcommand\fR is not, then the current
command for \fIname\fR is returned, or an empty string if there
is no handler defined for \fIname\fR.
If \fIcommand\fR is specified as an empty string then the current
handler for \fIname\fR is deleted and it is removed from the
\fBWM_PROTOCOLS\fR property on \fIwindow\fR;  an empty string is
returned.
Lastly, if neither \fIname\fR nor \fIcommand\fR is specified, the
command returns a list of all the protocols for which handlers
are currently defined for \fIwindow\fR.
.RS
.PP
Tk always defines a protocol handler for \fBWM_DELETE_WINDOW\fR, even if
you have not asked for one with \fBwm protocol\fR.
If a \fBWM_DELETE_WINDOW\fR message arrives when you have not defined
a handler, then Tk handles the message by destroying the window for
which it was received.
.RE
.TP
\fBwm resizable \fIwindow\fR ?\fIwidth height\fR?
.
This command controls whether or not the user may interactively
resize a top-level window.  If \fIwidth\fR and \fIheight\fR are
specified, they are boolean values that determine whether the
width and height of \fIwindow\fR may be modified by the user.
In this case the command returns an empty string.
If \fIwidth\fR and \fIheight\fR are omitted then the command
returns a list with two 0/1 elements that indicate whether the
width and height of \fIwindow\fR are currently resizable.
By default, windows are resizable in both dimensions.
If resizing is disabled, then the window's size will be the size
from the most recent interactive resize or \fBwm geometry\fR
command.  If there has been no such operation then
the window's natural size will be used.
.TP
\fBwm sizefrom \fIwindow\fR ?\fIwho\fR?
.
If \fIwho\fR is specified, it must be either \fBprogram\fR or
\fBuser\fR, or an abbreviation of one of these two.  It indicates
whether \fIwindow\fR's current size was requested by the
program or by the user.  Some window managers ignore program-requested
sizes and ask the user to manually size the window;  if
\fBuser\fR is specified then the window manager should give the
window its specified size without asking the user for assistance.
If \fIwho\fR is specified as an empty string, then the current size
source is cancelled.
If \fIwho\fR is specified, then the command returns an empty string.
Otherwise it returns \fBuser\fR or \fBwindow\fR to indicate the
source of the window's current size, or an empty string if
no source has been specified yet.  Most window managers interpret
.QW "no source"
as equivalent to \fBprogram\fR.
.TP
\fBwm stackorder \fIwindow\fR ?\fBisabove\fR|\fBisbelow \fIwindow\fR?
.
The \fBstackorder\fR command returns a list of toplevel windows
in stacking order, from lowest to highest. When a single toplevel
window is passed, the returned list recursively includes all of the
window's children that are toplevels. Only those toplevels
that are currently mapped to the screen are returned.
The \fBstackorder\fR command can also be used to determine if one
toplevel is positioned above or below a second toplevel.
When two window arguments separated by either \fBisabove\fR or
\fBisbelow\fR are passed, a boolean result indicates whether
or not the first window is currently above or below the second
window in the stacking order.
.TP
\fBwm state \fIwindow\fR ?newstate?
.
If \fInewstate\fR is specified, the window will be set to the new state,
otherwise it returns the current state of \fIwindow\fR: either
\fBnormal\fR, \fBiconic\fR, \fBwithdrawn\fR, \fBicon\fR, or (Windows and Mac
OS X only) \fBzoomed\fR.
The difference between \fBiconic\fR and \fBicon\fR is that
\fBiconic\fR refers to a window that has been iconified (e.g., with the
\fBwm iconify\fR command) while \fBicon\fR refers to a window whose only
purpose is to serve as the icon for some other window (via the \fBwm
iconwindow\fR command).  The \fBicon\fR state cannot be set.
.TP
\fBwm title \fIwindow\fR ?\fIstring\fR?
.
If \fIstring\fR is specified, then it will be passed to the window
manager for use as the title for \fIwindow\fR (the window manager
should display this string in \fIwindow\fR's title bar).  In this
case the command returns an empty string.  If \fIstring\fR is not
specified then the command returns the current title for the
\fIwindow\fR.  The title for a window defaults to its name.
.TP
\fBwm transient \fIwindow\fR ?\fImaster\fR?
.
If \fImaster\fR is specified, then the window manager is informed
that \fIwindow\fR is a transient window (e.g. pull-down menu) working
on behalf of \fImaster\fR (where \fImaster\fR is the
path name for a top-level window).  If \fImaster\fR
is specified as an empty string then \fIwindow\fR is marked as not
being a transient window any more.  Otherwise the command
returns the path name of \fIwindow\fR's current master, or an
empty string if \fIwindow\fR is not currently a transient window.
A transient window will mirror state changes in the master and
inherit the state of the master when initially mapped. It is an
error to attempt to make a window a transient of itself.
The window manager may also decorate a transient window differently, removing
some features normally present (e.g., minimize and maximize buttons) though
this is entirely at the discretion of the window manager.
.TP
\fBwm withdraw \fIwindow\fR
.
Arranges for \fIwindow\fR to be withdrawn from the screen.  This
causes the window to be unmapped and forgotten about by the window
manager.  If the window
has never been mapped, then this command
causes the window to be mapped in the withdrawn state.  Not all
window managers appear to know how to handle windows that are
mapped in the withdrawn state.
Note: it sometimes seems to be necessary to withdraw a
window and then re-map it (e.g. with \fBwm deiconify\fR) to get some
window managers to pay attention to changes in window attributes
such as group.
.SH "GEOMETRY MANAGEMENT"
.PP
By default a top-level window appears on the screen in its
\fInatural size\fR, which is the one determined internally by its
widgets and geometry managers.
If the natural size of a top-level window changes, then the window's size
changes to match.
A top-level window can be given a size other than its natural size in two ways.
First, the user can resize the window manually using the facilities
of the window manager, such as resize handles.
Second, the application can request a particular size for a
top-level window using the \fBwm geometry\fR command.
These two cases are handled identically by Tk;  in either case,
the requested size overrides the natural size.
You can return the window to its natural by invoking \fBwm geometry\fR
with an empty \fIgeometry\fR string.
.PP
Normally a top-level window can have any size from one pixel in each
dimension up to the size of its screen.
However, you can use the \fBwm minsize\fR and \fBwm maxsize\fR commands
to limit the range of allowable sizes.
The range set by \fBwm minsize\fR and \fBwm maxsize\fR applies to
all forms of resizing, including the window's natural size as
well as manual resizes and the \fBwm geometry\fR command.
You can also use the command \fBwm resizable\fR to completely
disable interactive resizing in one or both dimensions.
.PP
The \fBwm manage\fR and \fBwm forget\fR commands may be used to
perform undocking and docking of windows.  After a widget is managed
by \fBwm manage\fR command, all other \fBwm\fR subcommands may be used
with the widget.  Only widgets created using the toplevel command may
have an attached menu via the \fB\-menu\fR configure option.  A toplevel
widget may be used as a frame and managed with any of the other
geometry managers after using the \fBwm forget\fR command.  Any menu
associated with a toplevel widget will be hidden when managed by
another geometry managers.  The menus will reappear once the window is
managed by \fBwm\fR.  All custom bindtags for widgets in a subtree
that have their top-level widget changed via a \fBwm manage\fR or
\fBwm forget\fR command, must be redone to adjust any top-level widget
path in the bindtags. Bindtags that have not been customized do not
have to be redone.
.SH "GRIDDED GEOMETRY MANAGEMENT"
.PP
Gridded geometry management occurs when one of the widgets of an
application supports a range of useful sizes.
This occurs, for example, in a text editor where the scrollbars,
menus, and other adornments are fixed in size but the edit widget
can support any number of lines of text or characters per line.
In this case, it is usually desirable to let the user specify the
number of lines or characters-per-line, either with the
\fBwm geometry\fR command or by interactively resizing the window.
In the case of text, and in other interesting cases also, only
discrete sizes of the window make sense, such as integral numbers
of lines and characters-per-line;  arbitrary pixel sizes are not useful.
.PP
Gridded geometry management provides support for this kind of
application.
Tk (and the window manager) assume that there is a grid of some
sort within the application and that the application should be
resized in terms of \fIgrid units\fR rather than pixels.
Gridded geometry management is typically invoked by turning on
the \fBsetGrid\fR option for a widget;  it can also be invoked
with the \fBwm grid\fR command or by calling \fBTk_SetGrid\fR.
In each of these approaches the particular widget (or sometimes
code in the application as a whole) specifies the relationship between
integral grid sizes for the window and pixel sizes.
To return to non-gridded geometry management, invoke
\fBwm grid\fR with empty argument strings.
.PP
When gridded geometry management is enabled then all the dimensions specified
in \fBwm minsize\fR, \fBwm maxsize\fR, and \fBwm geometry\fR commands
are treated as grid units rather than pixel units.
Interactive resizing is also carried out in even numbers of grid units
rather than pixels.
.SH BUGS
.PP
Most existing window managers appear to have bugs that affect the
operation of the \fBwm\fR command.  For example, some changes will not
take effect if the window is already active:  the window will have
to be withdrawn and de-iconified in order to make the change happen.
.SH EXAMPLES
.PP
A fixed-size window that says that it is fixed-size too:
.CS
toplevel .fixed
\fBwm title\fR     .fixed "Fixed-size Window"
\fBwm resizable\fR .fixed 0 0
.CE
.PP
A simple dialog-like window, centred on the screen:
.CS
# Create and arrange the dialog contents.
toplevel .msg
label  .msg.l  \-text "This is a very simple dialog demo."
button .msg.ok \-text OK \-default active \-command {destroy .msg}
pack .msg.ok \-side bottom \-fill x
pack .msg.l  \-expand 1    \-fill both

# Now set the widget up as a centred dialog.

# But first, we need the geometry managers to finish setting
# up the interior of the dialog, for which we need to run the
# event loop with the widget hidden completely...
\fBwm withdraw\fR .msg
update
set x [expr {([winfo screenwidth .]\-[winfo width .msg])/2}]
set y [expr {([winfo screenheight .]\-[winfo height .msg])/2}]
\fBwm geometry\fR  .msg +$x+$y
\fBwm transient\fR .msg .
\fBwm title\fR     .msg "Dialog demo"
\fBwm deiconify\fR .msg
.CE
.SH "SEE ALSO"
toplevel(n), winfo(n)
.SH KEYWORDS
aspect ratio, deiconify, focus model, geometry, grid, group, icon, iconify, increments, position, size, title, top-level window, units, window manager
'\" Local Variables:
'\" mode: nroff
'\" End:
