/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;
import org.traccar.protocol.T800xProtocolDecoder;

public class T800xProtocolEncoder
extends BaseProtocolEncoder {
    public static final int MODE_SETTING = 1;
    public static final int MODE_BROADCAST = 2;
    public static final int MODE_FORWARD = 3;

    public T800xProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(Command command, short header, String content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort((int)header);
        buf.writeByte(129);
        buf.writeShort(16 + content.length());
        buf.writeShort(1);
        buf.writeBytes(DataConverter.parseHex("0" + this.getUniqueId(command.getDeviceId())));
        buf.writeByte(1);
        buf.writeBytes(content.getBytes(StandardCharsets.US_ASCII));
        return buf;
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        short header = 8995;
        if (channel != null) {
            header = ((T800xProtocolDecoder)channel.pipeline().get(T800xProtocolDecoder.class)).getHeader();
        }
        switch (command.getType()) {
            case "custom": {
                return this.encodeContent(command, header, command.getString("data"));
            }
        }
        return null;
    }
}

