/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class TechTltProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_STATUS = new PatternBuilder().number("(d+),").text("INFOGPRS,").number("V Bat=(d+.d),").number("TEMP=(d+),").expression("[^,]*,").number("(d+)").compile();
    private static final Pattern PATTERN_POSITION = new PatternBuilder().number("(d+)").text("*POS=Y,").number("(dd):(dd):(dd),").number("(dd)/(dd)/(dd),").number("(dd)(dd.d+)").expression("([NS]),").number("(ddd)(dd.d+)").expression("([EW]),").number("(d+.d+),").number("(d+.d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(d+)").compile();

    public TechTltProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeStatus(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_STATUS, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("battery", parser.nextDouble());
        position.set("deviceTemp", parser.nextInt());
        position.set("rssi", parser.nextInt());
        return position;
    }

    private Position decodeLocation(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_POSITION, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        position.setAltitude(parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.setNetwork(new Network(CellTower.fromLacCid(parser.nextInt(), parser.nextInt().intValue())));
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = ((String)msg).trim();
        if (sentence.contains("INFO")) {
            return this.decodeStatus(channel, remoteAddress, sentence);
        }
        if (sentence.contains("POS")) {
            return this.decodeLocation(channel, remoteAddress, sentence);
        }
        return null;
    }
}

