(new-figure "tiling")
(lets Point "A" free -9 7)
(lets Point "B" free -9 -7)
(lets Numeric "N" free 0 -3 .5)
(define (equilateral A B)
  (let ((C1 (Circle "" 2points B A))
        (C2 (Circle "" 2points A B)))
        (send C1 masked)
        (send C2 masked)
        (Point "" intersection C1 C2)))
(define (half-hexagon A B)
  (let* ((M (Point "" middle-2pts A B))
         (R (equilateral A M))
         (S (equilateral M B)))
       (send M masked)
       (send R masked)
       (send S masked)
       (Segment "" extremities A R)
       (Segment "" extremities R S)
       (Segment "" extremities S B)
       (Segment "" extremities B A)
       (list A B S R))) 


(define (newpoints A B C D)
 (let ((M (Point "" middle-2pts A B)))
      (send M masked)
      (list (Point "A1" scale A M N)
            (Point "B1" scale B M N)
            (Point "C1" scale C M N)
            (Point "D1" scale D M N))))
            
(define (substitute A B C D level levelcolor)
    (let* ((l (newpoints A B C D))
           (A1 (car l))
           (B1 (cadr l))
           (C1 (caddr l))
           (D1 (cadddr l))
           (S1 (Segment "" extremities D D1 ))
           (S2 (Segment "" extremities D1 C1))
           (S3 (Segment "" extremities C1 C ))
           (S4 (Segment "" extremities A1 D1))
           (S5 (Segment "" extremities B1 C1)))
        (send A1 masked)
        (send B1 masked)
        (send C1 masked)
        (send D1 masked)
        (send S1 color levelcolor)
        (send S2 color levelcolor)
        (send S3 color levelcolor)
        (send S4 color levelcolor)
        (send S5 color levelcolor)
        (send S1 thickness 2)
        (send S2 thickness 2)
        (send S3 thickness 2)
        (send S4 thickness 2)
        (send S5 thickness 2)
        (cond
            ((zero? level) #f)
            (else (substitute D A A1 D1   (- level 1) (modulo (+ levelcolor 2) 12))
                  (substitute C D D1 C1   (- level 1) (modulo (+ levelcolor 2) 12))
                  (substitute B C C1 B1   (- level 1) (modulo (+ levelcolor 2) 12))
                  (substitute A1 B1 C1 D1 (- level 1) (modulo (+ levelcolor 2) 12))))))


(define (create n) 
(let*
  ((l (half-hexagon A B))
   (C (caddr l))
   (D (cadddr l)))
  (substitute A B C D n 0)))

(half-hexagon A B)
(new-figure "bla1")
(create 0)
(new-figure "bla2")
(create 1)
(new-figure "bla3")
(create 2)
(new-figure "bla4")
(create 3)
(new-figure "bla5")
(create 4)
