##Life5
#C This pattern was BARGE.LIF in the Hensel archive
#C c/3 spaceship extensible in 2 dimensions
#C Hartmut Holzwart, David Bell
#C Converted to structured format by ESR, Jan 1998
#K p3[c/3o] extensible

#B wing
#P
...*
..*.*
.**
..*
.*.*
.*
*
*.*
*.*
.****
...*.*
...*.*
..*
..***
*
***
.***.*
...*
...*
...**
#E

#B front
#P
**
*..*
*.**
.***
.**
...*
.**
..*.*
...*
#E

#B monomer
#P
..**.*.*.*
.*...*..**
*.....*
.*......*.*
...**..**.*
..*...*
..*.***...*
..*
...********
#E

#B column
#I :dimer 0 0 0 0 0
#I :dimer 0 20 0 0 0
#I :dimer 0 40 0 0 0
#E

#B dimer
#I :monomer 0 0 0 0 0
#I :monomer 0 18 0 -1 0
#E

#C
#C This arrangement is one instance of an infinitely
#C extensible grammar.  The front section (composed of
#C any number of repeated flipped pairs of copies of
#C `front', flanked by copies of `wing') is not cyclic
#C by itself. But when followed by a column of `dimer'
#C instances it is.  The dimer column can be repeated
#C indefinitely.
#C
#I :wing     -32 -50 0 0 0
#I :front    -29 -29 0 0 0
#I :front    -29 -11 0 -1 0
#I :front    -29 -9 0 0 0
#I :front    -29 9 0 -1 0
#I :front    -29 11 0 0 0
#I :front    -29  29 0 -1 0
#I :wing     -32 50 0 -1 0
#I :column   -24 -29 0 0 0
#I :column   -12 -29 0 0 0
#I :column   0 -29 0 0 0
#I :column   12 -29 0 0 0
#I :column   24 -29 0 0 0

## Pattern ends here.
