/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultSymbolExtractorSpec;
import org.gradle.nativeplatform.internal.SymbolExtractorSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class ExtractSymbols
extends DefaultTask {
    private final RegularFileProperty binaryFile;
    private final RegularFileProperty symbolFile;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;

    public ExtractSymbols() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.binaryFile = objectFactory.fileProperty();
        this.symbolFile = objectFactory.fileProperty();
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public RegularFileProperty getBinaryFile() {
        return this.binaryFile;
    }

    @OutputFile
    public RegularFileProperty getSymbolFile() {
        return this.symbolFile;
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @TaskAction
    protected void extractSymbols() {
        BuildOperationLogger operationLogger = ((BuildOperationLoggerFactory)this.getServices().get(BuildOperationLoggerFactory.class)).newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultSymbolExtractorSpec spec = new DefaultSymbolExtractorSpec();
        spec.setBinaryFile(((RegularFile)this.binaryFile.get()).getAsFile());
        spec.setSymbolFile(((RegularFile)this.symbolFile.get()).getAsFile());
        spec.setOperationLogger(operationLogger);
        Compiler<SymbolExtractorSpec> symbolExtractor = this.createCompiler();
        symbolExtractor = BuildOperationLoggingCompilerDecorator.wrap(symbolExtractor);
        WorkResult result = symbolExtractor.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<SymbolExtractorSpec> createCompiler() {
        NativePlatformInternal targetPlatform = (NativePlatformInternal)Cast.cast(NativePlatformInternal.class, (Object)((NativePlatform)this.targetPlatform.get()));
        NativeToolChainInternal toolChain = (NativeToolChainInternal)Cast.cast(NativeToolChainInternal.class, (Object)((NativeToolChain)this.getToolChain().get()));
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(SymbolExtractorSpec.class);
    }
}

