/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptCacheKey;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.internal.Cast;
import org.gradle.internal.hash.HashCode;

public class CrossBuildInMemoryCachingScriptClassCache {
    private final CrossBuildInMemoryCache<ScriptCacheKey, CachedCompiledScript> cachedCompiledScripts;

    public CrossBuildInMemoryCachingScriptClassCache(CrossBuildInMemoryCacheFactory cacheFactory) {
        this.cachedCompiledScripts = cacheFactory.newCache();
    }

    public <T extends Script, M> CompiledScript<T, M> getOrCompile(ScriptSource source, ClassLoaderScope targetScope, CompileOperation<M> operation, Class<T> scriptBaseClass, Action<? super ClassNode> verifier, ScriptClassCompiler delegate) {
        ScriptCacheKey key = new ScriptCacheKey(source.getClassName(), targetScope.getExportClassLoader(), operation.getId());
        CachedCompiledScript cached = (CachedCompiledScript)this.cachedCompiledScripts.get((Object)key);
        HashCode hash = source.getResource().getContentHash();
        if (cached != null && hash.equals((Object)cached.hash)) {
            cached.compiledScript.onReuse();
            return (CompiledScript)Cast.uncheckedCast((Object)cached.compiledScript);
        }
        CompiledScript<T, M> compiledScript = delegate.compile(source, targetScope, operation, scriptBaseClass, verifier);
        this.cachedCompiledScripts.put((Object)key, (Object)new CachedCompiledScript(hash, compiledScript));
        return compiledScript;
    }

    private static class CachedCompiledScript {
        private final HashCode hash;
        private final CompiledScript<?, ?> compiledScript;

        private CachedCompiledScript(HashCode hash, CompiledScript<?, ?> compiledScript) {
            this.hash = hash;
            this.compiledScript = compiledScript;
        }
    }
}

