/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;

public class JvmLibraryProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public JvmLibraryProjectInitDescriptor(Description description, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(description, libraryVersionProvider, documentationRegistry);
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        this.applyLibraryPlugin(buildScriptBuilder);
        buildScriptBuilder.dependency("api", "This dependency is exported to consumers, that is to say found on their compile classpath.", "org.apache.commons:commons-math3:" + this.libraryVersionProvider.getVersion("commons-math"));
        buildScriptBuilder.implementationDependency("This dependency is used internally, and not exposed to consumers on their own compile classpath.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }

    @Override
    protected void sourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory, List<String> templates) {
        templates.add("Library");
    }

    @Override
    protected void testSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory, List<String> templates) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                templates.add("groovy/LibraryTest");
                break;
            }
            case TESTNG: {
                templates.add("testng/LibraryTest");
                break;
            }
            case JUNIT: 
            case KOTLINTEST: {
                templates.add("LibraryTest");
                break;
            }
            case JUNIT_JUPITER: {
                templates.add("junitjupiter/LibraryTest");
                break;
            }
            case SCALATEST: {
                templates.add("LibrarySuite");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

