/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.modifiers.Names;
import org.gradle.buildinit.plugins.internal.modifiers.WithIdentifier;
import org.gradle.internal.logging.text.TreeFormatter;

public enum BuildInitDsl implements WithIdentifier
{
    GROOVY(".gradle"),
    KOTLIN(".gradle.kts");

    private final String fileExtension;

    private BuildInitDsl(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public static BuildInitDsl fromName(@Nullable String name) {
        if (name == null) {
            return GROOVY;
        }
        for (BuildInitDsl language : BuildInitDsl.values()) {
            if (!language.getId().equals(name)) continue;
            return language;
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("The requested build script DSL '" + name + "' is not supported. Supported DSLs");
        formatter.startChildren();
        for (BuildInitDsl dsl : BuildInitDsl.values()) {
            formatter.node("'" + dsl.getId() + "'");
        }
        formatter.endChildren();
        throw new GradleException(formatter.toString());
    }

    public static List<String> listSupported() {
        ImmutableList.Builder supported = ImmutableList.builder();
        for (BuildInitDsl dsl : BuildInitDsl.values()) {
            supported.add((Object)dsl.getId());
        }
        return supported.build();
    }

    @Override
    public String getId() {
        return Names.idFor(this);
    }

    public String fileNameFor(String fileNameWithoutExtension) {
        return fileNameWithoutExtension + this.fileExtension;
    }

    public String toString() {
        return StringUtils.capitalize((String)this.name().toLowerCase());
    }
}

