/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.modifiers;

import java.util.ArrayList;
import java.util.List;
import org.gradle.buildinit.plugins.internal.modifiers.Names;
import org.gradle.buildinit.plugins.internal.modifiers.WithIdentifier;

public enum BuildInitTestFramework implements WithIdentifier
{
    NONE("none"),
    JUNIT("JUnit 4"),
    TESTNG("TestNG"),
    SPOCK("Spock"),
    KOTLINTEST("kotlin.test"),
    SCALATEST("ScalaTest"),
    JUNIT_JUPITER("JUnit Jupiter");

    private final String displayName;

    public static List<String> listSupported() {
        ArrayList<String> result = new ArrayList<String>();
        for (BuildInitTestFramework testFramework : BuildInitTestFramework.values()) {
            if (testFramework == NONE) continue;
            result.add(testFramework.getId());
        }
        return result;
    }

    private BuildInitTestFramework(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getId() {
        return Names.idFor(this);
    }

    public String toString() {
        return this.displayName;
    }
}

