/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.cache.FileIntegrityViolationException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.InsufficientLockModeException;
import org.gradle.cache.LockOptions;
import org.gradle.cache.LockTimeoutException;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.ProcessMetaDataProvider;
import org.gradle.cache.internal.filelock.DefaultLockStateSerializer;
import org.gradle.cache.internal.filelock.LockFileAccess;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateAccess;
import org.gradle.cache.internal.filelock.LockStateSerializer;
import org.gradle.cache.internal.filelock.Version1LockStateSerializer;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.RandomLongIdGenerator;
import org.gradle.internal.io.ExponentialBackoff;
import org.gradle.internal.io.IOQuery;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockManager
implements FileLockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockManager.class);
    public static final int DEFAULT_LOCK_TIMEOUT = 60000;
    private final Set<File> lockedFiles = new CopyOnWriteArraySet<File>();
    private final ProcessMetaDataProvider metaDataProvider;
    private final int lockTimeoutMs;
    private final IdGenerator<Long> generator;
    private final FileLockContentionHandler fileLockContentionHandler;
    private final int shortTimeoutMs = 10000;

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, FileLockContentionHandler fileLockContentionHandler) {
        this(metaDataProvider, 60000, fileLockContentionHandler);
    }

    public DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs, FileLockContentionHandler fileLockContentionHandler) {
        this(metaDataProvider, lockTimeoutMs, fileLockContentionHandler, (IdGenerator<Long>)new RandomLongIdGenerator());
    }

    DefaultFileLockManager(ProcessMetaDataProvider metaDataProvider, int lockTimeoutMs, FileLockContentionHandler fileLockContentionHandler, IdGenerator<Long> generator) {
        this.metaDataProvider = metaDataProvider;
        this.lockTimeoutMs = lockTimeoutMs;
        this.fileLockContentionHandler = fileLockContentionHandler;
        this.generator = generator;
    }

    @Override
    public FileLock lock(File target, LockOptions options, String targetDisplayName) throws LockTimeoutException {
        return this.lock(target, options, targetDisplayName, "");
    }

    @Override
    public FileLock lock(File target, LockOptions options, String targetDisplayName, String operationDisplayName) {
        return this.lock(target, options, targetDisplayName, operationDisplayName, null);
    }

    @Override
    public FileLock lock(File target, LockOptions options, String targetDisplayName, String operationDisplayName, Action<FileLockReleasedSignal> whenContended) {
        if (options.getMode() == FileLockManager.LockMode.OnDemand) {
            throw new UnsupportedOperationException(String.format("No %s mode lock implementation available.", options));
        }
        File canonicalTarget = FileUtils.canonicalize((File)target);
        if (!this.lockedFiles.add(canonicalTarget)) {
            throw new IllegalStateException(String.format("Cannot lock %s as it has already been locked by this process.", targetDisplayName));
        }
        try {
            int port = this.fileLockContentionHandler.reservePort();
            return new DefaultFileLock(canonicalTarget, options, targetDisplayName, operationDisplayName, port, whenContended);
        }
        catch (Throwable t) {
            this.lockedFiles.remove(canonicalTarget);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    static File determineLockTargetFile(File target) {
        if (target.isDirectory()) {
            return new File(target, target.getName() + ".lock");
        }
        return new File(target.getParentFile(), target.getName() + ".lock");
    }

    private ExponentialBackoff<AwaitableFileLockReleasedSignal> newExponentialBackoff(int shortTimeoutMs) {
        return ExponentialBackoff.of((int)shortTimeoutMs, (TimeUnit)TimeUnit.MILLISECONDS, (ExponentialBackoff.Signal)new AwaitableFileLockReleasedSignal());
    }

    @VisibleForTesting
    static class AwaitableFileLockReleasedSignal
    implements FileLockReleasedSignal,
    ExponentialBackoff.Signal {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private int waiting;

        AwaitableFileLockReleasedSignal() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(long millis) throws InterruptedException {
            this.lock.lock();
            try {
                ++this.waiting;
                boolean bl = this.condition.await(millis, TimeUnit.MILLISECONDS);
                return bl;
            }
            finally {
                --this.waiting;
                this.lock.unlock();
            }
        }

        @Override
        public void trigger() {
            this.lock.lock();
            try {
                if (this.waiting > 0) {
                    this.condition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @VisibleForTesting
        boolean isWaiting() {
            this.lock.lock();
            try {
                boolean bl = this.waiting > 0;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class DefaultFileLock
    extends AbstractFileAccess
    implements FileLock {
        private final File lockFile;
        private final File target;
        private final FileLockManager.LockMode mode;
        private final String displayName;
        private final String operationDisplayName;
        private java.nio.channels.FileLock lock;
        private LockFileAccess lockFileAccess;
        private LockState lockState;
        private int port;
        private final long lockId;

        public DefaultFileLock(File target, LockOptions options, String displayName, String operationDisplayName, int port, Action<FileLockReleasedSignal> whenContended) throws Throwable {
            this.port = port;
            this.lockId = (Long)DefaultFileLockManager.this.generator.generateId();
            if (options.getMode() == FileLockManager.LockMode.OnDemand) {
                throw new UnsupportedOperationException("Locking mode OnDemand is not supported.");
            }
            this.target = target;
            this.displayName = displayName;
            this.operationDisplayName = operationDisplayName;
            this.lockFile = DefaultFileLockManager.determineLockTargetFile(target);
            GFileUtils.mkdirs((File)this.lockFile.getParentFile());
            try {
                this.lockFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.info("Couldn't create lock file for {}", (Object)this.lockFile);
                throw e;
            }
            LockStateSerializer stateProtocol = options.isUseCrossVersionImplementation() ? new Version1LockStateSerializer() : new DefaultLockStateSerializer();
            this.lockFileAccess = new LockFileAccess(this.lockFile, new LockStateAccess(stateProtocol));
            try {
                if (whenContended != null) {
                    DefaultFileLockManager.this.fileLockContentionHandler.start(this.lockId, whenContended);
                }
                this.lockState = this.lock(options.getMode());
            }
            catch (Throwable t) {
                this.lockFileAccess.close();
                throw t;
            }
            this.mode = this.lock.isShared() ? FileLockManager.LockMode.Shared : FileLockManager.LockMode.Exclusive;
        }

        @Override
        public boolean isLockFile(File file) {
            return file.equals(this.lockFile);
        }

        @Override
        public boolean getUnlockedCleanly() {
            this.assertOpen();
            return !this.lockState.isDirty();
        }

        @Override
        public FileLock.State getState() {
            this.assertOpen();
            return this.lockState;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            return (T)action.create();
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException, FileIntegrityViolationException {
            this.assertOpenAndIntegral();
            this.doWriteAction(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            this.assertOpen();
            this.doWriteAction(action);
        }

        private void doWriteAction(Runnable action) {
            if (this.mode != FileLockManager.LockMode.Exclusive) {
                throw new InsufficientLockModeException("An exclusive lock is required for this operation");
            }
            try {
                this.lockState = this.lockFileAccess.markDirty(this.lockState);
                action.run();
                this.lockState = this.lockFileAccess.markClean(this.lockState);
            }
            catch (Throwable t) {
                throw UncheckedException.throwAsUncheckedException((Throwable)t);
            }
        }

        private void assertOpen() {
            if (this.lock == null) {
                throw new IllegalStateException("This lock has been closed.");
            }
        }

        private void assertOpenAndIntegral() {
            this.assertOpen();
            if (this.lockState.isDirty()) {
                throw new FileIntegrityViolationException(String.format("The file '%s' was not unlocked cleanly", this.target));
            }
        }

        @Override
        public void close() {
            CompositeStoppable stoppable = new CompositeStoppable();
            stoppable.add((Object)new Stoppable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stop() {
                    block11: {
                        if (DefaultFileLock.this.lockFileAccess == null) {
                            return;
                        }
                        try {
                            LOGGER.debug("Releasing lock on {}.", (Object)DefaultFileLock.this.displayName);
                            try {
                                java.nio.channels.FileLock info;
                                if (DefaultFileLock.this.lock == null || DefaultFileLock.this.lock.isShared()) break block11;
                                try {
                                    info = DefaultFileLock.this.lockInformationRegion(FileLockManager.LockMode.Exclusive, (ExponentialBackoff<AwaitableFileLockReleasedSignal>)DefaultFileLockManager.this.newExponentialBackoff(10000));
                                }
                                catch (InterruptedException e) {
                                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                                }
                                if (info == null) break block11;
                                try {
                                    DefaultFileLock.this.lockFileAccess.clearLockInfo();
                                }
                                finally {
                                    info.release();
                                }
                            }
                            finally {
                                DefaultFileLock.this.lockFileAccess.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to release lock on " + DefaultFileLock.this.displayName, e);
                        }
                    }
                }
            });
            stoppable.add((Object)new Stoppable(){

                public void stop() {
                    try {
                        DefaultFileLockManager.this.fileLockContentionHandler.stop(DefaultFileLock.this.lockId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to stop listening for file lock requests for " + DefaultFileLock.this.displayName, e);
                    }
                }
            });
            stoppable.add((Object)new Stoppable(){

                public void stop() {
                    DefaultFileLock.this.lock = null;
                    DefaultFileLock.this.lockFileAccess = null;
                    DefaultFileLockManager.this.lockedFiles.remove(DefaultFileLock.this.target);
                }
            });
            stoppable.stop();
        }

        @Override
        public FileLockManager.LockMode getMode() {
            return this.mode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockState lock(FileLockManager.LockMode lockMode) throws Throwable {
            LOGGER.debug("Waiting to acquire {} lock on {}.", (Object)lockMode.toString().toLowerCase(), (Object)this.displayName);
            java.nio.channels.FileLock stateRegionLock = this.lockStateRegion(lockMode);
            if (stateRegionLock == null) {
                LockInfo lockInfo = this.readInformationRegion((ExponentialBackoff<AwaitableFileLockReleasedSignal>)DefaultFileLockManager.this.newExponentialBackoff(10000));
                throw new LockTimeoutException(this.displayName, lockInfo.pid, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), lockInfo.operation, this.operationDisplayName, this.lockFile);
            }
            try {
                LockState lockState;
                if (!stateRegionLock.isShared()) {
                    lockState = this.lockFileAccess.ensureLockState();
                    java.nio.channels.FileLock informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, (ExponentialBackoff<AwaitableFileLockReleasedSignal>)DefaultFileLockManager.this.newExponentialBackoff(10000));
                    if (informationRegionLock == null) {
                        throw new IllegalStateException(String.format("Unable to lock the information region for %s", this.displayName));
                    }
                    try {
                        this.lockFileAccess.writeLockInfo(this.port, this.lockId, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), this.operationDisplayName);
                    }
                    finally {
                        informationRegionLock.release();
                    }
                } else {
                    lockState = this.lockFileAccess.readLockState();
                }
                LOGGER.debug("Lock acquired on {}.", (Object)this.displayName);
                this.lock = stateRegionLock;
                return lockState;
            }
            catch (Throwable t) {
                stateRegionLock.release();
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockInfo readInformationRegion(ExponentialBackoff<AwaitableFileLockReleasedSignal> backoff) throws IOException, InterruptedException {
            LockInfo out = new LockInfo();
            java.nio.channels.FileLock informationRegionLock = this.lockInformationRegion(FileLockManager.LockMode.Shared, backoff);
            if (informationRegionLock == null) {
                LOGGER.debug("Could not lock information region for {}. Ignoring.", (Object)this.displayName);
            } else {
                try {
                    out = this.lockFileAccess.readLockInfo();
                }
                finally {
                    informationRegionLock.release();
                }
            }
            return out;
        }

        private java.nio.channels.FileLock lockStateRegion(final FileLockManager.LockMode lockMode) throws IOException, InterruptedException {
            final ExponentialBackoff backoff = DefaultFileLockManager.this.newExponentialBackoff(DefaultFileLockManager.this.lockTimeoutMs);
            return (java.nio.channels.FileLock)backoff.retryUntil((IOQuery)new IOQuery<java.nio.channels.FileLock>(){
                private long lastPingTime;
                private int lastLockHolderPort;

                public java.nio.channels.FileLock run() throws IOException, InterruptedException {
                    java.nio.channels.FileLock fileLock = DefaultFileLock.this.lockFileAccess.tryLockState(lockMode == FileLockManager.LockMode.Shared);
                    if (fileLock != null) {
                        return fileLock;
                    }
                    if (DefaultFileLock.this.port != -1) {
                        LockInfo lockInfo = DefaultFileLock.this.readInformationRegion((ExponentialBackoff<AwaitableFileLockReleasedSignal>)backoff);
                        if (lockInfo.port != -1) {
                            if (lockInfo.port != this.lastLockHolderPort) {
                                backoff.restartTimer();
                                this.lastLockHolderPort = lockInfo.port;
                                this.lastPingTime = 0L;
                            }
                            if (DefaultFileLockManager.this.fileLockContentionHandler.maybePingOwner(lockInfo.port, lockInfo.lockId, DefaultFileLock.this.displayName, backoff.getTimer().getElapsedMillis() - this.lastPingTime, (FileLockReleasedSignal)backoff.getSignal())) {
                                this.lastPingTime = backoff.getTimer().getElapsedMillis();
                                LOGGER.debug("The file lock is held by a different Gradle process (pid: {}, lockId: {}). Pinged owner at port {}", new Object[]{lockInfo.pid, lockInfo.lockId, lockInfo.port});
                            }
                        } else {
                            LOGGER.debug("The file lock is held by a different Gradle process. I was unable to read on which port the owner listens for lock access requests.");
                        }
                    }
                    return null;
                }
            });
        }

        private java.nio.channels.FileLock lockInformationRegion(final FileLockManager.LockMode lockMode, ExponentialBackoff<AwaitableFileLockReleasedSignal> backoff) throws IOException, InterruptedException {
            return (java.nio.channels.FileLock)backoff.retryUntil((IOQuery)new IOQuery<java.nio.channels.FileLock>(){

                public java.nio.channels.FileLock run() throws IOException {
                    return DefaultFileLock.this.lockFileAccess.tryLockInfo(lockMode == FileLockManager.LockMode.Shared);
                }
            });
        }
    }
}

