/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.SortedMap;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.history.changes.DefaultInputFileChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;

public class DefaultIncrementalInputProperties
implements IncrementalInputProperties {
    private final ImmutableBiMap<String, Object> incrementalInputProperties;

    public DefaultIncrementalInputProperties(ImmutableBiMap<String, Object> incrementalInputProperties) {
        this.incrementalInputProperties = incrementalInputProperties;
    }

    @Override
    public String getPropertyNameFor(Object propertyValue) {
        String propertyName = (String)this.incrementalInputProperties.inverse().get(propertyValue);
        if (propertyName == null) {
            throw new InvalidUserDataException("Cannot query incremental changes: No property found for value " + propertyValue + ". Incremental properties: " + Joiner.on((String)", ").join((Iterable)this.incrementalInputProperties.keySet()) + ".");
        }
        return propertyName;
    }

    @Override
    public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        return new DefaultInputFileChanges(Maps.filterKeys(previous, propertyName -> !this.incrementalInputProperties.containsKey(propertyName)), Maps.filterKeys(current, propertyName -> !this.incrementalInputProperties.containsKey(propertyName)));
    }

    @Override
    public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        return new DefaultInputFileChanges((SortedMap<String, FileCollectionFingerprint>)ImmutableSortedMap.copyOfSorted((SortedMap)Maps.filterKeys(previous, propertyName -> this.incrementalInputProperties.containsKey(propertyName))), (SortedMap<String, CurrentFileCollectionFingerprint>)ImmutableSortedMap.copyOfSorted((SortedMap)Maps.filterKeys(current, propertyName -> this.incrementalInputProperties.containsKey(propertyName))));
    }
}

