/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;

public class OutputFilterUtil {
    public static ImmutableList<FileSystemSnapshot> filterOutputSnapshotBeforeExecution(FileCollectionFingerprint afterLastExecutionFingerprint, FileSystemSnapshot beforeExecutionOutputSnapshot) {
        Map fingerprints = afterLastExecutionFingerprint.getFingerprints();
        SnapshotFilteringVisitor filteringVisitor = new SnapshotFilteringVisitor((snapshot, isRoot) -> (isRoot == false || snapshot.getType() != FileType.Missing) && fingerprints.containsKey(snapshot.getAbsolutePath()));
        beforeExecutionOutputSnapshot.accept((FileSystemSnapshotVisitor)filteringVisitor);
        return filteringVisitor.getNewRoots();
    }

    public static ImmutableList<FileSystemSnapshot> filterOutputSnapshotAfterExecution(@Nullable FileCollectionFingerprint afterLastExecutionFingerprint, FileSystemSnapshot beforeExecutionOutputSnapshot, FileSystemSnapshot afterExecutionOutputSnapshot) {
        Map<String, CompleteFileSystemLocationSnapshot> beforeExecutionSnapshots = OutputFilterUtil.getAllSnapshots(beforeExecutionOutputSnapshot);
        if (beforeExecutionSnapshots.isEmpty()) {
            return ImmutableList.of((Object)afterExecutionOutputSnapshot);
        }
        Object afterLastExecutionFingerprints = afterLastExecutionFingerprint != null ? afterLastExecutionFingerprint.getFingerprints() : ImmutableMap.of();
        SnapshotFilteringVisitor filteringVisitor = new SnapshotFilteringVisitor((arg_0, arg_1) -> OutputFilterUtil.lambda$filterOutputSnapshotAfterExecution$1((Map)afterLastExecutionFingerprints, beforeExecutionSnapshots, arg_0, arg_1));
        afterExecutionOutputSnapshot.accept((FileSystemSnapshotVisitor)filteringVisitor);
        if (filteringVisitor.hasBeenFiltered()) {
            return filteringVisitor.getNewRoots();
        }
        return ImmutableList.of((Object)afterExecutionOutputSnapshot);
    }

    private static Map<String, CompleteFileSystemLocationSnapshot> getAllSnapshots(FileSystemSnapshot fingerprint) {
        GetAllSnapshotsVisitor allSnapshotsVisitor = new GetAllSnapshotsVisitor();
        fingerprint.accept((FileSystemSnapshotVisitor)allSnapshotsVisitor);
        return allSnapshotsVisitor.getSnapshots();
    }

    private static boolean isOutputEntry(Map<String, FileSystemLocationFingerprint> afterPreviousExecutionFingerprints, Map<String, CompleteFileSystemLocationSnapshot> beforeExecutionSnapshots, CompleteFileSystemLocationSnapshot afterExecutionSnapshot, Boolean isRoot) {
        CompleteFileSystemLocationSnapshot beforeSnapshot;
        if (isRoot.booleanValue()) {
            switch (afterExecutionSnapshot.getType()) {
                case Missing: {
                    return false;
                }
                case Directory: {
                    return true;
                }
            }
        }
        if ((beforeSnapshot = beforeExecutionSnapshots.get(afterExecutionSnapshot.getAbsolutePath())) == null) {
            return true;
        }
        if (!afterExecutionSnapshot.isContentAndMetadataUpToDate(beforeSnapshot)) {
            return true;
        }
        return afterPreviousExecutionFingerprints.containsKey(afterExecutionSnapshot.getAbsolutePath());
    }

    private static /* synthetic */ boolean lambda$filterOutputSnapshotAfterExecution$1(Map afterLastExecutionFingerprints, Map beforeExecutionSnapshots, CompleteFileSystemLocationSnapshot afterExecutionSnapshot, Boolean isRoot) {
        return OutputFilterUtil.isOutputEntry(afterLastExecutionFingerprints, beforeExecutionSnapshots, afterExecutionSnapshot, isRoot);
    }

    private static class SnapshotFilteringVisitor
    implements FileSystemSnapshotVisitor {
        private final BiPredicate<CompleteFileSystemLocationSnapshot, Boolean> predicate;
        private final ImmutableList.Builder<FileSystemSnapshot> newRootsBuilder = ImmutableList.builder();
        private int treeDepth = 0;
        private boolean hasBeenFiltered;
        private MerkleDirectorySnapshotBuilder merkleBuilder;
        private boolean currentRootFiltered;
        private CompleteDirectorySnapshot currentRoot;

        public SnapshotFilteringVisitor(BiPredicate<CompleteFileSystemLocationSnapshot, Boolean> predicate) {
            this.predicate = predicate;
        }

        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            ++this.treeDepth;
            if (this.merkleBuilder == null) {
                this.merkleBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
                this.currentRoot = directorySnapshot;
                this.currentRootFiltered = false;
            }
            this.merkleBuilder.preVisitDirectory(directorySnapshot);
            return true;
        }

        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            if (!this.predicate.test(fileSnapshot, this.isRoot())) {
                this.hasBeenFiltered = true;
                this.currentRootFiltered = true;
                return;
            }
            if (this.merkleBuilder == null) {
                this.newRootsBuilder.add((Object)fileSnapshot);
            } else {
                this.merkleBuilder.visitFile(fileSnapshot);
            }
        }

        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            --this.treeDepth;
            boolean isOutputDir = this.predicate.test((CompleteFileSystemLocationSnapshot)directorySnapshot, this.isRoot());
            boolean includedDir = this.merkleBuilder.postVisitDirectory(isOutputDir, directorySnapshot.getAccessType());
            if (!includedDir) {
                this.currentRootFiltered = true;
                this.hasBeenFiltered = true;
            }
            if (this.merkleBuilder.isRoot()) {
                CompleteFileSystemLocationSnapshot result = this.merkleBuilder.getResult();
                if (result != null) {
                    this.newRootsBuilder.add(this.currentRootFiltered ? result : this.currentRoot);
                }
                this.merkleBuilder = null;
                this.currentRoot = null;
            }
        }

        private boolean isRoot() {
            return this.treeDepth == 0;
        }

        public ImmutableList<FileSystemSnapshot> getNewRoots() {
            return this.newRootsBuilder.build();
        }

        public boolean hasBeenFiltered() {
            return this.hasBeenFiltered;
        }
    }

    private static class GetAllSnapshotsVisitor
    implements FileSystemSnapshotVisitor {
        private final Map<String, CompleteFileSystemLocationSnapshot> snapshots = new HashMap<String, CompleteFileSystemLocationSnapshot>();

        private GetAllSnapshotsVisitor() {
        }

        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.snapshots.put(directorySnapshot.getAbsolutePath(), (CompleteFileSystemLocationSnapshot)directorySnapshot);
            return true;
        }

        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            this.snapshots.put(fileSnapshot.getAbsolutePath(), fileSnapshot);
        }

        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
        }

        public Map<String, CompleteFileSystemLocationSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }
}

