/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractCollectionProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

public class DefaultListProperty<T>
extends AbstractCollectionProperty<T, List<T>>
implements ListProperty<T> {
    private static final Supplier<ImmutableCollection.Builder<Object>> FACTORY = new Supplier<ImmutableCollection.Builder<Object>>(){

        @Override
        public ImmutableCollection.Builder<Object> get() {
            return ImmutableList.builder();
        }
    };

    public DefaultListProperty(PropertyHost host, Class<T> elementType) {
        super(host, List.class, elementType, (Supplier)Cast.uncheckedNonnullCast(FACTORY));
    }

    @Override
    public Class<?> publicType() {
        return ListProperty.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.ListPropertyManagedFactory.FACTORY_ID;
    }

    @Override
    protected ImmutableList<T> emptyCollection() {
        return ImmutableList.of();
    }

    @Override
    public ListProperty<T> empty() {
        super.empty();
        return this;
    }

    @Override
    public ListProperty<T> value(@Nullable Iterable<? extends T> elements) {
        super.value(elements);
        return this;
    }

    @Override
    public ListProperty<T> value(Provider<? extends Iterable<? extends T>> provider) {
        super.value(provider);
        return this;
    }

    @Override
    public ListProperty<T> convention(Iterable<? extends T> elements) {
        super.convention(elements);
        return this;
    }

    @Override
    public ListProperty<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        super.convention(provider);
        return this;
    }
}

