/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class DefaultExtraPropertiesExtension
extends GroovyObjectSupport
implements ExtraPropertiesExtension {
    private final Map<String, Object> storage = new HashMap<String, Object>();

    public boolean has(String name) {
        return this.storage.containsKey(name);
    }

    @Nullable
    public Object get(String name) {
        Object value = this.find(name);
        if (value == null && !this.has(name)) {
            throw new ExtraPropertiesExtension.UnknownPropertyException((ExtraPropertiesExtension)this, name);
        }
        return value;
    }

    @Nullable
    public Object find(String name) {
        return this.storage.get(name);
    }

    public void set(String name, @Nullable Object value) {
        this.storage.put(name, value);
    }

    @Nullable
    public Object getProperty(String name) {
        if (name.equals("properties")) {
            return this.getProperties();
        }
        if (this.storage.containsKey(name)) {
            return this.storage.get(name);
        }
        throw new MissingPropertyException(ExtraPropertiesExtension.UnknownPropertyException.createMessage((String)name), name, null);
    }

    public void setProperty(String name, @Nullable Object newValue) {
        if (name.equals("properties")) {
            throw new ReadOnlyPropertyException("name", ExtraPropertiesExtension.class);
        }
        this.set(name, newValue);
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.storage);
    }

    public Object methodMissing(String name, Object args) {
        Object item = this.find(name);
        if (item != null && item instanceof Closure) {
            Closure closure = (Closure)item;
            return closure.call((Object[])args);
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), (Object[])args);
    }
}

