/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight.javadoc;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;

public class JavaDocUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.javadoc.JavaDocUtil");
    @NonNls
    private static final Pattern ourTypePattern = Pattern.compile("[ ]+[^ ^\\[^\\]]");

    @Nullable
    public static PsiClass resolveClassInTagValue(@Nullable PsiDocTagValue value2) {
        PsiElement target;
        PsiElement refElement;
        if (value2 == null) {
            return null;
        }
        PsiElement refHolder = value2.getFirstChild();
        if (refHolder != null && (refElement = refHolder.getFirstChild()) instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)refElement).resolve()) instanceof PsiClass) {
            return (PsiClass)target;
        }
        return null;
    }

    public static boolean isInsidePackageInfo(@Nullable PsiDocComment containingComment) {
        return containingComment != null && containingComment.getOwner() == null && containingComment.getParent() instanceof PsiJavaFile;
    }
}

