/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.CodeInsightUtilCore;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.ContributedReferenceHost;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.LiteralTextEscaper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceService;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiLiteralUtil;
import org.jetbrains.kotlin.com.intellij.util.text.LiteralFormatUtil;

public class PsiLiteralExpressionImpl
extends JavaStubPsiElement<PsiLiteralStub>
implements ContributedReferenceHost,
PsiLanguageInjectionHost,
PsiLiteralExpression {
    private static final TokenSet NUMERIC_LITERALS = TokenSet.orSet(ElementType.INTEGER_LITERALS, ElementType.REAL_LITERALS);

    public PsiLiteralExpressionImpl(@NotNull PsiLiteralStub stub) {
        if (stub == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, JavaStubElementTypes.LITERAL_EXPRESSION);
    }

    public PsiLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = ((CompositeElement)this.getNode()).getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public PsiType getType() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (ElementType.STRING_LITERALS.contains(type2)) {
            PsiFile file2 = this.getContainingFile();
            return PsiType.getJavaLangString(file2.getManager(), ResolveScopeManager.getElementResolveScope(file2));
        }
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type2 == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public IElementType getLiteralElementType() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralType();
        }
        return this.getNode().getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        IElementType type2 = this.getLiteralElementType();
        return NUMERIC_LITERALS.contains(type2) ? LiteralFormatUtil.removeUnderscores(this.getText()) : this.getText();
    }

    @Override
    public String getText() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralText();
        }
        return super.getText();
    }

    @Override
    public Object getValue() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type2 == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(this.getInnerText());
        }
        if (type2 == JavaTokenType.TEXT_BLOCK_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(this.getTextBlockText());
        }
        String text2 = NUMERIC_LITERALS.contains(type2) ? StringUtil.toLowerCase(this.getCanonicalText()) : this.getCanonicalText();
        int textLength = text2.length();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiLiteralUtil.parseInteger(text2);
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiLiteralUtil.parseLong(text2);
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiLiteralUtil.parseFloat(text2);
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiLiteralUtil.parseDouble(text2);
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            StringBuilder chars;
            if (textLength == 1 || !StringUtil.endsWithChar(text2, '\'')) {
                return null;
            }
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text2 = text2.substring(1, textLength - 1), chars = new StringBuilder(), null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        return null;
    }

    @Nullable
    public String getInnerText() {
        String text2 = this.getCanonicalText();
        int textLength = text2.length();
        if (textLength > 1 && text2.charAt(0) == '\"' && text2.charAt(textLength - 1) == '\"') {
            return text2.substring(1, textLength - 1);
        }
        if (textLength > "&quot;".length() && text2.startsWith("&quot;") && text2.endsWith("&quot;")) {
            return text2.substring("&quot;".length(), textLength - "&quot;".length());
        }
        return null;
    }

    @Nullable
    public String getTextBlockText() {
        String[] lines = this.getTextBlockLines();
        if (lines == null) {
            return null;
        }
        int prefix = PsiLiteralExpressionImpl.getTextBlockIndent(lines);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 0) {
                sb.append(StringUtil.trimTrailing(line.substring(prefix), ' '));
            }
            if (i >= lines.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public int getTextBlockIndent() {
        String[] lines = this.getTextBlockLines();
        if (lines == null) {
            return -1;
        }
        return PsiLiteralExpressionImpl.getTextBlockIndent(lines);
    }

    private static int getTextBlockIndent(String[] lines) {
        int prefix = Integer.MAX_VALUE;
        for (int i = 0; i < lines.length; ++i) {
            int indent;
            String line = lines[i];
            for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
            }
            if (indent == line.length() && i < lines.length - 1) {
                lines[i] = "";
                continue;
            }
            if (indent >= prefix) continue;
            prefix = indent;
        }
        return prefix;
    }

    private String[] getTextBlockLines() {
        char c;
        String rawText = this.getText();
        if (rawText.length() < 7 || !rawText.endsWith("\"\"\"")) {
            return null;
        }
        int start = 3;
        while ((c = rawText.charAt(start++)) != '\n') {
            if (Character.isWhitespace(c) && start != rawText.length()) continue;
            return null;
        }
        return rawText.substring(start, rawText.length() - 3).split("\n", -1);
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        if (chars == null) {
            return null;
        }
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (outChars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLiteralExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    @Override
    public boolean isValidHost() {
        return ElementType.TEXT_LITERALS.contains(this.getLiteralElementType());
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        IElementType type2 = this.getLiteralElementType();
        PsiReference[] psiReferenceArray = ElementType.STRING_LITERALS.contains(type2) || type2 == JavaTokenType.INTEGER_LITERAL ? PsiReferenceService.getService().getContributedReferences(this) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text2);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        return new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

