/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.impl.FirILTTypeRefPlaceHolder;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperator;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperatorCall;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u0005*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a&\u0010\u0018\u001a\u0004\u0018\u00010\u0005*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u001a\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015\u001a$\u0010\u001b\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001aJ\u0010\u001c\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a`\u0010!\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u001ab\u0010#\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fH\u0002\u001aB\u0010&\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n\u001aZ\u0010'\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u001aX\u0010(\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u001a\u0014\u0010*\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006+"}, d2={"checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "isDispatch", "nullableExpectedType", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "checkApplicabilityForIntegerOperatorCall", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExpectedType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "candidateExpectedType", "prepareCapturedType", "prepareExpectedType", "resolveArgument", "isSafeCall", "typeProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolveArgumentExpression", "expectedTypeRef", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "varargElementType", "resolve"})
public final class ArgumentsKt {
    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @NotNull ConeKotlinType expectedType, @NotNull FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveArgumentExpression, (String)"$this$resolveArgumentExpression");
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)expectedTypeRef, (String)"expectedTypeRef");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        FirExpression firExpression2 = argument;
        if (firExpression2 instanceof FirFunctionCall || firExpression2 instanceof FirWhenExpression || firExpression2 instanceof FirTryExpression || firExpression2 instanceof FirCheckNotNullCall) {
            ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument), expectedType, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
        } else if (firExpression2 instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument($this$resolveArgumentExpression, csBuilder, argument, expectedType, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument, expectedType);
            }
        } else if (firExpression2 instanceof FirQualifiedAccessExpression) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveArgumentExpression, csBuilder, argument, expectedType, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
        } else if (firExpression2 instanceof FirAnonymousFunction) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunction)argument, expectedType, expectedTypeRef, false, 16, null);
        } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument).getExpression(), expectedType, expectedTypeRef, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
        } else if (firExpression2 instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument, expectedType, expectedTypeRef, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
        } else {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveArgumentExpression, csBuilder, argument, expectedType, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void resolveBlockArgument(@NotNull Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType, FirTypeRef expectedTypeRef, CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall, Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            void $this$coneTypeUnsafe$iv;
            FirTypeRef firTypeRef = block.getTypeRef();
            ConstraintSystemBuilder constraintSystemBuilder = csBuilder;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType coneKotlinType2 = coneKotlinType;
            ArgumentsKt.checkApplicabilityForArgumentType(constraintSystemBuilder, coneKotlinType2, expectedType.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, ResolveUtilsKt.withNullability(expectedType.getType(), ConeNullability.NULLABLE, SessionUtilsKt.getInferenceContext(sink.getComponents().getSession())), sink);
            return;
        }
        for (FirExpression argument : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument, expectedType, expectedTypeRef, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument, @NotNull ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        ConeKotlinType coneKotlinType;
        boolean $i$f$coneTypeUnsafe;
        Object $this$coneTypeUnsafe$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveSubCallArgument, (String)"$this$resolveSubCallArgument");
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Candidate candidate2 = CandidateFactoryKt.candidate(argument);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument), expectedType, sink, isReceiver, isDispatch, isSafeCall, typeProvider);
            return;
        }
        Candidate candidate3 = candidate2;
        if (candidate3.getSymbol().getFir() instanceof FirIntegerOperator) {
            FirExpression $this$resultType$iv = (FirFunctionCall)argument;
            boolean $i$f$getResultType = false;
            $this$coneTypeUnsafe$iv = $this$resultType$iv.getTypeRef();
            $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        } else {
            void $this$firUnsafe$iv;
            $this$coneTypeUnsafe$iv = candidate3.getSymbol();
            ReturnTypeCalculator returnTypeCalculator = sink.getComponents().getReturnTypeCalculator();
            boolean $i$f$firUnsafe = false;
            Object fir$iv = $this$firUnsafe$iv.getFir();
            boolean bl = fir$iv instanceof FirTypedDeclaration;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType((FirElement)fir$iv);
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            FirElement firElement = (FirElement)fir$iv;
            $this$coneTypeUnsafe$iv = returnTypeCalculator.tryCalculateReturnType((FirTypedDeclaration)firElement);
            $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        ConeKotlinType type2 = coneKotlinType;
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, argumentType, expectedType, sink, isReceiver, isDispatch, isSafeCall);
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)$this$resolvePlainExpressionArgument, (String)"$this$resolvePlainExpressionArgument");
                Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
                Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
                if (expectedType == null) {
                    return;
                }
                object = (FirTypeRef)typeProvider.invoke((Object)argument);
                if (object == null) break block6;
                FirTypeRef $this$coneTypeSafe$iv = object;
                boolean $i$f$coneTypeSafe = false;
                FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                    firTypeRef = null;
                }
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                Object object2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(object2 instanceof ConeKotlinType)) {
                    object2 = object = null;
                }
                if (object2 != null) break block7;
            }
            return;
        }
        Object argumentType = object;
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, (ConeKotlinType)argumentType, expectedType, sink, isReceiver, isDispatch, isSafeCall);
        ArgumentsKt.checkApplicabilityForIntegerOperatorCall($this$resolvePlainExpressionArgument, sink, argument);
    }

    private static final void checkApplicabilityForIntegerOperatorCall(@NotNull Candidate $this$checkApplicabilityForIntegerOperatorCall, CheckerSink sink, FirExpression argument) {
        if (!($this$checkApplicabilityForIntegerOperatorCall.getSymbol().getFir() instanceof FirIntegerOperator)) {
            return;
        }
        if (!(argument instanceof FirConstExpression) && !(argument instanceof FirIntegerOperatorCall)) {
            sink.reportApplicability(CandidateApplicability.INAPPLICABLE);
        }
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isDispatch, boolean isSafeCall) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolvePlainArgumentType, (String)"$this$resolvePlainArgumentType");
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argumentType, (String)"argumentType");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        FirSession session = sink.getComponents().getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType($this$resolvePlainArgumentType, argumentType, session);
        ConeKotlinType nullableExpectedType = ResolveUtilsKt.withNullability(expectedType, ConeNullability.NULLABLE, SessionUtilsKt.getInferenceContext(session));
        if (isReceiver && isSafeCall) {
            if (!isDispatch && !ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, capturedType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
            return;
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, capturedType, expectedType, position, isReceiver, isDispatch, nullableExpectedType, sink);
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull Candidate $this$prepareCapturedType, @NotNull ConeKotlinType argumentType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkParameterIsNotNull((Object)$this$prepareCapturedType, (String)"$this$prepareCapturedType");
        Intrinsics.checkParameterIsNotNull((Object)argumentType, (String)"argumentType");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = argumentType.getTypeArguments();
        boolean bl = false;
        if (coneKotlinTypeProjectionArray.length == 0 || !(argumentType instanceof ConeClassLikeType)) {
            return argumentType;
        }
        SimpleTypeMarker simpleTypeMarker = $this$prepareCapturedType.getBodyResolveComponents().getInferenceComponents().getCtx().captureFromArguments((SimpleTypeMarker)((Object)argumentType), CaptureStatus.FROM_EXPRESSION);
        if (!(simpleTypeMarker instanceof ConeKotlinType)) {
            simpleTypeMarker = null;
        }
        if ((coneKotlinType = (ConeKotlinType)((Object)simpleTypeMarker)) == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, ConeKotlinType argumentType, ConeKotlinType expectedType, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, boolean isDispatch, ConeKotlinType nullableExpectedType, CheckerSink sink) {
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            if (!isReceiver) {
                if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                    csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                }
                return;
            }
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull FirExpression argument, @NotNull FirValueParameter parameter, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider, @NotNull CheckerSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveArgument, (String)"$this$resolveArgument");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        ConeKotlinType expectedType = ArgumentsKt.prepareExpectedType($this$resolveArgument, sink.getComponents().getSession(), argument, parameter);
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument, expectedType, parameter.getReturnTypeRef(), sink, isReceiver, false, isSafeCall, typeProvider);
    }

    private static final ConeKotlinType prepareExpectedType(@NotNull Candidate $this$prepareExpectedType, FirSession session, FirExpression argument, FirValueParameter parameter) {
        if (parameter.getReturnTypeRef() instanceof FirILTTypeRefPlaceHolder) {
            FirExpression $this$resultType$iv = argument;
            boolean $i$f$getResultType = false;
            FirTypeRef $this$coneTypeUnsafe$iv = $this$resultType$iv.getTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            return coneKotlinType;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedType(argument, session, parameter);
        ConeKotlinType coneKotlinType = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session, argument, basicExpectedType);
        if (coneKotlinType == null) {
            coneKotlinType = basicExpectedType;
        }
        ConeKotlinType expectedType = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(@NotNull Candidate $this$getExpectedTypeWithSAMConversion, FirSession session, FirExpression argument, ConeKotlinType candidateExpectedType) {
        boolean argumentIsFunctional;
        boolean bl;
        FirExpression firExpression2;
        FirExpression firExpression3;
        if (PostponedArgumentsKt.isBuiltinFunctionalType(candidateExpectedType)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        if (!(obj instanceof FirSimpleFunction)) {
            obj = null;
        }
        FirSimpleFunction firSimpleFunction = (FirSimpleFunction)obj;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction firNamedFunction = firSimpleFunction;
        if (!$this$getExpectedTypeWithSAMConversion.getSamResolver().shouldRunSamConversionForFunction(firNamedFunction)) {
            return null;
        }
        FirExpression firExpression4 = argument;
        if (!(firExpression4 instanceof FirWrappedArgumentExpression)) {
            firExpression4 = null;
        }
        if ((firExpression3 = (FirWrappedArgumentExpression)firExpression4) == null || (firExpression3 = firExpression3.getExpression()) == null) {
            firExpression3 = firExpression2 = argument;
        }
        if (firExpression2 instanceof FirAnonymousFunction || firExpression2 instanceof FirCallableReferenceAccess) {
            bl = true;
        } else {
            FirTypeRef $this$coneTypeSafe$iv = argument.getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            bl = argumentIsFunctional = coneKotlinType != null && PostponedArgumentsKt.isBuiltinFunctionalType(coneKotlinType);
        }
        if (!argumentIsFunctional) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$getExpectedTypeWithSAMConversion.getSamResolver().getFunctionTypeForPossibleSamType(candidateExpectedType);
        if (coneKotlinType == null) {
            return null;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkParameterIsNotNull((Object)$this$getExpectedType, (String)"$this$getExpectedType");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        if (!(!parameter.isVararg() || $this$getExpectedType instanceof FirWrappedArgumentExpression && ((FirWrappedArgumentExpression)$this$getExpectedType).isSpread())) {
            FirTypeRef $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            coneKotlinType = ArgumentsKt.varargElementType(coneKotlinType2, session);
        } else {
            FirTypeRef $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType, FirSession session) {
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType, session);
        if (coneKotlinType == null) {
            String string2 = "Failed to extract! " + TypeRendererKt.render($this$varargElementType) + '!';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneKotlinType;
    }
}

