/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.internal.tasks.testing.operations.TestListenerBuildOperationAdapter;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.build.event.types.DefaultTestOutputDescriptor;
import org.gradle.internal.build.event.types.DefaultTestOutputEvent;
import org.gradle.internal.build.event.types.DefaultTestOutputResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.test.Destination;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestOutputResult;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

class ClientForwardingTestOutputOperationListener
implements BuildOperationListener {
    private final BuildOperationListener delegate;
    private final ProgressEventConsumer eventConsumer;
    private final BuildOperationIdFactory idFactory;

    ClientForwardingTestOutputOperationListener(BuildOperationListener delegate, ProgressEventConsumer eventConsumer, BuildOperationIdFactory idFactory) {
        this.delegate = delegate;
        this.eventConsumer = eventConsumer;
        this.idFactory = idFactory;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        this.delegate.started(buildOperation, startEvent);
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        if (progressEvent.getDetails() instanceof TestListenerBuildOperationAdapter.OutputProgress) {
            TestListenerBuildOperationAdapter.OutputProgress progress = (TestListenerBuildOperationAdapter.OutputProgress)progressEvent.getDetails();
            DefaultTestOutputDescriptor descriptor = new DefaultTestOutputDescriptor((Object)new OperationIdentifier(this.idFactory.nextId()), progress.getTestDescriptorId());
            DefaultTestOutputResult result = new DefaultTestOutputResult(progressEvent.getTime(), progressEvent.getTime(), this.getDestination(progress.getOutput().getDestination()), progress.getOutput().getMessage());
            this.eventConsumer.progress((InternalProgressEvent)new DefaultTestOutputEvent(progressEvent.getTime(), (InternalOperationDescriptor)descriptor, (InternalTestOutputResult)result));
        } else {
            this.delegate.progress(buildOperationId, progressEvent);
        }
    }

    private int getDestination(TestOutputEvent.Destination destination) {
        switch (destination) {
            case StdOut: {
                return Destination.StdOut.getCode();
            }
            case StdErr: {
                return Destination.StdErr.getCode();
            }
        }
        throw new IllegalStateException("Unknown output destination type: " + destination);
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        this.delegate.finished(buildOperation, finishEvent);
    }
}

